<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Assessment;
use App\Models\Assessment_answer;
use App\Models\Assessment_questions;
use App\Models\Assessment_rate_settings;
use App\Models\Therapist;
use App\Models\User_Assessment;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;

class AssessmentController extends Controller
{
    public function questionsHtml(Request $request)
    {
        $count = $request->count;
        $html = '  
                                <div class="fee-box " id="remove-row">
                                    <div class="row question" id="question1">
                                        <div class="col-12 col-md-10 col-xl-11">
                                            <div class="form-group local-forms">
                                                <label>Question <span class="login-danger">*</span></label>
                                                <input class="form-control" required name="question[]" type="text">
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2 col-xl-1">
                                            <div class="add-group">
                                                <a href=" javascript:void(0);" id="remove" class=" btn btn-primary ms-2"> <img src="' . asset('assets/img/icons/trash.svg') . '" alt> </a>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="page-table-header mb-5">
                                        <div class="row align-items-center">
                                            <div class="col">
                                                <div class="doctor-table-blk">
                                                    <h3> Answers</h3>

                                                </div>
                                            </div>
                                            <div class="col-auto text-end float-end ms-auto download-grp add-group">
                                                <a href="javascript:void(0);" title="Add more fee details" data-id="' . $count . '" class="btn btn-primary add-answer ms-2"><img src="' . asset('assets/img/icons/plus.svg') . '" alt></a>
                                            </div>
                                        </div>
                                    </div>


                                    <div class="answer" id="remove-row-answer' . $count . '">
                                        <div class="row answer' . $count . '" >
                                           <div class="col-12 col-md-8 col-xl-9">
                                                <div class="form-group local-forms">
                                                    <label>Answer <span class="login-danger">*</span></label>
                                                    <input class="form-control" required name="answer[' . $count . '][0]" type="text" placeholder="Enter answer">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-2 col-xl-2">
                                                <div class="form-group local-forms">
                                                    <label>Rate<span class="login-danger">*</span></label>
                                                    <input class="form-control" required name="rate[' . $count . '][0]" type="text" placeholder="Enter rate">
                                                </div>
                                            </div>

                                            <div class="col-12 col-md-2 col-xl-1">
                                                <div class="add-group">
                                                    <a href=" javascript:void(0);" id="remove-answer" class=" btn btn-primary ms-2"> <img src="' . asset('assets/img/icons/trash.svg') . '" alt> </a>
                                                </div>
                                            </div>
                                        </div>                                 
                                    </div>
                                     <div id="more-answer' . $count . '"></div>
                                </div>';

        return  response()->json($html);
    }

    public function answerHtml(Request $request)
    {
        $count = $request->count;
        $qcount = $request->qcount;
        $html = '   <div class="answer" id="remove-row-answer' . $count . '" >
           <div class="row answer' . $qcount . '" >
                                            <div class="col-12 col-md-8 col-xl-9">
                                                <div class="form-group local-forms">
                                                    <label>Answer <span class="login-danger">*</span></label>
                                                    <input class="form-control" required name="answer[' . $qcount . '][' . $count . ']" type="text" placeholder="Enter answer">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-2 col-xl-2">
                                                <div class="form-group local-forms">
                                                    <label>Rate<span class="login-danger">*</span></label>
                                                    <input class="form-control" required name="rate[' . $qcount . '][' . $count . ']" type="text" placeholder="Enter rate">
                                                </div>
                                            </div>
                                            <div class="col-12 col-md-2 col-xl-1">
                                                <div class="add-group">
                                                    <a href=" javascript:void(0);"  data-id="' . $count . '" class=" btn btn-primary ms-2 remove-answer"> <img src="' . asset('assets/img/icons/trash.svg') . '" alt> </a>
                                                </div>
                                            </div>
                                            </div>
                                        </div>';

        return  response()->json($html);
    }

    public function settingsHtml(Request $request)
    {
        $count = $request->count;

        $html = '    <div class="fee-box " id="remove-row-settings">
                                    <div class="row settings" >
                                        <div class="col-12 col-md-2 col-xl-2">
                                            <div class="form-group local-forms">
                                                <label>start rate<span class="login-danger">*</span></label>
                                                <input class="form-control" required name="start_rate[]" type="text">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-2 col-xl-2">
                                            <div class="form-group local-forms">
                                                <label>End Rate<span class="login-danger">*</span></label>
                                                <input class="form-control" required name="end_rate[]" type="text">
                                            </div>
                                        </div>

                                        <div class="col-12 col-md-2 col-xl-2 ">
                                            <div class="form-group local-forms">
                                                <label>Comment/ Status<span class="login-danger">*</span></label>
                                                <input class="form-control" required name="comment[]" type="text">
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-5 col-xl-5 ">
                                            <div class="form-group local-forms">
                                                <label>Description<span class="login-danger">*</span></label>
                                                <textarea class="form-control" name="status_description[]"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-2 col-xl-1">
                                            <div class="add-group">
                                                <a href=" javascript:void(0);" id="remove-settings" class=" btn btn-primary ms-2"> <img src="' . asset('assets/img/icons/trash.svg') . '" alt> </a>
                                            </div>
                                        </div>
                                    </div>

                                </div>';

        return  response()->json($html);
    }

    public function saveAssessment(Request $request)
    {


        try {
            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/assessment'), $image);
            }
            // ******** Image uploade end ********
            $slug = SlugService::createSlug(Assessment::class, 'slug', $request->title);
            $assessment = new Assessment();
            $assessment->title = $request->title;
            $assessment->slug = $slug;
            $assessment->image = $image;
            $assessment->time_duration = $request->time;
            $assessment->recommended_therapist = json_encode($request->provider);
            $assessment->recommended_blogs = json_encode($request->blogs);
            $assessment->color = $request->color;
            $assessment->save();
            if (!$assessment) {
                return false;
            }

            $question_count = count($request->question);

            for ($i = 0; $i < $question_count; $i++) {
                $questions = new Assessment_questions();
                $questions->assessment_id  = $assessment->id;
                $questions->question = $request->question[$i];
                $questions->save();
                $answer_count = count($request->answer[$i]);

                for ($j = 0; $j < $answer_count; $j++) {
                    $answers = new Assessment_answer();
                    $answers->assessment_id  = $assessment->id;
                    $answers->assessment_question_id  = $questions->id;
                    $answers->answer = $request->answer[$i][$j];
                    $answers->rate = $request->rate[$i][$j];
                    $answers->save();
                }
                if (!$answers) {
                    return false;
                }
            }
            if (!$questions) {
                return false;
            }



            $answer_count = count($request->start_rate);
            for ($i = 0; $i < $answer_count; $i++) {
                $settings = new Assessment_rate_settings();
                $settings->assessment_id  = $assessment->id;
                $settings->start_rate  = $request->start_rate[$i];
                $settings->end_rate = $request->end_rate[$i];
                $settings->status = $request->comment[$i];
                $settings->status_description = $request->status_description[$i];
                $settings->save();
            }
            if (!$settings) {
                return false;
            } else {
                return true;
            }
            //  return back()->with('success', "Service Added Successfully");
        } catch (QueryException $e) {
            return $e->getMessage();
            // return back()->with('error', $e->getMessage());
        }
    }


    public function updateAssessment(Request $request)
    {


        try {
            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/assessment'), $image);
                $assessment = Assessment::where('id', $request->id)
                    ->update([
                        'image' => $image
                    ]);
            }
            // ******** Image uploade end ********
            $data = Assessment::where('id', $request->id)->first();

            if ($request->title != $data->title) {
                $slug = SlugService::createSlug(Assessment::class, 'slug', $request->title);
            } else {
                $slug = $data->slug;
            }
            $assessment = Assessment::where('id', $request->id)
                ->update([
                    'title' => $request->title,
                    'slug' => $slug,
                    'time_duration' => $request->time,
                    'recommended_therapist' => json_encode($request->provider),
                    'recommended_blogs' => json_encode($request->blogs),
                    'color' => $request->color,
                ]);
            if (!$assessment) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function updateAssessmentSettings(Request $request)
    {
        try {
            $answer_count = count($request->settings_id);
            for ($i = 0; $i < $answer_count; $i++) {
                $ex_settings = Assessment_rate_settings::where('id', $request->settings_id[$i])
                    ->update([
                        'start_rate' => $request->ex_start_rate[$i],
                        'end_rate' => $request->ex_end_rate[$i],
                        'status' => $request->ex_comment[$i],
                        'status_description' => $request->ex_status_description[$i]
                    ]);
            }
            if (!$ex_settings) {
                return false;
            }

            if (!empty($request->start_rate)) {
                $answer_count = count($request->start_rate);
                for ($i = 0; $i < $answer_count; $i++) {
                    $settings = new Assessment_rate_settings();
                    $settings->assessment_id  = $request->assessment_id;
                    $settings->start_rate  = $request->start_rate[$i];
                    $settings->end_rate = $request->end_rate[$i];
                    $settings->status = $request->comment[$i];
                    $settings->status_description = $request->status_description[$i];
                    $settings->save();
                }
                if (!$settings) {
                    return false;
                } else {
                    return true;
                }
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function updateAssessmentQandA(Request $request)
    {

        $question_count = count($request->question_id);

        for ($i = 0; $i < $question_count; $i++) {

            $ex_questions = Assessment_questions::where('id', $request->question_id[$i])
                ->update([
                    'question' => $request->ex_question[$i],
                ]);

            $answer_count = count($request->answer_id[$i]);

            for ($j = 0; $j < $answer_count; $j++) {
                $ex_answers = Assessment_answer::where('id', $request->answer_id[$i][$j])
                    ->update([
                        'answer' => $request->ex_answer[$i][$j],
                        'rate' => $request->ex_rate[$i][$j]
                    ]);
                if (!$ex_answers) {
                    return false;
                }
            }


            if (!empty($request->answer[$i])) {

                $answer_count = count($request->answer[$i]);

                for ($j = $j, $k = 0; $k < $answer_count; $j++, $k++) {

                    $answers = new Assessment_answer();
                    $answers->assessment_id  = $request->assessment_id;
                    $answers->assessment_question_id  = $request->question_id[$i];
                    $answers->answer = $request->answer[$i][$j];
                    $answers->rate = $request->rate[$i][$j];
                    $answers->save();

                    if (!$answers) {
                        return false;
                    }
                }

                if (!$ex_questions) {
                    return false;
                }
            }
        }


        if (!empty($request->question)) {
            $question_count = count($request->question);
            $ci = $i;
            for ($k = 0, $i = $ci; $k < $question_count; $k++, $i++) {

                $questions = new Assessment_questions();
                $questions->assessment_id  = $request->assessment_id;
                $questions->question = $request->question[$k];
                $questions->save();


                if (!empty($request->answer[$i])) {
                    $answer_count = count($request->answer[$i]);

                    for ($j = 0; $j < $answer_count; $j++) {
                        $answers = new Assessment_answer();
                        $answers->assessment_id  = $request->assessment_id;
                        $answers->assessment_question_id  = $questions->id;
                        $answers->answer = $request->answer[$i][$j];
                        $answers->rate = $request->rate[$i][$j];
                        $answers->save();
                        if (!$answers) {
                            return false;
                        }
                    }
                }
                if (!$questions) {
                    return false;
                } else {
                    return true;
                }
            }
        } else {
            return true;
        }
    }

    public function getAssessment(Request $request)
    {
        if ($request->ajax()) {
            $data = Assessment::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
                     <a href="' . route('admin.edit-assessment', ['slug' => $data->slug]) . '"  class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('title', function ($data) {
                    $html = '<a href="' . route('admin.view-service', ['slug' => $data->slug]) . '"><img width="28" height="28" src="' . asset('assets/uploads/assessment/' . $data->image) . '" class="rounded-circle m-r-5" alt="">' . $data->title . '</a>';
                    return   $html;
                })

                ->addColumn('users', function ($data) {
                    $html = '<a href="' . route('admin.view-assessment', ['slug' => $data->id]) . '"  class="text-muted"> <span class="badge badge-primary">' . count($data->userAssessment) . '</span></a>';
                    return $html;
                })

                ->addColumn('status', function ($data) {
                    $status = '';
                    $class = '';
                    if ($data->status == 'ACTIVE') {
                        $class = "success";
                        $val = 'BLOCKED';
                    } else {
                        $class = "danger";
                        $val = 'ACTIVE';
                    }
                    return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $data->status . '</span></a>';
                })
                ->editColumn('checkbox', static function ($data) {
                    return '<input type="checkbox" name="datatablecheckbox[]" class="datatablecheckbox" value="' . $data->id . '"/>';
                })->rawColumns(['checkbox'])

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function editAssessment(Request $request)
    {

        $data = Assessment::where('slug', $request->slug)->first();

        return view('admin.assessment.edit', ['data' => $data]);
    }
    public function viewAssessment(Request $request)
    {
        return view('admin.assessment.view', ['id' => $request->slug]);
    }
    public function delete(Request $request)
    {
        try {
            $data = Assessment::where('id', $request->id)->first();

            if ((file_exists(public_path('assets/uploads/assessment/' . $data->image))) && ($data->image != NULL)) {
                unlink("assets/uploads/assessment/" . $data->image);
            }

            $res = Assessment::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function deleteMultiple(Request $request)
    {

        $ids = $request->ids;

        foreach ($ids as $id) {
            $data = Assessment::whereRaw('id = ?', $id)->first();
            if (file_exists(public_path('assets/uploads/assessment/' . $data->image)) && ($data->image != null)) {
                unlink("assets/uploads/assessment/" . $data->image);
            }
        }
        $res = Assessment::whereIn('id',  $ids)->delete();
        return $res;
    }

    public function deleteQuestion(Request $request)
    {
        try {
            $res = Assessment_questions::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function deleteAnswer(Request $request)
    {
        try {
            $res = Assessment_answer::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function deleteSetting(Request $request)
    {
        try {
            $res = Assessment_rate_settings::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function getUserAssessment(Request $request)
    {
        if ($request->ajax()) {
            $data = User_Assessment::where('user_id', $request->slug)->orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
          <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getQuestionId" class="text-muted" data-bs-toggle="modal" data-bs-target="#question_answer' . $data->id . '"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                         <div id="question_answer' . $data->id . '" class="modal fade delete-modal" role="dialog">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content ">
                <div class="modal-header text-center"><h4>  Attended  Question and Answers </h4>
                 <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">x</a>
                     </div>
                </div>
                    <div class="modal-body ">';
                    foreach ($data->userAssessmentQandA as $key => $item) {
                        $actionBtn .=     ' <div class="invoice-terms">
<h6>' . $key + 1 . '. ' .  $item->question . '</h6>
<p class="mb-0">&nbsp;&nbsp;&nbsp;&nbsp;' . $item->answer . '</p>
</div>';
                    }
                    $actionBtn .=   ' 
                       
                    </div>
                </div>
            </div>
        </div>   ';
                    return $actionBtn;
                })
                ->addColumn('title', function ($data) {
                    $html = '<a href="javascript:void(0);"><img width="28" height="28" src="' . asset('assets/uploads/assessment/' . $data->assessment->image) . '" class="rounded-circle m-r-5" alt="">' . $data->assessment->title . '</a>';
                    return   $html;
                })
                ->addColumn('rate', function ($data) {
                    return $data->total_rate;
                })

                ->addColumn('date', function ($data) {
                    $html = "<p>" . date('d M Y', strtotime($data->created_at)) . '</p>';

                    return $html;
                })
                ->addColumn('status', function ($data) {
                    $total_count = count($data->assessment->questions);
                    $attended_question_count = count($data->userAssessmentQandA);

                    $status = '';
                    $class = '';
                    if ($total_count > $attended_question_count) {
                        $class = "danger";
                        $status = 'Not Completed';
                    } elseif ($total_count == $attended_question_count) {
                        $class = "success";
                        $status = 'Completed';
                    }
                    return '<a href="javascript:void(0)"  id="status"><span class="badge badge-' . $class . '">' . $status . '</span></a>';
                })

                ->editColumn('checkbox', static function ($data) {
                    return '<input type="checkbox" name="datatablecheckbox[]" class="datatablecheckbox" value="' . $data->id . '"/>';
                })->rawColumns(['checkbox'])

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function getAssessmentList(Request $request)
    {
        if ($request->ajax()) {
            $data = User_Assessment::where('assessment_id', $request->id)->orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
          <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getQuestionId" class="text-muted" data-bs-toggle="modal" data-bs-target="#question_answer' . $data->id . '"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                         <div id="question_answer' . $data->id . '" class="modal fade delete-modal" role="dialog">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content ">
                <div class="modal-header text-center"><h4>  Attended  Question and Answers </h4>
                 <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">x</a>
                     </div>
                </div>
                    <div class="modal-body ">';
                    foreach ($data->userAssessmentQandA as $key => $item) {
                        $actionBtn .=     ' <div class="invoice-terms">
<h6>' . $key + 1 . '. ' .  $item->question . '</h6>
<p class="mb-0">&nbsp;&nbsp;&nbsp;&nbsp;' . $item->answer . '</p>
</div>';
                    }
                    $actionBtn .=   ' 
                       
                    </div>
                </div>
            </div>
        </div>   ';
                    return $actionBtn;
                })
                ->addColumn('user', function ($data) {
                    if ($data->user->image != NULL) {
                        $img = asset('assets/uploads/user/' . $data->image);
                    } else {
                        $img = asset('assets/img/no-image-available.jpg');
                    }
                    $html = '<a href="javascript:void(0);"><img width="28" height="28" src="' . $img . '" class="rounded-circle m-r-5" alt="">' . $data->user->SMS . '</a>';
                    return   $html;
                })
                ->addColumn('rate', function ($data) {
                    return $data->total_rate;
                })

                ->addColumn('date', function ($data) {
                    $html = "<p>" . date('d M Y', strtotime($data->created_at)) . '</p>';

                    return $html;
                })
                ->addColumn('status', function ($data) {
                    $total_count = count($data->assessment->questions);
                    $attended_question_count = count($data->userAssessmentQandA);

                    $status = '';
                    $class = '';
                    if ($total_count > $attended_question_count) {
                        $class = "danger";
                        $status = 'Not Completed';
                    } elseif ($total_count == $attended_question_count) {
                        $class = "success";
                        $status = 'Completed';
                    }
                    return '<a href="javascript:void(0)"  id="status"><span class="badge badge-' . $class . '">' . $status . '</span></a>';
                })

                ->editColumn('checkbox', static function ($data) {
                    return '<input type="checkbox" name="datatablecheckbox[]" class="datatablecheckbox" value="' . $data->id . '"/>';
                })->rawColumns(['checkbox'])

                ->escapeColumns([])

                ->make(true);
        }
    }
}
