<?php

namespace App\Http\Controllers\Admin;

use App\Console\Commands\Appointment;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Therapist;
use App\Models\Service;
use App\Models\ServiceFeeStructure;
use App\Models\Slot;
use App\Models\User;
use App\Models\CallMethods;
use App\Models\Appointments;
use App\Models\WorkingHours;
use App\Models\SlotShedule;
use Illuminate\Database\Eloquent\Builder;
use Carbon\CarbonPeriod;
use Carbon\Carbon;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;
use App\Models\PaymentDetails;
use App\Models\Prescription;
use App\Models\ConsulationNote;
use App\Models\PushNotification;

class AppoinmentController extends Controller
{
    public function index(Request $request)
    {

        return view('admin.appoinment.add');
    }
    public function saveAppoinment(Request $request)
    {
        $booking_date = str_replace('/', '-', $request->booking_date);
        $booking_date = date("Y-m-d", strtotime($booking_date));
        $dob = str_replace('/', '-', $request->dob);
        $dob = date("Y-m-d", strtotime($dob));

        try {
            if (!isset($request->user)) {
                $name = $request->first_name . ' ' . $request->last_name;
                $slug = SlugService::createSlug(
                    User::class,
                    'slug',
                    $name
                );
                $pn = 'P' . random_int(000000000000000000, 999999999999999999);
                $user = new User();
                $user->Patient_Identification_Number = $pn;
                $user->First_Name = $request->first_name;
                $user->Last_Name = $request->last_name;
                $user->slug = $slug;
                $user->Email = $request->email;
                $user->Phone_Code = $request->code;
                $user->phone = $request->phone;
                $user->Gender = $request->gender;
                $user->DOB = $dob;
                $user->save();
                $user = $user->id;
            } else {
                $user = $request->user;
            }
            $appointment = new Appointments();
            $appointment->Appointment_Type = $request->call_type;
            $appointment->Appointment_Date = $booking_date;
            $appointment->Appointment_Time = $request->slot;
            $appointment->Appointment_Booked_Date = date("Y-m-d", strtotime(now()));
            $appointment->Appointment_Booked_Time = date("H:i:s", strtotime(now()));
            $appointment->therapist_id = $request->therapist;
            $appointment->service_id = $request->service;
            $appointment->slot_id = $request->slot_id;
            $appointment->user_id = $user;
            $appointment->fee = $request->fee;
            $appointment->save();
            if ($appointment) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Your Appointment is Booked Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function searchTherapist(Request $request)
    {
        if (isset($request->search) || isset($request->provider_category)) {
            $therapist = Therapist::query()
                ->when(
                    $request->search,
                    function (Builder $builder) use ($request) {
                        $builder->where('full_name', 'like', "%{$request->search}%")
                            // ->orWhere('employee_id', 'like', "%{$request->search}%")
                            ->orWhere('designation', 'like', "%{$request->search}%");
                    }
                )
                ->where('provider_category_id', $request->provider_category)
                ->get();
        } else {
            $therapist = Therapist::get();
        }

        $html = '';
        foreach ($therapist as $data) {
            if ($data->image != NULL) {
                $img = asset('assets/uploads/therapist/' . $data->image);
            } else {
                if ($data->gender == 'MALE') {
                    $img = asset('assets/img/male-avatar.jpg');
                } else {
                    $img = asset('assets/img/female-avatar.webp');
                }
            }

            $html .= ' 
            <div class="col-sm-6 col-lg-6 col-xl-6 d-flex" id="therapist-n-active' . $data->id . '">
                   
                                            <div class="card invoices-grid-card w-100">
                                                <div class="card-header d-flex justify-content-between align-items-center">
                                                    <button class="custom-badge status-gray re-shedule">' . ucfirst($data->designation) . '</button>
                                                </div>
                                                <div class="card-middle">
                                                    <h2 class="card-middle-avatar">
                                                        <a href="javascript:void(0);" class="next_button therapist" data-id="' . $data->id . '">
                                                        <img class="avatar avatar-sm me-2 avatar-img rounded-circle" src="' . $img . '" alt="User Image"> ' . ucfirst($data->full_name) . '
                                                        </a>
                                                    </h2>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row align-items-center">
                                                        <div class="col">
                                                            <span><i class="fas fa-calendar-alt"></i> Exp: ' . $data->experience . ' yrs</span>

                                                        </div>
                                                        <div class="col-auto">
                                                            <span><i class="fa fa-user-doctor"></i> ' . $data->providerCategory->name . ' </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                  
                                    </div>
                                    ';
        }
        return  response()->json($html);
    }
    public function searchTherapistForTherapist(Request $request)
    {
        $category_id = Therapist::where('id', $request->therapist_id)->pluck('provider_category_id')->first();
        if (isset($request->service_id) || isset($request->therapist_id)) {
            $therapist = Therapist::query()
                ->when(
                    $request->service_id,
                    function (Builder $builder) use ($request) {
                        $builder->whereJsonContains('services', $request->service_id);
                    }
                )
                ->where('provider_category_id', $category_id)
                ->where('id', '!=', $request->therapist_id)
                ->get();
        } else {
            $therapist = Therapist::get();
        }

        $html = '';
        foreach ($therapist as $data) {
            if ($data->image != NULL) {
                $img = asset('assets/uploads/therapist/' . $data->image);
            } else {
                if ($data->gender == 'MALE') {
                    $img = asset('assets/img/male-avatar.jpg');
                } else {
                    $img = asset('assets/img/female-avatar.webp');
                }
            }

            $html .= ' 
            <div class="col-sm-4 col-lg-4 col-xl-4 d-flex">
                   
                                            <div class="card invoices-grid-card w-100">
                                                <div class="card-header d-flex justify-content-between align-items-center">
                                                    <button class="custom-badge status-gray re-shedule">' . ucfirst($data->designation) . '</button>
                                                </div>
                                                <div class="card-middle">
                                                    <h2 class="card-middle-avatar">
                                                        <a href="javascript:void(0);" class="next_button therapist" data-id="' . $data->id . '">
                                                        <img class="avatar avatar-sm me-2 avatar-img rounded-circle" src="' . $img . '" alt="User Image"> ' . ucfirst($data->full_name) . '
                                                        </a>
                                                    </h2>
                                                </div>
                                                <div class="card-body">
                                                    <div class="row align-items-center">
                                                        <div class="col">
                                                            <span><i class="fas fa-calendar-alt"></i> Exp: ' . $data->experience . ' yrs</span>

                                                        </div>
                                                        <div class="col-auto">
                                                            <span><i class="fa fa-user-doctor"></i> ' . $data->providerCategory->name . ' </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                  
                                    </div>
                                    ';
        }
        return  response()->json($html);
    }
    public function searchUser(Request $request)
    {
        if (isset($request->search) || isset($request->provider_category)) {
            $user = User::query()
                ->when(
                    $request->search,
                    function (Builder $builder) use ($request) {
                        $builder->where('First_Name', 'like', "%{$request->search}%")
                            // ->orWhere('employee_id', 'like', "%{$request->search}%")
                            ->orWhere('Last_Name', 'like', "%{$request->search}%");
                    }
                )
                ->get();
        } else {
            $user = User::get();
        }

        $html = '';
        foreach ($user as $data) {
            if ($data->image != NULL) {
                $img = asset('assets/uploads/usert/' . $data->image);
            } else {
                if ($data->gender == 'MALE') {
                    $img = asset('assets/img/male-avatar.jpg');
                } else {
                    $img = asset('assets/img/female-avatar.webp');
                }
            }

            $html .= ' 
             <div class="next_button col-sm-6 col-lg-6 col-xl-6 d-flex">
                                                        <!-- <a href="#" class="user_div" data-id="' . $data->id . '"> -->
                                                        <div class="card invoices-grid-card w-100">
                                                            <div class="card-header d-flex justify-content-between align-items-center">
                                                                <button class="custom-badge status-gray re-shedule">' . $data->Patient_Identification_Number . '</button>
                                                            </div>
                                                            <div class="card-middle">
                                                                <h2 class="card-middle-avatar">
                                                                    <a href="javascript:void(0);" class="user_div" data-id="' . $data->id . '"><img class="avatar avatar-sm me-2 avatar-img rounded-circle" src="' . $img . '" alt="User Image"> ' . ucfirst($data->First_Name) . ' ' . ucfirst($data->Last_Name) . '
                                                                    </a>
                                                                </h2>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="row align-items-center">
                                                                    <div class="col">
                                                                        <span><img src="' . asset('assets/img/icons/menu-icon-09.svg') . '" alt=""> ₹500</span>

                                                                    </div>
                                                                    <div class=" col-auto">
                                                                        <span><i class="fa fa-phone"></i> ' . $data->phone . '</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- </a> -->

                                                    </div>
                                    ';
        }
        return  response()->json($html);
    }
    public function searchTherapistService(Request $request)
    {
        $html = '';
        if (isset($request->id)) {
            $therapist = Therapist::select('id', 'services')->where('id', $request->id)
                ->first();
        } else {
            $html .= "Please select a therapist";
        }


        foreach ($therapist->services as $item) {
            $data = Service::where('id', $item)->first();
            if ($data->image != NULL) {
                $img = asset('assets/uploads/service/' . $data->image);
            } else {
                if ($data->gender == 'MALE') {
                    $img = asset('assets/img/no-image-available.jpg');
                } else {
                    $img = asset('assets/img/no-image-available.jpg');
                }
            }


            $html .= '     <div class="next_button col-sm-6 col-lg-6 col-xl-4 d-flex">
                                    <a href="javascript:void(0);" class="service" data-id="' . $data->id . '">
                                        <div class="card invoices-grid-card w-100">
                                            <div class="card wallet-widget">
                                                <div class="circle-bar circle-bar2">
                                                    <div class="circle-graph2" data-percent="66"><canvas width="400" height="400"></canvas>
                                                        <b><img src="' . $img . '" class="avatar avatar-sm me-2 avatar-img rounded-circle" alt=""></b>
                                                    </div>
                                                </div>
                                                <div class="main-limit">
                                                    <h4>' . $data->service_name . '</h4>
                                                </div>
                                            </div>
                                        </div>
                                    </a>

                                </div>
                                ';
        }

        return  response()->json($html);
    }

    public function searchServiceMethods(Request $request)
    {
        $html = '';
        $therapist = Therapist::where('id', $request->therapist)
            ->first();

        $data = ServiceFeeStructure::where('service_id', $request->id)->where('provider_category_id', $therapist->provider_category_id)->get();

        foreach ($data as $key => $item) {
            $call_methods[$key] = [
                'id' => $item->callMethod->id,
                'name' => $item->callMethod->name,
                'fee' => $item->rate
            ];
        }

        //$item = collect($call_methods)->unique()->values();


        foreach ($call_methods as $data) {
            if ($data['name'] == 'Video') {
                $icon = 'video';
            } elseif ($data['name'] == 'Audio') {
                $icon = 'phone-volume';
            } elseif ($data['name'] == 'Chat') {
                $icon = 'comment';
            }
            $html .= ' <div class="next_button col-sm-6 col-lg-6 col-xl-4 d-flex">
                                    <a href="javascript:void(0);" class="callmethod"  data-id="' . $data['id'] . '"   data-value="' . $data['fee'] . '" >
                                        <div class="card invoices-grid-card w-100">
                                            <div class="card wallet-widget">
                                            <div class="circle-bar circle-bar2">
                                                    <div class="circle-graph2" data-percent="66"><canvas width="400" height="400"></canvas>
                                                        <b><i class="fas fa-' . $icon . '"></i></b>
                                                    </div>
                                                </div>
                                                <div class="main-limit">
                                                    <h4>' . $data['name'] . '</h4>
                                                    <h3 style="padding-top: 10px;
    font-size: 20px;"><span class="negative-view">₹' . $data['fee'] . '</span> </h3>
                                                    
                                                </div>
                                            </div>
                                        </div>
                                    </a>

                                </div>';
        }
        return  response()->json($html);
    }

    public function searchSlot(Request $request)
    {
        $html = '';
        $booking_date = str_replace('/', '-', $request->bookingDate);
        $booking_date = date("Y-m-d", strtotime($booking_date));
        $error = '   <p class="text-center"><b>No slots Found</b></p>';
        $day = Carbon::createFromFormat('d/m/Y', $request->bookingDate)->format('l');
        $service = $request->service;
        $slot = Slot::where('therapist_id', $request->therapist)->first();
        if ($slot) {
            $workinghours = WorkingHours::where('slot_id', $slot->id)
                ->where('day', $day)
                ->where('service_id', $service)
                ->first();


            if ($workinghours) {
                $slotlist = SlotShedule::where('slot_id', $workinghours->id)->where('call_method_id', $request->callmethod)->first();

                if ($slotlist) {
                    $html .= '   
                                    <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Available time slots</th>
                                            </tr>
                                        </thead>
                                        <tbody>';
                    $html .= '<tr> <td>';
                    $i = 0;
                    foreach (json_decode($slotlist->slots) as $sk => $x) {

                        $booked = Appointments::where('slot_id', $slotlist->id)->where('Appointment_Time', $x)->where('Appointment_Date', $booking_date)->first();

                        $color = '';
                        $title = '';
                        $disabled = '';
                        $slot_flag = 0;
                        //***** */
                        $bookedslots = Appointments::where('therapist_id', $request->therapist)->where('Appointment_Date', $booking_date)->get();
                        if ($bookedslots) {
                            foreach ($bookedslots as $bookedslot) {
                                $booked_slotlist = SlotShedule::where('id', $bookedslot->slot_id)->first();
                                $flag = 0;
                                $next_booked_slot = '';
                                $prev_slot = '';
                                $prev = '';

                                foreach (json_decode($booked_slotlist->slots) as $k => $bs) {
                                    if ($bookedslot->Appointment_Time == $bs) {

                                        $flag = 1;
                                        continue;
                                    } else {
                                        if ($flag == 1) {
                                            $prev = $prev_slot;
                                            $next_booked_slot = $bs;
                                            break;
                                        }
                                    }
                                    $prev_slot = $bs;
                                }
                                $prev = $prev_slot;

                                $time1  = date("H:i", strtotime($bookedslot->Appointment_Time));
                                $time2 = date("H:i", strtotime($next_booked_slot));
                                $time3 = date("H:i", strtotime($prev));
                                $checkedtime = date("H:i", strtotime($x));

                                if (($checkedtime >= $time1 && $checkedtime < $time2) || ($checkedtime > $time3 && $checkedtime <= $time1)) {
                                    $slot_flag = 1;
                                    break;
                                }
                            }
                        }
                        if ($slot_flag == 1) {

                            continue;
                        }
                        //*** */
                        if ($booked) {

                            if ($booked->Appointment_Status == 'Awaiting') {
                                $color = 'orange';
                                $title = 'Awaiting';
                                $disabled = 'disabled';
                            } elseif ($booked->Appointment_Status == 'Completed') {
                                $color = 'green';
                                $title = 'Completed';
                                $disabled = 'disabled';
                            } elseif ($booked->Appointment_Status == 'Concluded') {
                                $color = 'blue';
                                $title = 'Concluded';
                                $disabled = 'disabled';
                            } elseif ($booked->Appointment_Status == 'Rejected') {
                                $color = 'pink';
                                $title = 'Rejected';
                                $disabled = 'disabled';
                            }
                        }
                        $html .= ' <button class="custom-badge status-' . $color . ' slot-btn"  data-id="' . $slotlist->id . '" title="' . $title . '" data-value="' . $x . '"  "' . $disabled . '">' . $x . '</button>';
                    }
                    $html .= ' </td>  </tr>';

                    $html .= '      </tbody>
                                    </table>
                                ';
                } else {
                    $html .= $error;
                }
            } else {
                $html .= $error;
            }
        } else {
            $html .= $error;
        }

        return  response()->json($html);
    }

    public function paymentSummary(Request $request)
    {
        // print_r($request->all());     
        $html = '';
        $therapist = Therapist::select('id', 'full_name')->where('id', $request->therapist)->first();
        $service = Service::select('id', 'service_name')->where('id', $request->service)->first();

        $html = '<div class="invoice-total-card">
                                                    <div class="invoice-total-box">
                                                        <div class="invoice-total-inner">
                                                            <p>Therapist <span>' . $therapist->full_name . '</span></p>
                                                            <p>Date <span>' . $request->bookingDate . '</span></p>
                                                            <p>Time <span>' . $request->slot . '</span></p>
                                                            <div class="invoice-total-footer">
                                                                <p><b>Service</b></p>
                                                                <p class="mb-0">' . $service->service_name . ' : ₹' . $request->fee . '</p>
                                                            </div>
                                                        </div>
                                                        <div class="invoice-total-footer">
                                                            <h4>Total Amount <span>₹' . $request->fee . '</span></h4>
                                                        </div>
                                                    </div>
                                                </div>';

        return  response()->json($html);
    }

    public function getAppoinments(Request $request)
    {
        if ($request->ajax()) {
            $data = Appointments::orderBy('id', 'DESC')->get();

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data->id]) . '"   class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('service', function ($data) {
                    return $data->service->service_name;
                })

                ->addColumn('username', function ($data) {

                    if (empty($data->user)) {
                        $img = asset('assets/img/male-avatar.jpg');
                        $name = "USER";
                    } else {
                        if ($data->user->image != NULL) {
                            $img = asset('assets/uploads/user/' . $data->user->image);
                            $name = $data->user->First_Name . $data->user->Last_Name;
                        } else {
                            $name = $data->user->First_Name;
                            if ($data->user->gender == 'MALE') {
                                $img = asset('assets/img/male-avatar.jpg');
                            } else {
                                $img = asset('assets/img/female-avatar.webp');
                            }
                        }
                    }
                    $html = '<div class="chat-user-group d-flex align-items-center">
                                <div class="img-users call-user">
                                <a href=""><img src="' . $img . '" alt="img"></a>
                                </div>
                                <div class="chat-users">
                                <div class="user-titles d-flex">
                                <h5>' . $name  . ' </h5>
                                </div>
                                </div>
                                </div>';

                    return   $html;
                })

                ->addColumn('therapist', function ($data) {
                    if ($data->therapist->image != NULL) {
                        $name = $data->therapist->prefix . " " . $data->therapist->full_name;
                        $img = asset('assets/uploads/therapist/' . $data->therapist->image);
                    } else {
                        $name = "USER NOT fOUND";
                        if ($data->therapist->gender == 'MALE') {
                            $img = asset('assets/img/male-avatar.jpg');
                        } else {
                            $img = asset('assets/img/female-avatar.webp');
                        }
                    }
                    $html = '<div class="chat-user-group d-flex align-items-center">
                        <div class="img-users call-user">
                        <a href="' . route('admin.view-therapist', ['slug' => $data->therapist->slug]) . '"><img src="' . $img . '" alt="img"></a>
                        </div>
                        <div class="chat-users">
                        <div class="user-titles d-flex">
                        <h5>' . $name . ' </h5>
                        </div>
                        <div class="user-text d-flex">
                        <p>' . $data->therapist->professional_credentials . '</p>
                        </div>
                        </div>
                        </div>';

                    return   $html;
                })


                ->addColumn('status', function ($data) {

                    return $data->Appointment_Status;
                })
                ->addColumn('date_and_time', function ($data) {
                    $html = "<p> Date:" . date('d M Y', strtotime($data->Appointment_Date)) . '</p>';
                    $html .= "<p> Time:" . $data->Appointment_Time . '</p>';
                    return $html;
                })
                ->addColumn('communication_type', function ($data) {
                    $type = CallMethods::where('id', $data->Appointment_Type)->pluck('name')->first();
                    return $type;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function viewAppoinment(Request $request)
    {
        $data = Appointments::where('id', $request->id)->first();
        return view('admin.appoinment.view', compact('data'));
    }
    public function transferAppoinments(Request $request)
    {
        $data = Appointments::where('id', $request->id)->first();
        return view('admin.appoinment.transfer', compact('data'));
    }
    public function deleteAppoinment(Request $request)
    {
        $data = Appointments::where('id', $request->id)->delete();
        return $data;
    }

    public function previousAppoinments(Request $request)
    {
        if ($request->ajax()) {
            // ****** previuos appoinments *************

            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', $request->slug)->where('Appointment_Date', '<=', date('Y-m-d', strtotime($now)))->orderBy('Appointment_Date', 'DESC')->get();

            foreach ($array as $item) {

                $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();

                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                $time = $item->Appointment_Date . " " . $givenDateTime . ":00";

                $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_slug'] = $item->therapist->slug;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $key++;
                    }
                } else {

                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_slug'] = $item->therapist->slug;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['fee'] = $item->fee;

                    $key++;
                }
            }

            // ********** previuos appoinment end **************

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data['id']]) . '"   class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data['id'] . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('provider', function ($data) {

                    $html = '  <a href="' . route('admin.view-therapist', ['slug' => $data['therapist_slug']]) . '"><img width="28" height="28" src="' . $data['therapist_image'] . '" class="rounded-circle m-r-5" alt> ' . $data['therapist_name'] . '</a>';

                    return   $html;
                })

                ->addColumn('charge', function ($data) {
                    return '₹' . $data['fee'];
                })

                ->addColumn('status', function ($data) {
                    return '<button class="custom-badge status-gray re-shedule">' . $data['Appointment_Status'] . '</button>';
                })
                ->addColumn('start_time', function ($data) {
                    return   $data['start_time'];
                })
                ->addColumn('end_time', function ($data) {
                    return $data['end_time'];
                })
                ->addColumn('date', function ($data) {
                    return $data['Appointment_Date'];
                })
                ->addColumn('call_type', function ($data) {
                    return $data['call_type'];
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function upcomingAppoinments(Request $request)
    {
        if ($request->ajax()) {

            // *********** Upcoming Appoinment ***********************
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('user_id', $request->slug)->where('Appointment_Date', '>=', date('Y-m-d', strtotime($now)))->orderBy('Appointment_Date', 'DESC')->get();
            foreach ($array as $item) {
                $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['therapist_slug'] = $item->therapist->slug;
                        $data[$key]['therapist_name'] = $item->therapist->full_name;
                        $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                        $data[$key]['therapist_designation'] = $item->therapist->designation;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['fee'] = $item->fee;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['therapist_slug'] = $item->therapist->slug;
                    $data[$key]['therapist_name'] = $item->therapist->full_name;
                    $data[$key]['therapist_image'] = asset('assets/uploads/therapist/') . '/' . $item->therapist->image;
                    $data[$key]['therapist_designation'] = $item->therapist->designation;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['fee'] = $item->fee;
                    $key++;
                }
            }

            // *********** Upcoming Appoinment end ***********************

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data['id']]) . '"   class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data['id'] . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('provider', function ($data) {

                    $html = '  <a href="' . route('admin.view-therapist', ['slug' => $data['therapist_slug']]) . '"><img width="28" height="28" src="' . $data['therapist_image'] . '" class="rounded-circle m-r-5" alt> ' . $data['therapist_name'] . '</a>';

                    return   $html;
                })

                ->addColumn('charge', function ($data) {
                    return '₹' . $data['fee'];
                })

                ->addColumn('status', function ($data) {
                    return '<button class="custom-badge status-gray re-shedule">' . $data['Appointment_Status'] . '</button>';
                })
                ->addColumn('start_time', function ($data) {
                    return   $data['start_time'];
                })
                ->addColumn('end_time', function ($data) {
                    return $data['end_time'];
                })
                ->addColumn('date', function ($data) {
                    return $data['Appointment_Date'];
                })
                ->addColumn('call_type', function ($data) {
                    return $data['call_type'];
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    // **** therapist appoinments ****************

    public function previousAppoinmentsTherapist(Request $request)
    {
        if ($request->ajax()) {
            // ****** previuos appoinments *************

            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('therapist_id', $request->id)->where('Appointment_Date', '<=', date('Y-m-d', strtotime($now)))->orderBy('Appointment_Date', 'DESC')->get();

            foreach ($array as $item) {

                $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();

                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                $time = $item->Appointment_Date . " " . $givenDateTime . ":00";

                $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['user_slug'] = $item->user->slug;
                        $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                        $data[$key]['user_image'] = asset('assets/uploads/user/') . '/' . $item->user->image;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $key++;
                    }
                } else {

                    $data[$key]['id'] = $item->id;
                    $data[$key]['user_slug'] = $item->user->slug;
                    $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                    $data[$key]['user_image'] = asset('assets/uploads/user/') . '/' . $item->user->image;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['fee'] = $item->fee;

                    $key++;
                }
            }

            // ********** previuos appoinment end **************

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data['id']]) . '"   class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data['id'] . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('provider', function ($data) {

                    $html = '  <a href="' . route('admin.view-user', ['slug' => $data['user_slug']]) . '"><img width="28" height="28" src="' . $data['user_image'] . '" class="rounded-circle m-r-5" alt> ' . $data['user_name'] . '</a>';

                    return   $html;
                })

                ->addColumn('charge', function ($data) {
                    return '₹' . $data['fee'];
                })

                ->addColumn('status', function ($data) {
                    return '<button class="custom-badge status-gray re-shedule">' . $data['Appointment_Status'] . '</button>';
                })
                ->addColumn('start_time', function ($data) {
                    return   $data['start_time'];
                })
                ->addColumn('end_time', function ($data) {
                    return $data['end_time'];
                })
                ->addColumn('date', function ($data) {
                    return $data['Appointment_Date'];
                })
                ->addColumn('call_type', function ($data) {
                    return $data['call_type'];
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function upcomingAppoinmentsTherapist(Request $request)
    {
        if ($request->ajax()) {

            // *********** Upcoming Appoinment ***********************
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            $data = [];
            $key = 0;
            $array = Appointments::where('therapist_id', $request->id)->where('Appointment_Date', '>=', date('Y-m-d', strtotime($now)))->orderBy('Appointment_Date', 'DESC')->get();
            foreach ($array as $item) {
                $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        continue;
                    } else {
                        $data[$key]['id'] = $item->id;
                        $data[$key]['user_slug'] = $item->user->id;
                        $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                        $data[$key]['user_image'] = asset('assets/uploads/user/') . '/' . $item->user->image;
                        $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                        $data[$key]['start_time'] = $item->Appointment_Time;
                        $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                        $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data[$key]['call_type'] = $item->callMethod->name;
                        $data[$key]['fee'] = $item->fee;
                        $key++;
                    }
                } else {
                    $data[$key]['id'] = $item->id;
                    $data[$key]['user_slug'] = $item->user->id;
                    $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                    $data[$key]['user_image'] = asset('assets/uploads/user/') . '/' . $item->user->image;
                    $data[$key]['Appointment_Date'] = $item->Appointment_Date;
                    $data[$key]['start_time'] = $item->Appointment_Time;
                    $data[$key]['end_time'] = date('h:i A', strtotime($closeTime));
                    $data[$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data[$key]['call_type'] = $item->callMethod->name;
                    $data[$key]['fee'] = $item->fee;
                    $key++;
                }
            }

            // *********** Upcoming Appoinment end ***********************

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-appoinment', ['id' => $data['id']]) . '"   class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data['id'] . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('provider', function ($data) {

                    $html = '  <a href="' . route('admin.view-user', ['slug' => $data['user_slug']]) . '"><img width="28" height="28" src="' . $data['user_image'] . '" class="rounded-circle m-r-5" alt> ' . $data['user_name'] . '</a>';

                    return   $html;
                })

                ->addColumn('charge', function ($data) {
                    return '₹' . $data['fee'];
                })

                ->addColumn('status', function ($data) {
                    return '<button class="custom-badge status-gray re-shedule">' . $data['Appointment_Status'] . '</button>';
                })
                ->addColumn('start_time', function ($data) {
                    return   $data['start_time'];
                })
                ->addColumn('end_time', function ($data) {
                    return $data['end_time'];
                })
                ->addColumn('date', function ($data) {
                    return $data['Appointment_Date'];
                })
                ->addColumn('call_type', function ($data) {
                    return $data['call_type'];
                })
                ->escapeColumns([])

                ->make(true);
        }
    }
    // **** end therapist appoinments ****************

    public function changeAppoinmentStatus(Request $request)
    {
        $SERVER_API_KEY = env('FCM_SERVER_KEY');
        $res = Appointments::where('id', $request->id)
            ->update(['Appointment_Status' => $request->status]);
        if ($request->status == 'Cancel') {
            $item = Appointments::where('id', $request->id)->first();
            PushNotification::create([
                'title' => 'Cancel Appoinment',
                'message' => "Hi, " . $item->user->First_Name . "  " . $item->user->Last_Name . " your appointment on yellowcloud  with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " has been Canceled.",
                'type' => 'Status',
                'appoinment_id' => $item->id
            ]);

            $data = [
                "to" => $item->device_token,
                "notification" => [
                    'title' => 'Appoinment Remainder',
                    'body' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". See you soon!"
                ],
                "data" => [
                    "route" => "notification"
                ]
            ];
            $dataString = json_encode($data);

            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            // Disabling SSL Certificate support temporarly
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
            // Execute post
            $result = curl_exec($ch);
            if ($result === FALSE) {
                die('Curl failed: ' . curl_error($ch));
            }
            // Close connection
            curl_close($ch);
            $this->info($result);
        } else    if ($request->status == 'Resheduled') {
            $item = Appointments::where('id', $request->id)->first();
            PushNotification::create([
                'title' => 'Cancel Appoinment',
                'message' => "Hi, " . $item->user->First_Name . "  " . $item->user->Last_Name . " your appointment on yellowcloud  with " . $item->therapist->prefix . " " . $item->therapist->full_name . " has been Resheduled on " . $item->Appointment_Date . " at " . $item->Appointment_Time . " .",
                'type' => 'C',
                'appoinment_id' => $item->id
            ]);

            $data = [
                "to" => $item->device_token,
                "notification" => [
                    'title' => 'Appoinment Remainder',
                    'body' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". See you soon!"
                ],
                "data" => [
                    "route" => "notification"
                ]
            ];
            $dataString = json_encode($data);

            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            // Disabling SSL Certificate support temporarly
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
            // Execute post
            $result = curl_exec($ch);
            if ($result === FALSE) {
                die('Curl failed: ' . curl_error($ch));
            }
            // Close connection
            curl_close($ch);
            $this->info($result);
        }
        return $res;
    }

    public function resheduleAppoinment(Request $request)
    {

        try {
            $booking_date = str_replace('/', '-', $request->booking_date);
            $booking_date = date("Y-m-d", strtotime($booking_date));

            $res = Appointments::where('id', $request->appoinment_id)->update([
                'Appointment_Date' => $booking_date,
                'Appointment_Time' => $request->slot,
                'Appointment_Status' => 'Resheduled',
                'slot_id' => $request->slot_id
            ]);
            if ($res == 1) {
                return back()->with('success', "Your Appointment resheduled Sucessfully");
            } else {
                return back()->with('error', "Something went Wrong");
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function saveTransferAppoinments(Request $request)
    {

        try {
            $booking_date = str_replace('/', '-', $request->booking_date);
            $booking_date = date("Y-m-d", strtotime($booking_date));

            $res = Appointments::where('id', $request->appoinment_id)->update([
                'Appointment_Date' => $booking_date,
                'Appointment_Time' => $request->slot,
                'therapist_id' => $request->therapist_id,
                'slot_id' => $request->slot_id
            ]);
            if ($res) {
                return response()->json(
                    array(
                        'status' => true,
                        'msg' => "Appointment transferred Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'msg' => "Something went Wrong"
                    ),
                    200
                );
            }

            // if ($res == 1) {
            //     return back()->with('success', "Appointment transferred Sucessfully");
            // } else {
            //     return back()->with('error', "Something went Wrong");
            // }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function addPrescription(Request $request)
    {
        try {
            if ($request->id) {
                $review = Prescription::where('id', $request->id)->update([
                    'therapist_id' => $request->therapist_id,
                    'note' => $request->note
                ]);
            } else {
                $review = new Prescription();
                $review->therapist_id = $request->therapist_id;
                $review->user_id = $request->user_id;
                $review->appoinment_id = $request->appoinment_id;
                $review->note = $request->note;
                $review->save();
            }


            if ($review) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Prescription added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function addConsulation(Request $request)
    {
        try {
            if ($request->id) {
                $review = ConsulationNote::where('id', $request->id)->update([
                    'therapist_id' => $request->therapist_id,
                    'note' => $request->note
                ]);
            } else {
                $review = new ConsulationNote();
                $review->therapist_id = $request->therapist_id;
                $review->user_id = $request->user_id;
                $review->appoinment_id = $request->appoinment_id;
                $review->note = $request->note;
                $review->save();
            }


            if ($review) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Consulation added successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function downloadConsultationNote(Request $request)
    {
        $data = ConsulationNote::where('id', $request->id)->first();
        $age = Carbon::parse($data->user->DOB)->age;
        $name = "eConsultation_" . $data->user->Frist_Name . "_" . $data->user->Patient_Identification_Number;
        return view('admin.pdf.consulation-pdf', ['data' => $data, 'age' => $age, 'name' => $name]);
    }
    public function downloadPrescriptionNote(Request $request)
    {
        $data = Prescription::where('id', $request->id)->first();
        $age = Carbon::parse($data->user->DOB)->age;
        $name = "ePrescription_" . $data->user->Frist_Name . "_" . $data->user->Patient_Identification_Number;
        return view('admin.pdf.prescription-pdf', ['data' => $data, 'age' => $age, 'name' => $name]);
    }
    public function invoice(Request $request)
    {
        $data = Appointments::where('id', $request->id)->first();
        $name = "eBill_" . $data->user->Frist_Name . "_" . $data->user->Patient_Identification_Number;

        return view('admin.pdf.invoice', ['data' => $data, 'name' => $name]);
    }
}
