<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Carbon\Carbon;
use App\Models\PushNotification;

class BirthdayWish extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:birthday-wish';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {

        $array = User::select('id', 'First_Name', 'Last_Name', 'device_token')->whereMonth('DOB', Carbon::now()->format('m'))
            ->whereDay('DOB', Carbon::now()->format('d'))
            ->get();


        $SERVER_API_KEY = env('FCM_SERVER_KEY');
        foreach ($array as $item) {
            PushNotification::create([
                'title' => 'Birthday Wish',
                'message' => "Hi, " . $item->First_Name . "  " . $item->Last_Name . " Wishing you a fantastic birthday filled with happiness and good times. Cheers to another great year",
                'type' => 'Birthday',
                'user_id' => $item->id,
            ]);

            $data = [
                "to" => $item->device_token,
                "notification" => [
                    'title' => 'Birthday Wish',
                    'message' => "Hi, " . $item->First_Name . "  " . $item->Last_Name . " Wishing you a fantastic birthday filled with happiness and good times. Cheers to another great year"
                ],
                "data" => [
                    "route" => "notification"
                ]
            ];
            $dataString = json_encode($data);

            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            // Disabling SSL Certificate support temporarly
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
            // Execute post
            $result = curl_exec($ch);
            if ($result === FALSE) {
                die('Curl failed: ' . curl_error($ch));
            }
            // Close connection
            curl_close($ch);
            $this->info($result);
        }
    }
}
