<?php

namespace App\Console\Commands;

use App\Models\Appointments;
use App\Models\PushNotification;
use Illuminate\Console\Command;

class Appointment extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:appointment';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $start_time = now()->format('h:i a');
        $array = Appointments::select('appointments.*', 'users.device_token', 'users.First_Name', 'users.Last_Name')
            ->rightJoin('users', 'users.id', '=', 'appointments.user_id')
            ->where('Appointment_Status', '!=', 'Cancel')
            ->where('Appointment_Date', date('Y-m-d'))
            ->where('Appointment_Time', $start_time)
            ->get();


        $SERVER_API_KEY = env('FCM_SERVER_KEY');
        foreach ($array as $item) {
            PushNotification::create([
                'title' => 'Appoinment Remainder',
                'message' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". ",
                'therapist_notification' => "This is a friendly reminder for your appointment with " . $item->First_Name . "  " . $item->Last_Name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". ",
                'type' => 'Appointment',
                'user_id' => $item->user_id,
                'therapist_id' => $item->therapist_id,
                'appoinment_id' => $item->id
            ]);

            $data = [
                "to" => $item->device_token,
                "notification" => [
                    'title' => 'Appoinment Remainder',
                    'body' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". "
                ],
                "data" => [
                    "route" => "notification"
                ]
            ];
            $dataString = json_encode($data);

            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            // Disabling SSL Certificate support temporarly
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
            // Execute post
            $result = curl_exec($ch);
            if ($result === FALSE) {
                die('Curl failed: ' . curl_error($ch));
            }
            // Close connection
            curl_close($ch);
            $this->info($result);
        }
    }
}
