<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Appointments;
use App\Models\PushNotification;

class AppoinmentInMinutes extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:appoinment-in-minutes';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {

        $start_time = now()->format('h:i a');
        $end_time = date('h:i a', strtotime('+05 minutes'));
        $statustime = date('h:i a', strtotime('-30 minutes'));

        $array = Appointments::select('appointments.*', 'users.device_token', 'users.First_Name', 'users.Last_Name')
            ->rightJoin('users', 'users.id', '=', 'appointments.user_id')
            ->where('Appointment_Status', '!=', 'Cancel')
            ->where('Appointment_Date', date('Y-m-d'))
            ->whereBetween('Appointment_Time', [$start_time, $end_time])
            ->get();

        // change appoinment status
        $statuschange = Appointments::where('Appointment_Status', 'Join')
            ->where('Appointment_Date', date('Y-m-d'))
            ->where('Appointment_Time', '<', $statustime)
            //->toSql();
            ->get();
        foreach ($statuschange as $item) {
            Appointments::where('id', $item->appoinment_id)
                ->update(['Appointment_Status' => 'Missed']);
        }

        $SERVER_API_KEY = env('FCM_SERVER_KEY');
        foreach ($array as $item) {
            PushNotification::create([
                'title' => 'Appoinment Remainder',
                'message' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". See you soon!",
                'therapist_notification' => "This is a friendly reminder for your appointment with " . $item->First_Name . "  " . $item->Last_Name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". ",
                'type' => 'Appointment',
                'user_id' => $item->user_id,
                'therapist_id' => $item->therapist_id,
                'appoinment_id' => $item->id
            ]);
            Appointments::where('id', $item->id)->update([
                'Appointment_Status' => 'Join'
            ]);
            $data = [
                "to" => $item->device_token,
                "notification" => [
                    'title' => 'Appoinment Remainder',
                    'body' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". See you soon!"
                ],
                "data" => [
                    "route" => "notification"
                ]
            ];
            $dataString = json_encode($data);

            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            // Disabling SSL Certificate support temporarly
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
            // Execute post
            $result = curl_exec($ch);
            if ($result === FALSE) {
                die('Curl failed: ' . curl_error($ch));
            }
            // Close connection
            curl_close($ch);
            $this->info($result);
        }
    }
}
