<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user__assessment__q_and__a_s', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_assessment_id')->unsigned()->nullable();
            $table->text('question');
            $table->text('answer');
            $table->decimal('rate', 5, 2);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
            $table->foreign('user_assessment_id')->references('id')->on('user__assessments')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user__assessment__q_and__a_s');
    }
};
