<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('appointments', function (Blueprint $table) {
            $table->increments('id');
            $table->string('VP_Name')->default('Yellow Cloud');
            $table->integer('Appointment_Type')->unsigned();
            $table->string('Appointment_Date');
            $table->string('Appointment_Time');
            $table->string('Appointment_Booked_Date');
            $table->string('Appointment_Booked_Time');
            $table->enum('Appointment_Status', ['Awaiting', 'Confirm', 'Cancel', 'Completed', 'Resheduled', 'Rejected'])->default('Awaiting');
            $table->text('cancel_reason');
            $table->text('reshedule_reason');
            $table->integer('therapist_id')->unsigned();
            $table->integer('service_id')->unsigned();
            $table->integer('slot_id')->unsigned();
            $table->integer('user_id')->unsigned();
            $table->integer('package_id')->unsigned()->nullable();
            $table->decimal('fee', 10, 2);
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
            $table->foreign('therapist_id')->references('id')->on('therapists')->onDelete('cascade');
            $table->foreign('service_id')->references('id')->on('services')->onDelete('cascade');
            $table->foreign('slot_id')->references('id')->on('slot_shedules')->onDelete('cascade');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('package_id')->references('id')->on('packages')->onDelete('cascade');
            $table->foreign('Appointment_Type')->references('id')->on('call_methods')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('appointments');
    }
};
