<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('UserId')->unique();
            $table->integer('VP_ID')->nullable();
            $table->string('VP_NAME')->nullable();
            $table->text('Patient_Identification_Number')->nullable();
            $table->string('First_Name')->nullable();
            $table->string('Last_Name')->nullable();
            $table->string('slug')->unique()->nullable();
            $table->string('Email')->unique()->nullable();
            $table->string('Phone_Code')->nullable();
            $table->string('phone')->unique();
            $table->string('SMS')->unique()->nullable();
            $table->string('Gender')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('Weight')->nullable();
            $table->string('Height')->nullable();
            $table->date('DOB')->nullable();
            $table->string('Blood_Type')->nullable();
            $table->enum('Patient_Status', ['Active', 'Disabled'])->default('Active')->nullable();
            $table->timestamp('Reg_Date')->useCurrent();
            $table->rememberToken();
            $table->enum('status', ['ACTIVE', 'BLOCKED'])->default('ACTIVE');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable()->useCurrentOnUpdate();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
