<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class AppoinmentNotification extends Notification
{
    use Queueable;
    private $appoinmentData;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($appoinmentData)
    {
        $this->appoinmentData = $appoinmentData;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    // public function toMail($notifiable)
    // {
    //     return (new MailMessage)
    //         ->name($this->appoinmentData['name'])
    //         ->line($this->appoinmentData['body'])
    //         ->action($this->appoinmentData['appoinmentText'], $this->appoinmentData['appoinmentUrl'])
    //         ->line($this->appoinmentData['thanks']);
    // }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            'appoinment_id' => $this->appoinmentData['appoinment_id']
        ];
    }
}
