<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class User_Assessment extends Model
{
    use HasFactory;

    public function assessment(): BelongsTo
    {
        return $this->belongsTo(Assessment::class);
    }
    public function userAssessmentQandA(): HasMany
    {
        return $this->hasMany(User_Assessment_Q_and_A::class, 'user_assessment_id');
    }
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
