<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
// use Laravel\Sanctum\HasApiTokens;
use Laravel\Passport\HasApiTokens;
use Cviebrock\EloquentSluggable\Sluggable;
use Bavix\Wallet\Traits\HasWallet;
use Bavix\Wallet\Interfaces\Wallet;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;
    use Sluggable;

    protected $fillable = [
        // 'Patient_Identification_Number',
        // 'First_Name',
        // 'Last_Name',
        // 'Email',
        // 'sms',
        // 'Gender',
        // 'DOB',
        // 'Reg_Date',
        // 'location',
        // 'context'
        'VP_ID',
        'VP_NAME',
        'UserId',
        'Patient_Identification_Number',
        'First_Name',
        'Last_Name',
        'slug',
        'Email',
        'Phone_Code',
        'phone',
        'sms',
        'Gender',
        'Weight',
        'Height',
        'DOB',
        'Blood_Type',
        'Patient_Status',
        'Reg_Date',
        'location',
        'context'
    ];

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'service_name'
            ]
        ];
    }
    public function chat(): HasMany
    {
        return $this->hasMany(Chat::class, 'user_id');
    }
    public function appoinment(): HasMany
    {
        return $this->hasMany(Appointments::class, 'user_id');
    }
    public function userAssessment(): HasMany
    {
        return $this->hasMany(User_Assessment::class, 'user_id');
    }
    public function walletBalance()

    {
        return $this->hasOne(UserWallet::class, 'user_id');
    }

    public function review(): HasMany
    {
        return $this->hasMany(UserReview::class, 'user_id');
    }

    public function walletTransactions(): HasMany
    {
        return $this->hasMany(UserWalletTransactions::class, 'user_id');
    }
    public function PaymentDetails(): HasMany
    {
        return $this->hasMany(PaymentDetails::class, 'user_id');
    }

    public function consultationNote()
    {
        return $this->hasOne(ConsulationNote::class, 'user_id');
    }

    public function prescription()
    {
        return $this->hasOne(Prescription::class, 'user_id');
    }

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    // protected $fillable = [
    //     'name',
    //     'email',
    //     'password',
    // ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];
}
