<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TherapistCommission extends Model
{
    use HasFactory;

    public function therapist(): BelongsTo
    {
        return $this->belongsTo(Therapist::class);
    }

    public function appoinment(): HasMany
    {
        return $this->hasMany(Appointments::class, 'therapist_id');
    }
}
