<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class SlotShedule extends Model
{
    use HasFactory;


    public function workingHour(): BelongsTo
    {
        return $this->belongsTo(WorkingHours::class);
    }
    public function callMethod(): BelongsTo
    {
        return $this->belongsTo(CallMethods::class);
    }
    public function appoinment(): HasMany
    {
        return $this->hasMany(Appointments::class, 'slot_id');
    }
}
