<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ProviderCategory extends Model
{
    use HasFactory;

    public function service(): HasMany
    {
        return $this->hasMany(ServiceFeeStructure::class, 'service_id');
    }

    public function therapist(): HasMany
    {
        return $this->hasMany(Therapist::class, 'provider_category_id');
    }
    public function sluggable()
    {
        return [
            'slug' => [
                'source' => 'name'
            ]
        ];
    }
}
