<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PaymentDetails extends Model
{
    use HasFactory;

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
    public function walletTransaction()
    {
        return $this->hasOne(UserWalletTransactions::class, 'payment_id');
    }
    public function appointment()
    {
        return $this->hasOne(Appointments::class, 'payment_id');
    }
}
