<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Assessment extends Model
{
    use HasFactory;
    use Sluggable;
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title'
            ]
        ];
    }

    public function therapist(): BelongsTo
    {
        return $this->belongsTo(Therapist::class);
    }

    public function questions(): HasMany
    {
        return $this->hasMany(Assessment_questions::class, 'assessment_id');
    }

    public function answer(): HasMany
    {
        return $this->hasMany(Assessment_answer::class, 'assessment_id');
    }
    public function settings(): HasMany
    {
        return $this->hasMany(Assessment_rate_settings::class, 'assessment_id');
    }

    public function userAssessment(): HasMany
    {
        return $this->hasMany(User_Assessment::class, 'assessment_id');
    }
}
