<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Appointments extends Model
{
    use HasFactory;

    public function therapist(): BelongsTo
    {
        return $this->belongsTo(Therapist::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function service(): BelongsTo
    {
        return $this->belongsTo(Service::class);
    }

    public function slots(): BelongsTo
    {
        return $this->belongsTo(SlotShedule::class);
    }

    public function package(): BelongsTo
    {
        return $this->belongsTo(Package::class);
    }
    public function callMethod(): BelongsTo
    {
        return $this->belongsTo(CallMethods::class, 'Appointment_Type', 'id');
    }


    public function review(): HasMany
    {
        return $this->hasMany(UserReview::class, 'appoinment_id');
    }

    public function prescription()
    {
        return $this->hasOne(Prescription::class, 'appoinment_id');
    }

    public function consultationNote()
    {
        return $this->hasOne(ConsulationNote::class, 'appoinment_id');
    }

    public function therapistCommission(): HasMany
    {
        return $this->hasMany(TherapistCommission::class, 'therapist_id');
    }

    public function payment()
    {
        return $this->belongsTo(PaymentDetails::class);
    }
}
