<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Notifications\AppoinmentNotification;
use Spatie\Permission\Traits\HasRoles;
use Cviebrock\EloquentSluggable\Sluggable;

class Admin extends Authenticatable
{
    use HasFactory, HasRoles, Sluggable;
    use Notifiable;
    protected $guard = 'admin';
    protected $fillable = [
        'role_id',
        'name',
        'slug',
        'email',
        'backup_email',
        'password',
        'phone_number',
        'dob',
        'gender',
        'image'
    ];

    // public function role(): BelongsTo
    // {
    //     return $this->belongsTo(UserRoles::class);
    // }

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'name'
            ]
        ];
    }
}
