<?php

namespace App\Imports;

use App\Models\Location;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;

class LocationImport implements ToModel, WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {

        return new Location([
            'currency_symbol' => $row['currency_symbol'],
            'currency' => $row['currency'],
            'country' => $row['country'],
            'currency_code' => $row['currency_code']
        ]);
    }
}
