<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Therapist;
use App\Models\Specialization;
use App\Models\ProviderCategory;
use Illuminate\Database\Eloquent\Builder;
use App\Models\Service;
use App\Models\User;
use App\Models\Appointments;
use App\Models\UserReview;

class TherapistController extends Controller
{
    public function therapist(Request $request)
    {

        $category = $request->category;
        $specialization = $request->specialization;

        $service = $request->service;

        $array = Therapist::where(function ($query) use ($category) {
            if ($category) {
                $query->where('provider_category_id', $category);
            }
        })
            ->where(function ($query) use ($specialization) {
                if ($specialization) {
                    //      $query->where('specialization_and_expertise', 'like', '%' . $specialization);
                    $query->whereJsonContains('specialization_and_expertise', $specialization);
                }
            })
            ->where(function ($query) use ($service) {
                if ($service) {
                    $query->whereJsonContains('services', $service);
                }
            })
            ->where('status', 'ACTIVE')
            ->orderBy('order_number', 'ASC')
            ->get();


        // $data = collect($array->toArray())->map(function ($item) {
        //     $item['image'] = asset('assets/uploads/therapist/') . '/' . $item['image'];
        //     // $language_known = explode(',', $item['language_known']);
        //     // $item['language_known'] = $language_known[0] . ',' . $language_known[1];

        //     return $item;
        // });
        $data = [];
        foreach ($array as $key => $item) {
            $data[$key]['id'] = $item->id;
            $data[$key]['provider_category_id'] = $item->provider_category_id;
            $data[$key]['prefix'] = $item->prefix;
            $data[$key]['full_name'] = $item->full_name;
            $data[$key]['slug'] = $item->slug;
            $data[$key]['designation'] = $item->designation;
            $data[$key]['language_known'] = $item->language_known;
            $data[$key]['image']  = asset('assets/uploads/therapist/') . '/' . $item->image;
            $data[$key]['total_sessions'] = count(Appointments::where('therapist_id', $item->id)->where('Appointment_Status', 'Completed')->get());
            $services = [];
            foreach ($item->services as $k => $s) {
                $services[$k] = Service::where('id', $s)->pluck('service_name')->first();
            }
            $data[$key]['services'] = $services;

            $specialization = [];
            if ($item->specialization_and_expertise) {
                foreach ($item->specialization_and_expertise as $k => $s) {
                    $specialization[$k] = Specialization::where('id', $s)->pluck('tag')->first();
                }
            }
            $data[$key]['specialization'] = $specialization;
        }


        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function therapistDetails(Request $request)
    {
        $data = Therapist::where('slug', $request->slug)->with('work')->with('academics')->with('training')->with('license')->first();
        $service = Service::where('service_name', 'like', '%Individual Counselling%')->first();
        $data->image = asset('assets/uploads/therapist/') . '/' . $data->image;
        $data->service_booking_id = $service->id;
        $services = [];
        if ($data->services) {
            foreach ($data->services as $key => $item) {
                $s = Service::where('id', $item)->pluck('service_name')->first();
                $services[$key] = $s;
            }
        }

        $data->services = $services;
        $data->total_sessions = count(Appointments::where('therapist_id', $data->id)->where('Appointment_Status', 'Completed')->get());
        $specialization_and_expertise = [];
        if ($data->specialization_and_expertise) {
            foreach ($data->specialization_and_expertise as $key => $item) {
                $se = Specialization::where('id', $item)->pluck('tag')->first();
                $specialization_and_expertise[$key] = $se;
            }
        }
        $data->specialization_and_expertise = $specialization_and_expertise;
        $review = [];
        $r = UserReview::where('therapist_id', $data->id)->get();

        foreach ($r as $key => $item) {

            $user = User::select('First_Name', 'Last_Name', 'image', 'gender')->where('id', $item->user_id)->first();
            if ($user) {
                $review[$key]['user_name'] = $user->First_Name . ' ' . $user->Last_Name;
                if ($user->image != NULL) {
                    $review[$key]['user_image'] = asset('assets/uploads/user/' . $user->image);
                } else {
                    if ($user->gender == 'MALE') {
                        $review[$key]['user_image'] = asset('assets/img/male-avatar.jpg');
                    } else {
                        $review[$key]['user_image']  = asset('assets/img/female-avatar.webp');
                    }
                }
            } else {
                $review[$key]['user_name'] = 'User';
                $review[$key]['user_image'] = asset('assets/img/male-avatar.jpg');
            }
            $review[$key]['rate'] = $item->rate;
            $review[$key]['review'] = $item->comment;
        }
        $reviewsum = UserReview::where('therapist_id', $data->id)->avg('rate');
        $data->total_review_rate = round($reviewsum, 2);
        $data->reviews = $review;

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function providerCategory(Request $request)
    {
        $data = ProviderCategory::select('id', 'name')->get();

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function specialization(Request $request)
    {
        $data = Specialization::select('id', 'tag')->get();

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
}
