<?php

namespace App\Http\Controllers\Therapist;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Appointments;
use Illuminate\Database\QueryException;
use Carbon\Carbon;
use App\Models\Blog;
use App\Models\ServiceFeeStructure;
use App\Models\Service;
use App\Models\Therapist;
use App\Models\Specialization;
use App\Models\Assessment;
use App\Models\Settlement;
use App\Models\UserReview;
use App\Models\User_Assessment;
use App\Models\User_Assessment_Q_and_A;
use App\Models\Package;
use App\Models\MoodTracker;
use Illuminate\Support\Facades\Auth;
use App\Models\PushNotification;
use App\Models\TherapistCommission;
use Illuminate\Support\Facades\Mail;
use App\Mail\TherapistRegisterNotificationMail;
use App\Models\ReportAnIssue;
use Illuminate\Http\JsonResponse;

class UserController extends Controller
{
    public function patient(Request $request)
    {
        try {
            $data = [];
            $name = $request->name;
            if ($name) {
                $user = User::select('id')->where('First_Name', 'LIKE', '%' . $name . '%')
                    ->orWhere('Last_Name', 'LIKE', '%' . $name . '%')
                    ->get();
                $userarray = $user->toArray();
                $res = Appointments::select('user_id', 'id')->where('therapist_id', auth()->user()->id)
                    ->whereIn('user_id', $userarray)
                    ->orderBy('id', 'DESC')
                    ->groupBy('user_id')->get();
            } else {
                $res = Appointments::select('user_id', 'id')->where('therapist_id', auth()->user()->id)
                    ->orderBy('id', 'DESC')
                    ->groupBy('user_id')->get();
            }
            if ($res) {
                $key = 0;
                foreach ($res as  $item) {
                    if ($item->user) {
                        if (empty($item->user)) {
                            $img = asset('assets/img/male-avatar.jpg');
                            $name = "USER";
                        } else {
                            if ($item->user->image != NULL) {
                                $img = asset('assets/uploads/user/' . $item->user->image);
                                $name = $item->user->First_Name . $item->user->Last_Name;
                            } else {
                                $name = $item->user->First_Name;
                                if ($item->user->Gender == 'MALE' || $item->user->Gender == 'M') {
                                    $img = asset('assets/img/male.png');
                                } elseif ($item->user->Gender == 'FEMALE' || $item->user->Gender == 'F') {
                                    $img = asset('assets/img/female.png');
                                } else {
                                    $img = asset('assets/img/other.png');
                                }
                            }
                        }
                        $data[$key]['appoinment_id'] = $item->id;
                        $data[$key]['user_id'] = $item->user->id;
                        $data[$key]['user_name'] = $item->user->First_Name . ' ' . $item->user->Last_Name;
                        $data[$key]['age'] = Carbon::parse($item->user->DOB)->age;;
                        $data[$key]['gender'] = $item->user->Gender;
                        $data[$key]['user_image'] = $img;
                        $data[$key]['total_sessions'] = count(Appointments::where('therapist_id', auth()->user()->id)->where('user_id', $item->user->id)->get());
                        $data[$key]['last_session_status'] = Appointments::where('therapist_id', auth()->user()->id)->where('user_id', $item->user->id)->orderBy('id', 'DESC')->pluck('Appointment_Status')->first();
                    } else {
                        continue;
                    }
                    $key++;
                }
            }

            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function patientDetails(Request $request)
    {
        try {
            $user = User::where('id', $request->user_id)->first();
            if ($user->image != NULL) {
                $img = asset('assets/uploads/user/' . $user->image);
            } else {
                $img = asset('assets/img/no-image-available.jpg');
            }
            $data['user_id'] = $request->user_id;
            $data['user_name'] = $user->First_Name . ' ' . $user->Last_Name;
            $data['age'] = Carbon::parse($user->DOB)->age;;
            $data['gender'] = $user->Gender;
            $data['user_image'] = $img;
            $data['total_sessions'] = count(Appointments::where('therapist_id', auth()->user()->id)->where('user_id', $request->user_id)->get());
            $last_session_status = Appointments::where('therapist_id', auth()->user()->id)->where('user_id', $request->user_id)->orderBy('id', 'DESC')->pluck('Appointment_Status')->first();
            if ($last_session_status == null) {
                $data['last_session_status']  = "";
            } else {
                $data['last_session_status'] =  $last_session_status;
            }
            $array = Appointments::where('user_id', $request->user_id)->where('therapist_id', auth()->user()->id)->orderBy('Appointment_Date', 'DESC')->get();
            $now = Carbon::now();
            $current_time = $now->format('H:i');
            foreach ($array as $key => $item) {

                $duration = ServiceFeeStructure::where('service_id', $item->service_id)->where('provider_category_id', $item->therapist->provider_category_id)->where('call_method_id', $item->Appointment_Type)->pluck('duration')->first();
                $givenDateTime = date("H:i", strtotime($item->Appointment_Time));

                $time = $item->Appointment_Date . " " . $givenDateTime . ":00";
                $closeTime =  Carbon::parse($time)->addMinutes($duration);

                if ($item->Appointment_Date == date("Y-m-d")) {

                    if ($current_time > $givenDateTime) {
                        continue;
                    } else {
                        $data['history'][$key]['appoinment_id'] = $item->id;
                        $data['history'][$key]['therapist_id'] = $item->therapist_id;
                        $data['history'][$key]['therapist_name'] = $item->therapist->full_name;
                        $data['history'][$key]['Appointment_Date'] = date('D F Y', strtotime($item->Appointment_Date));
                        $data['history'][$key]['start_time'] = $item->Appointment_Time;
                        $data['history'][$key]['end_time'] = date('h:i A', strtotime($closeTime));
                        $data['history'][$key]['Appointment_Status'] = $item->Appointment_Status;
                        $data['history'][$key]['call_type'] = $item->callMethod->name;
                        $key++;
                    }
                } else {
                    $data['history'][$key]['appoinment_id'] = $item->id;
                    $data['history'][$key]['therapist_id'] = $item->therapist_id;
                    $data['history'][$key]['therapist_name'] = $item->therapist->full_name;
                    $data['history'][$key]['Appointment_Date'] = date('D F Y', strtotime($item->Appointment_Date));
                    $data['history'][$key]['start_time'] = $item->Appointment_Time;
                    $data['history'][$key]['end_time'] = date('h:i A', strtotime($closeTime));
                    $data['history'][$key]['Appointment_Status'] = $item->Appointment_Status;
                    $data['history'][$key]['call_type'] = $item->callMethod->name;
                    $key++;
                }
            }
            if (empty($data['history'])) {
                $data['history'] = [];
            }
            $assessment = Assessment::select('assessments.*', 'user__assessments.id as assessment_saved_id', 'user__assessments.total_rate as assessment_total_rate')
                ->leftJoin('user__assessments', 'assessments.id', '=', 'user__assessments.assessment_id')
                ->where('user_id', $request->user_id)
                ->get();
            foreach ($assessment as $key => $item) {
                $data['assessment'][$key]['id'] = $item->id;
                $data['assessment'][$key]['title'] = $item->title;
                $data['assessment'][$key]['image'] = asset('assets/uploads/assessment/' . $item->image);
                $data['assessment'][$key]['time_duration'] = $item->time_duration;
                $data['assessment'][$key]['steps'] = count($item->questions);
                $data['assessment'][$key]['assessment_saved_id'] = $item->assessment_saved_id;
                $data['assessment'][$key]['assessment_total_rate'] = $item->assessment_total_rate;
            }

            if (empty($data['assessment'])) {
                $data['assessment'] = [];
            }
            $data['moodtracker'] = MoodTracker::select('date', 'emotion', 'description')
                ->where('user_id', $request->user_id)->get();
            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function profile(Request $request)
    {
        $data = [];
        $array = Therapist::where('id', auth()->user()->id)->first();
        $data['employee_id'] = $array->id;
        $data['full_name'] = $array->full_name;
        if ($array->image != NULL) {
            $img = asset('assets/uploads/therapist/' . $array->image);
        } else {
            if ($array->gender == 'MALE') {
                $img = asset('assets/img/male-avatar.jpg');
            } else {
                $img = asset('assets/img/female-avatar.webp');
            }
        }

        $data['image'] = $img;
        $data['provider_category'] = $array->providerCategory->name;
        $data['experience'] = $array->experience;
        $data['mobile'] = $array->mobile;
        $data['email'] = $array->email;
        $data['qualification'] = $array->qualification;
        $data['designation'] = $array->designation;
        $data['language_known'] = $array->language_known;
        $data['address'] = $array->address;
        $data['city'] = $array->city;
        $data['state'] = $array->state;
        $data['country'] = $array->country;
        $data['postal_code'] = $array->postal_code;
        $data['biography'] = $array->biography;
        $data['personal_background'] = $array->personal_background;
        $data['research_and_publications'] = $array->research_and_publications;
        $data['approach_and_treatment'] = $array->approach_and_treatment;
        $data['philosophy_and_approach'] = $array->philosophy_and_approach;
        $data['client_focus_and_population'] = $array->client_focus_and_population;
        $data['awards'] = $array->awards;
        $data['dob'] = $array->dob;
        $data['total_clients'] = count(Appointments::select('user_id', 'id')->where('therapist_id', auth()->user()->id)->orderBy('id', 'DESC')->groupBy('user_id')->get());
        $data['total_reviews'] = count(UserReview::where('therapist_id', auth()->user()->id)->get());
        $reviewsum = UserReview::where('therapist_id', auth()->user()->id)->avg('rate');
        $data['total_review_rate'] = round($reviewsum, 1);
        if ($array->services) {
            foreach ($array->services as $key => $item) {
                $data['service'][$key] = Service::where('id', $item)->pluck('service_name')->first();
            }
        }
        if ($array->specialization_and_expertise) {
            foreach ($array->specialization_and_expertise as $key => $item) {
                $data['specialization'][$key] = Specialization::where('id', $item)->pluck('tag')->first();
            }
        }

        $data['work'] = $array->work;
        $data['academics'] = $array->academics;
        $data['training'] = $array->training;
        $data['license'] = $array->license;
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }


    public function assessmentsQandA(Request $request)
    {
        $data = User_Assessment_Q_and_A::select('question', 'answer')->where('user_assessment_id', $request->assessment_saved_id)->orderBy('id', 'ASC')->get();

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function blogDetails(Request $request)
    {

        $data = Blog::select('id', 'title', 'blog_category_id', 'therapist_id', 'author', 'description', 'image', 'tags', 'color', 'created_at')->where('id', $request->id)->first();

        if ($data->author == 'T') {
            $data->author = $data->therapist->full_name;
            $data->author_image = asset('assets/uploads/therapist/' . $data->therapist->image);
        } elseif ($data->author == 'F') {
            $data->author = 'Feni';
            $data->author_image = asset('assets/img/fenni.jpg');
        }

        $data->description = strip_tags($data->description);
        $data->description = preg_replace("/&nbsp;/", '', $data->description);
        $data->description = preg_replace("/\s+/", " ", $data->description);
        $data->image = asset('assets/uploads/blog/') . '/' . $data->image;
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }


    public function notification(Request $request)
    {

        $res =  PushNotification::select('title', 'therapist_notification', 'appoinment_id')->where('therapist_id', auth()->user()->id)->get();

        if ($res) {
            return response()->json(
                array(
                    'status' => true,
                    'data' => $res,
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Something went Wrong",
                    'statuscode' => 301
                ),
                200
            );
        }
    }

    public function packageDetails(Request $request)
    {

        $data = Package::select('id', 'image', 'title', 'description', 'no_of_sessions')
            ->where('id', $request->package_id)
            ->orderBy('id', 'DESC')->first();
        $completed_sessions = count(Appointments::where('therapist_id', auth()->user()->id)
            ->where('Appointment_Status', 'Completed')
            ->where('package_id', $data->id)
            ->get());
        $data->completed_sessions = $completed_sessions;
        $data->image = asset('assets/uploads/package/') . '/' . $data->image;
        $data->remaining_sessions = $data->no_of_sessions - $completed_sessions;
        $data->rate = ($completed_sessions) / $data->no_of_sessions;
        $sessions = Appointments::select('id', 'Appointment_Date', 'Appointment_Time')->where('therapist_id', auth()->user()->id)->where('package_id', $request->package_id)->get();

        $data->sessions = $sessions->map(
            function ($item) {
                $item->Appointment_Date = date('d  M, l Y', strtotime($item->Appointment_Date));
                return $item;
            }
        );

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function earnings(Request $request)
    {
        // $array = Appointments::join('call_methods', 'call_methods.id', '=', 'appointments.Appointment_Type')
        //     ->join('users', 'users.id', '=', 'appointments.user_id')
        //     ->select('users.First_Name', 'users.Last_Name', 'users.image as user_image', 'call_methods.name as call_type', 'appointments.fee')
        //     ->where('therapist_id', auth()->user()->id)
        //     ->where('Appointment_Status', '!=', 'Cancel')
        //     ->get();

        $array = TherapistCommission::join('appointments', 'appointments.id', '=', 'therapist_commissions.appoinment_id')
            ->join('call_methods', 'call_methods.id', '=', 'appointments.Appointment_Type')
            ->join('users', 'users.id', '=', 'appointments.user_id')
            ->select('users.First_Name', 'users.Last_Name', 'users.image as user_image', 'call_methods.name as call_type', 'therapist_commissions.therapist_earnings as fee')
            ->where('therapist_commissions.therapist_id', auth()->user()->id)
            ->get();
        $data = [];


        $data = $array->map(
            function ($item) {
                if ($item->image != NULL) {
                    $item->image  = asset('assets/uploads/user/' . $item->image);
                } else {
                    $item->image  = asset('assets/img/no-image-available.jpg');
                }

                return $item;
            }
        );

        $total_earnings = TherapistCommission::where('therapist_id', auth()->user()->id)
            ->sum('therapist_earnings');
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'total_earnings' => $total_earnings,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function getSettlements(Request $request)
    {

        $settled_amount = (int) Settlement::where('therapist_id', auth()->user()->id)->sum('amount');

        $balance_amount = TherapistCommission::where('therapist_id', auth()->user()->id)->sum('therapist_earnings') - $settled_amount;
        if ($balance_amount < 0) {
            $balance_amount = 0;
        }
        $data = Settlement::where('therapist_id', auth()->user()->id)->groupBy('therapist_id')->orderBy('id', 'DESC')->get();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'settled_amount' => $settled_amount,
                    'balance_amount' => $balance_amount,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }


    public function saveToken(Request $request)
    {
        $request->validate([
            'token' => 'required'
        ]);

        $res =  Therapist::where('id', auth()->user()->id)
            ->update([
                'device_token' => $request->token
            ]);

        if ($res) {
            return response()->json(
                array(
                    'status' => true,
                    'data' => "token saved successfully.",
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Something went Wrong",
                    'statuscode' => 301
                ),
                200
            );
        }
    }

    public function sendForgotpswdMail(Request $request)
    {
        $data = Therapist::where('email', $request->email)->first();

        if ($data == null) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Email not exist",
                    'statuscode' => 301
                ),
                200
            );
        } else {
            $pswd =  rand(000000, 999999);

            $res =   Therapist::where('email', $request->email)
                ->update([
                    'password' => bcrypt($pswd)
                ]);

            if ($res == 1) {

                $mailData = [
                    'name' => $data->full_name,
                    'username' => $data->mobile,
                    'password' => $pswd,
                    'content' => 'Your account password on the Yellowcloud has been updated. '
                ];
                //   print_r($mailData);die();
                Mail::to($request->email)->send(new TherapistRegisterNotificationMail($mailData));
                // Mail::send('admin.email.forgetPassword', ['mailData' => $mailData], function ($message) use ($request) {
                //     $message->to($request->email);
                //     $message->subject('Reset Password');
                // });
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Mail send successfully.",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        }
    }

    public function metrics(Request $request)
    {
        $services =  Service::select('id', 'service_name')->get();
        $data = $services->map(function ($item) {
            $totalappoinments = count(Appointments::where('therapist_id', auth()->user()->id)->get());
            if ($totalappoinments != 0) {
                $otal_service = count(Appointments::where('therapist_id', auth()->user()->id)->where('service_id', $item->id)->get());
                $item->total_session = (($otal_service / $totalappoinments) * 100) . '%';
            } else {
                $item->total_session = '0%';
            }
            $item->color = '#' . str_pad(dechex(mt_rand(0, 0xFFFFFF)), 6, '0', STR_PAD_LEFT);
            return $item;
        });

        if (count($services) > 0) {
            return response()->json(
                array(
                    'status' => true,
                    'data' => $data,
                    'statuscode' => 200
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => [],
                    'statuscode' => 301
                ),
                200
            );
        }
    }



    public function reportAnIssue(Request $request): JsonResponse
    {

        try {
            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/reportissue'), $image);
            }

            // ******** Image uploade end ********


            $res = ReportAnIssue::insert([
                'user_id' => auth()->user()->id,
                'issue' => $request->issue,
                'description' => $request->description,
                'image' => $image,
                'issue_from' => 'Therapist App'
            ]);


            if ($res) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Data Submitted Successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function resetTherapistPassword(Request $request)
    {
        if ($request->password == $request->confirm_password) {
            $res =   Therapist::where('id', auth()->user()->id)
                ->update([
                    'password' => bcrypt($request->password)
                ]);

            if ($res == 1) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Data Submitted Successfully",
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong",
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } else {
            return response()->json(
                array(
                    'status' => false,
                    'data' => "Password doesn't match ",
                    'statuscode' => 301
                ),
                200
            );
        }
    }

    public function moodListing(Request $request)
    {
        try {
            $data = MoodTracker::select('id', 'date', 'emotion')->where('user_id', $request->client_id)->orderBy('date', 'DESC')->get();

            if ($data) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => $data,
                        'statuscode' => 200
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => $data,
                        'statuscode' => 301
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
}
