<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PatientCallLog;
use App\Models\Appointments;
use App\Models\TherapistCallLog;
use Illuminate\Database\QueryException;

class CallController extends Controller
{
    public function savePatientCallLoginTime(Request $request)
    {
        try {

            $data = PatientCallLog::where('appoinment_id', $request->appoinment_id)
                ->where('user_id', auth()->user()->id)
                ->where('joinin_time', '!=', NULL)
                ->first();
            // print_r($data);
            // die();
            if ($data == null) {
                $call = new PatientCallLog();
                $call->user_id = auth()->user()->id;
                $call->appoinment_id = $request->appoinment_id;
                $call->login_status = $request->status;
                $call->joinin_time = now()->format('Y-m-d H:i:s');
                $call->save();
            } else {
                $call = PatientCallLog::where('id', $data->id)
                    ->update([
                        'logout_status' => $request->status,
                        'joinin_time' => now()->format('Y-m-d H:i:s')
                    ]);
            }

            if ($call) {
                $status = Appointments::where('id', $request->appoinment_id)
                    ->pluck(
                        'Appointment_Status'
                    )->first();
                if ($status == 'Join') {
                    $nxt = 'No Participants';
                } else if ($status == 'Awaiting Participant') {
                    $nxt = 'In Progress';
                } else if ($status == 'No Participants') {
                    $nxt = 'Awaiting Participant';
                }
                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $nxt
                    ]);

                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Data saved  Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function savePatientCallLogoutTime(Request $request)
    {

        try {
            $data = PatientCallLog::where('appoinment_id', $request->appoinment_id)
                ->where('user_id', auth()->user()->id)
                ->first();

            if ($data == null) {
                $call = new PatientCallLog();
                $call->user_id = auth()->user()->id;
                $call->appoinment_id = $request->appoinment_id;
                $call->logout_status = $request->status;
                $call->joinout_time = now()->format('Y-m-d H:i:s');
                $call->save();
            } else {
                $call = PatientCallLog::where('id', $data->id)
                    ->update([
                        'logout_status' => $request->status,
                        'joinout_time' => now()->format('Y-m-d H:i:s')
                    ]);
            }
            if ($call) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Data saved  Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function saveTherapistCallLoginTime(Request $request)
    {
        try {

            $data = TherapistCallLog::where('appoinment_id', $request->appoinment_id)
                ->where('therapist_id', auth()->user()->id)
                ->where('joinin_time', '!=', NULL)
                ->first();

            if ($data == null) {
                $call = new TherapistCallLog();
                $call->therapist_id   = auth()->user()->id;
                $call->appoinment_id = $request->appoinment_id;
                $call->login_status = $request->status;
                $call->joinin_time = now()->format('Y-m-d H:i:s');
                $call->save();
            } else {
                $call = TherapistCallLog::where('id', $data->id)
                    ->update([
                        'logout_status' => $request->status,
                        'joinin_time' => now()->format('Y-m-d H:i:s')
                    ]);
            }



            if ($call) {
                $status = Appointments::where('id', $request->appoinment_id)
                    ->pluck(
                        'Appointment_Status'
                    )->first();
                if ($status == 'Join') {
                    $nxt = 'No Participants';
                } else if ($status == 'Awaiting Participant') {
                    $nxt = 'In Progress';
                } else if ($status == 'No Participants') {
                    $nxt = 'Awaiting Participant';
                }

                $res = Appointments::where('id', $request->appoinment_id)
                    ->update([
                        'Appointment_Status' => $nxt
                    ]);

                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Data saved  Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function saveTherapistCallLogoutTime(Request $request)
    {

        try {
            $data = TherapistCallLog::where('appoinment_id', $request->appoinment_id)
                ->where('therapist_id', auth()->user()->id)
                ->first();

            if ($data == null) {
                $call = new TherapistCallLog();
                $call->therapist_id  = auth()->user()->id;
                $call->appoinment_id = $request->appoinment_id;
                $call->logout_status = $request->status;
                $call->joinout_time = now()->format('Y-m-d H:i:s');
                $call->save();
            } else {
                $call = TherapistCallLog::where('id', $data->id)
                    ->update([
                        'logout_status' => $request->status,
                        'joinout_time' => now()->format('Y-m-d H:i:s')
                    ]);
            }
            if ($call) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Data saved  Sucessfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }
}
