<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Therapist;
use App\Models\TherapistWorkExperience;
use App\Models\TherapistAcademicsExperience;
use App\Models\TherapistAdditionalTraining;
use App\Models\Licensing;
use App\Models\Slot;
use App\Models\Specialization;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\Hash;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Mail;
use App\Mail\TherapistRegisterNotificationMail;
use App\Models\Appointments;
use App\Models\Service;
use App\Models\Settlement;
use App\Models\TherapistCommission;
use \Illuminate\Support\Str;
use Illuminate\Support\Facades\Validator;

class TherapistController extends Controller
{
    // public function addTherapist(Request $request)
    // {

    //     $pswd = rand(000000, 999999);
    //     $data = [
    //         'name' => 'Ann Augustin',
    //         'username' => 9188360241,
    //         'password' => $pswd
    //     ];

    //     return view('admin.email.register', ['data' => $data]);
    // }
    public function saveTherapist(Request $request)
    {

        try {
            $request->validate([
                'prefix' => 'required',
                'full_name' => 'required',
                'provider_category' => 'required',
                'professional_credentials' => 'required',
                'mobile' => 'required',
                'email' => 'required',
                'qualification' => 'required',
                'designation_in_yc' => 'required',
                'language_known' => 'required',
                'experience' => 'required',
                'employee_id' => 'required',
                'joining_date' => 'required',
                'image' => 'required',
                'gender' => 'required',
                'address' => 'required',
                'city' => 'required',
                'state' => 'required',
                'country' => 'required',
                'postal_code' => 'required'
            ]);

            $joining_date = str_replace('/', '-', $request->joining_date);
            $joining_date = date("Y-m-d", strtotime($joining_date));
            $dob = str_replace('/', '-', $request->dob);
            $dob = date("Y-m-d", strtotime($dob));
            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/therapist'), $image);
            }
            // ******** Image uploade end ********
            $pswd = rand(000000, 999999);

            $pswd_encrypt = bcrypt($pswd);
            $slug = SlugService::createSlug(Therapist::class, 'slug', $request->full_name);

            $therapist = new Therapist();
            //  $therapist->employee_id = $request->employee_id;
            $therapist->employee_id = rand(000000, 999999);
            $therapist->prefix = $request->prefix;
            $therapist->full_name = $request->full_name;
            $therapist->slug = $slug;
            $therapist->professional_credentials = $request->professional_credentials;
            $therapist->provider_category_id = $request->provider_category;
            $therapist->services = $request->services;
            $therapist->slot_setting_permission = $request->slot_managment;
            $therapist->experience = $request->experience;
            $therapist->mobile = $request->mobile;
            $therapist->email = $request->email;
            $therapist->password = $pswd_encrypt;
            $therapist->joining_date = $joining_date;
            $therapist->qualification = $request->qualification;
            $therapist->designation = $request->designation_in_yc;
            $therapist->language_known = $request->language_known;
            $therapist->address = $request->address;
            $therapist->city = $request->city;
            $therapist->state = $request->state;
            $therapist->country = $request->country;
            $therapist->postal_code = $request->postal_code;
            $therapist->biography = $request->biography;
            $therapist->personal_background = $request->personal_background;
            $therapist->research_and_publications = $request->research_and_publications;
            $therapist->approach_and_treatment = $request->approach_and_treatment;
            $therapist->philosophy_and_approach = $request->philosophy_and_approach;
            $therapist->specialization_and_expertise = $request->specialization_and_expertise;
            $therapist->client_focus_and_population = $request->client_focus_and_population;
            $therapist->awards = $request->awards;
            $therapist->dob = $dob;
            $therapist->image = $image;
            $therapist->gender = $request->gender;
            $therapist->save();

            // print_r($request->all());
            // die();
            if ($therapist) {
                $work_count = count($request->designation);
                if (isset($request->designation[0])) {
                    for ($i = 0; $i < $work_count; $i++) {

                        $therapistWorkExperience = new TherapistWorkExperience();
                        $therapistWorkExperience->therapist_id = $therapist->id;
                        $therapistWorkExperience->designation = $request->designation[$i];
                        $therapistWorkExperience->hospital = $request->hospital[$i];
                        $therapistWorkExperience->place = $request->place[$i];
                        $therapistWorkExperience->save();
                    }
                }
                // print_r($therapistWorkExperience);
                // die();
                $academics_count = count($request->education);
                if (isset($request->education[0])) {
                    for ($i = 0; $i < $academics_count; $i++) {
                        $therapistAcademicsExperience = new TherapistAcademicsExperience();
                        $therapistAcademicsExperience->therapist_id = $therapist->id;
                        $therapistAcademicsExperience->education = $request->education[$i];
                        $therapistAcademicsExperience->college = $request->college[$i];
                        $therapistAcademicsExperience->year = $request->year[$i];
                        $therapistAcademicsExperience->save();
                    }
                }
                $training_count = count($request->training_education);

                if (isset($request->training_education[0])) {
                    for ($i = 0; $i < $training_count; $i++) {
                        $therapistTrainingExperience = new TherapistAdditionalTraining();
                        $therapistTrainingExperience->therapist_id = $therapist->id;
                        $therapistTrainingExperience->education = $request->training_education[$i];
                        $therapistTrainingExperience->college = $request->training_college[$i];
                        $therapistTrainingExperience->year = $request->training_year[$i];
                        $therapistTrainingExperience->save();
                    }
                }

                $license_count = count($request->licensing_and_certifications_name);

                if (isset($request->licensing_and_certifications_name[0])) {
                    for ($i = 0; $i < $license_count; $i++) {
                        $licensing = new Licensing();
                        $licensing->therapist_id = $therapist->id;
                        $licensing->name = $request->licensing_and_certifications_name[$i];
                        $licensing->date = date("Y-m-d", strtotime($request->expiry_date[$i]));
                        $licensing->save();
                    }
                }

                $mailData = [
                    'name' => $request->full_name,
                    'username' => $request->mobile,
                    'password' => $pswd,
                    'content' => 'Your account has been created on the Yellowcloud. Below are your system generated credentials.'
                ];


                //        Mail::to($request->email)->send(new TherapistRegisterNotificationMail($mailData));

                // if (!$therapistWorkExperience && !$therapistAcademicsExperience) {
                //     return false;
                // } else {
                Mail::to($request->email)->send(new TherapistRegisterNotificationMail($mailData));

                return true;
                //    }
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function workHtml(Request $request)
    {
        $html = '    <div class="row" id="remove-work-row">
            <div class="col-12 col-md-6 col-xl-3">
                                    <div class="form-group local-forms">
                                        <label>Designation <span class="login-danger">*</span></label>
                                        <input class="form-control" name="designation[]" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-forms">
                                        <label>Hospital<span class="login-danger">*</span></label>
                                        <input class="form-control" name="hospital[]" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-4">
                                    <div class="form-group local-forms">
                                        <label>Place <span class="login-danger">*</span></label>
                                        <input class="form-control" name="place[]" type="text" placeholder>
                                    </div>
                                </div>
                                <div class="col-12 col-md-6 col-xl-1">
                                    <div class="add-group">
                                        <a href="javascript:void(0);" id="remove_work" class=" btn btn-primary ms-2"> <img src="' . asset('assets/img/icons/trash.svg') . '" alt> </a>
                                    </div>
                                </div>
                                </div>';

        return  response()->json($html);
    }
    public function academicsHtml(Request $request)
    {
        $html = '  <div class="row" id="remove-academics-row">
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Education <span class="login-danger">*</span></label>
                                            <input class="form-control" name="education[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>College/University<span class="login-danger">*</span></label>
                                            <input class="form-control" name="college[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Year <span class="login-danger">*</span></label>
                                            <input class="form-control" name="year[]" type="text" placeholder="2000-2003">
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove_academics" class=" btn btn-primary ms-2"> <img src="' . asset('assets/img/icons/trash.svg') . '" alt> </a>
                                        </div>
                                    </div>
                                </div>';

        return  response()->json($html);
    }
    public function getTherapist(Request $request)
    {
        if ($request->ajax()) {
            $data = Therapist::orderBy('id', 'DESC')->get();

            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<div ><a href="' . route('admin.view-therapist', ['slug' => $data->slug]) . '"  class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                     <a href="' . route('admin.edit-therapist', ['slug' => $data->slug]) . '"  class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a></div>';
                    return $actionBtn;
                })
                ->addColumn('service', function ($data) {

                    $html = '';
                    foreach ($data->services as $item) {
                        $service = Service::where('id', $item)->first();
                        $html .= ' <span class="text">';
                        $html .= '     <button class="custom-badge status-gray re-shedule">' . $service->service_name . '</button>';
                        $html .= ' </span><br>';
                    }

                    return $html;
                })
                ->addColumn('therapist', function ($data) {

                    if ($data->image != NULL) {
                        $img = asset('assets/uploads/therapist/' . $data->image);
                    } else {
                        if ($data->gender == 'MALE') {
                            $img = asset('assets/img/male-avatar.jpg');
                        } else {
                            $img = asset('assets/img/female-avatar.webp');
                        }
                    }
                    $html = '<a href="' . route('admin.view-therapist', ['slug' => $data->slug]) . '"><div class="chat-user-group d-flex align-items-center">
<div class="img-users call-user">
<img src="' . $img . '" alt="img">
</div>
<div class="chat-users">
<div class="user-titles d-flex">
<h5>' . $data->prefix . $data->full_name . ' </h5>
</div>
<div class="user-text d-flex">
<p>' . $data->professional_credentials . '</p>
</div>
</div>
</div></a>';

                    return   $html;
                })


                ->addColumn('status', function ($data) {
                    $status = '';
                    $class = '';
                    if ($data->status == 'ACTIVE') {
                        $class = "success";
                        $val = 'BLOCKED';
                    } else {
                        $class = "danger";
                        $val = 'ACTIVE';
                    }
                    return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $data->status . '</span></a>';
                })
                ->addColumn('category', function ($data) {

                    return $data->providerCategory->name;
                })
                ->addColumn('designation', function ($data) {
                    return $data->designation;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function viewTherapist(Request $request)
    {


        $data = Therapist::where('slug', $request->slug)->first();
        $slot = Slot::where('therapist_id', $data->id)->first();

        return view('admin.therapist.view', ['data' => $data, 'slot' => $slot]);
    }

    public function editTherapist(Request $request)
    {
        $data = Therapist::where('slug', $request->slug)->first();
        return view('admin.therapist.edit', ['data' => $data]);
    }
    public function editTherapistId(Request $request)
    {
        $slug = Therapist::where('id', $request->id)->pluck('slug')->first();
        return redirect()->route('admin.edit-therapist', ['slug' => $slug]);
    }

    public function updateTherapist(Request $request)
    {
        try {
            // $request->validate([
            //     'prefix' => 'required',
            //     'full_name' => 'required',
            //     'provider_category' => 'required',
            //     'professional_credentials' => 'required',
            //     'mobile' => 'required',
            //     'email' => 'required',
            //     'qualification' => 'required',
            //     'designation_in_yc' => 'required',
            //     'language_known' => 'required',
            //     'experience' => 'required',
            //     'employee_id' => 'required',
            //     'dob' => 'required',
            //     'gender' => 'required',
            //     'address' => 'required',
            //     'city' => 'required',
            //     'state' => 'required',
            //     'country' => 'required',
            //     'postal_code' => 'required'
            // ]);

            $joining_date = str_replace('/', '-', $request->joining_date);
            $joining_date = date("Y-m-d", strtotime($joining_date));
            $dob = str_replace('/', '-', $request->dob);
            $dob = date("Y-m-d", strtotime($dob));

            $image = '';
            $data = Therapist::where('id', $request->id)->first();

            if ($request->full_name != $data->full_name) {
                $slug = SlugService::createSlug(Therapist::class, 'slug', $request->full_name);
            } else {
                $slug = $data->slug;
            }

            $params = [
                'employee_id' => $request->employee_id,
                'prefix' => $request->prefix,
                'full_name' => $request->full_name,
                'slug' => $slug,
                'professional_credentials' => $request->professional_credentials,
                'provider_category_id' => $request->provider_category,
                'services' => $request->services,
                'slot_setting_permission' => $request->slot_managment,
                'experience' => $request->experience,
                'mobile' => $request->mobile,
                'email' => $request->email,
                'joining_date' => $joining_date,
                'qualification' => $request->qualification,
                'designation' => $request->designation_in_yc,
                'language_known' => $request->language_known,
                'address' => $request->address,
                'city' => $request->city,
                'state' => $request->state,
                'country' => $request->country,
                'postal_code' => $request->postal_code,
                'biography' => $request->biography,
                'personal_background' => $request->personal_background,
                'research_and_publications' => $request->research_and_publications,
                'approach_and_treatment' => $request->approach_and_treatment,
                'philosophy_and_approach' => $request->philosophy_and_approach,
                'specialization_and_expertise' => json_encode($request->specialization_and_expertise),
                'client_focus_and_population' => $request->client_focus_and_population,
                'awards' => $request->awards,
                'dob' => $dob,
                'gender' => $request->gender,
            ];

            $res = Therapist::where('id', $request->id)
                ->update($params);

            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                if ($request->hasFile('image')) {
                    $rand = rand(100, 999);
                    $image = time() . '.' . $request->image->extension();
                    $imageOriginalName = $request->image->getClientOriginalName();
                    $request->image->move(public_path('assets/uploads/therapist'), $image);
                }
                $res = Therapist::where('id', $request->id)
                    ->update([
                        'image' => $image
                    ]);
            }
            // ******** Image uploade end ********

            if (!empty($request->designation)) {
                $work_count = count($request->designation);
                for ($i = 0; $i < $work_count; $i++) {
                    if (isset($request->work_id[$i])) {
                        $work_param = [
                            'designation' => $request->designation[$i],
                            'hospital' => $request->hospital[$i],
                            'place' => $request->place[$i]
                        ];
                        $resFee = TherapistWorkExperience::where('id', $request->work_id[$i])
                            ->update(
                                $work_param
                            );
                    } else {

                        $therapistWorkExperience = new TherapistWorkExperience();
                        $therapistWorkExperience->therapist_id = $request->id;
                        $therapistWorkExperience->designation = $request->designation[$i];
                        $therapistWorkExperience->hospital = $request->hospital[$i];
                        $therapistWorkExperience->place = $request->place[$i];
                        $therapistWorkExperience->save();
                    }
                }
            }

            if (!empty($request->education)) {
                $academics_count = count($request->education);

                for ($i = 0; $i < $academics_count; $i++) {
                    if (isset($request->academic_id[$i])) {
                        $param = [
                            'education' => $request->education[$i],
                            'college' => $request->college[$i],
                            'year' => $request->year[$i]
                        ];
                        $resFee = TherapistAcademicsExperience::where('id', $request->academic_id[$i])
                            ->update(
                                $param
                            );
                    } else {
                        $therapistAcademicsExperience = new TherapistAcademicsExperience();
                        $therapistAcademicsExperience->therapist_id = $request->id;
                        $therapistAcademicsExperience->education = $request->education[$i];
                        $therapistAcademicsExperience->college = $request->college[$i];
                        $therapistAcademicsExperience->year = $request->year[$i];
                        $therapistAcademicsExperience->save();
                    }
                }
            }

            if (!empty($request->licensing_and_certifications_name)) {
                $license_count = count($request->licensing_and_certifications_name);

                for ($i = 0; $i < $license_count; $i++) {
                    if (isset($request->license_id[$i])) {

                        $param = [
                            'name' => $request->licensing_and_certifications_name[$i],
                            'date' => date("Y-m-d", strtotime($request->expiry_date[$i]))
                        ];
                        $resFee = Licensing::where('id', $request->license_id[$i])
                            ->update(
                                $param
                            );
                    } else {
                        $licensing = new Licensing();
                        $licensing->therapist_id = $request->id;
                        $licensing->name = $request->licensing_and_certifications_name[$i];
                        $licensing->date = date("Y-m-d", strtotime($request->expiry_date[$i]));
                        $licensing->save();
                    }
                }
            }

            if (!empty($request->training_education)) {
                $training_count = count($request->training_education);
                for ($i = 0; $i < $training_count; $i++) {
                    if (isset($request->training_id[$i])) {
                        $param = [
                            'education' => $request->training_education[$i],
                            'college' => $request->training_college[$i],
                            'year' => $request->training_year[$i]
                        ];
                        $resFee = TherapistAdditionalTraining::where('id', $request->training_id[$i])
                            ->update(
                                $param
                            );
                    } else {
                        $therapistTrainingExperience = new TherapistAdditionalTraining();
                        $therapistTrainingExperience->therapist_id = $request->id;
                        $therapistTrainingExperience->education = $request->training_education[$i];
                        $therapistTrainingExperience->college = $request->training_college[$i];
                        $therapistTrainingExperience->year = $request->training_year[$i];
                        $therapistTrainingExperience->save();
                    }
                }
            }

            return true;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function deleteTherapist(Request $request)
    {

        $data = Therapist::whereRaw('id = ?', $request->id)->first();

        if ((file_exists(public_path('assets/uploads/therapist/' . $data->image))) && ($data->image != NULL)) {
            unlink("assets/uploads/therapist/" . $data->image);
        }

        $res = Therapist::where('id', $request->id)->delete();
        return $res;
    }

    public function deleteTherapistWork(Request $request)
    {
        $res = TherapistWorkExperience::where('id', $request->id)->delete();
        return $res;
    }

    public function deleteTherapistAcademic(Request $request)
    {
        $res = TherapistAcademicsExperience::where('id', $request->id)->delete();
        return $res;
    }
    public function deleteTherapistTraining(Request $request)
    {
        $res = TherapistAdditionalTraining::where('id', $request->id)->delete();
        return $res;
    }
    public function deleteTherapistLicense(Request $request)
    {
        $res = Licensing::where('id', $request->id)->delete();
        return $res;
    }
    public function changeTherapistStatus(Request $request)
    {
        $res = Therapist::where('id', $request->id)
            ->update(['status' => $request->status]);
        return $res;
    }
    public function featuredTherapistStatus(Request $request)
    {
        $res = Therapist::where('id', $request->id)
            ->update(['featured' => $request->status]);
        return $res;
    }
    public function emailExist(Request $request)
    {
        $res = Therapist::where('email', $request->email)->first();

        if (!empty($res)) {
            return true;
        } else {
            return false;
        }
    }
    public function mobileExist(Request $request)
    {
        $res = Therapist::where('mobile', $request->mobile)->first();
        if (!empty($res)) {
            return true;
        } else {
            return false;
        }
    }
    public function providerCategory(Request $request)
    {
        $therapist = Therapist::where('id', $request->id)->first();
        return $therapist->provider_category_id;
    }

    public function trainingHtml(Request $request)
    {
        $html = '  <div class="row" id="remove-training-row">
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Education <span class="login-danger">*</span></label>
                                            <input class="form-control" name="training_education[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>College/University<span class="login-danger">*</span></label>
                                            <input class="form-control" name="training_college[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Year <span class="login-danger"></span></label>
                                            <input class="form-control" name="training_year[]" type="text" placeholder="2000-2003">
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove_training" class=" btn btn-primary ms-2"> <img src="' . asset('assets/img/icons/trash.svg') . '" alt> </a>
                                        </div>
                                    </div>
                                </div>';

        return  response()->json($html);
    }
    public function licensingHtml(Request $request)
    {
        $html = '  <div class="row" id="remove_licensing-row">
                                    <div class="col-12 col-md-6 col-xl-6">
                                        <div class="form-group local-forms">
                                            <label>Licensing and Certifications Name <span class="login-danger">*</span></label>
                                            <input class="form-control" name="licensing_and_certifications_name[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-5">
                                        <div class="form-group local-forms">
                                            <label>Expiry Date<span class="login-danger">*</span></label>
                                            <input class="form-control datetimepicker" name="expiry_date[]" type="text" placeholder>
                                        </div>
                                    </div>
                             
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove_licensing" class=" btn btn-primary ms-2"> <img src="' . asset('assets/img/icons/trash.svg') . '" alt> </a>
                                        </div>
                                    </div>
                                </div>';

        return  response()->json($html);
    }


    // **************************** Specialization ******************************
    public function saveSpecialization(Request $request)
    {
        try {
            $request->validate([
                'tag' => 'required'
            ]);

            $data = new Specialization();
            $data->tag = $request->tag;
            $data->save();

            if (!$data) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function getSpecialization(Request $request)
    {
        if ($request->ajax()) {
            $data = Specialization::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
    <a href="javascript:void(0);" data-id="' . $data->id . '" id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_specialization"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('tag', function ($data) {
                    return $data->tag;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteSpecialization(Request $request)
    {
        try {
            $res = Specialization::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    // *************************** Specialization ***********************************

    public function resetTherapistPassword(Request $request)
    {
        if ($request->password == $request->confirm_password) {
            $res =   Therapist::where('id', $request->id)
                ->update([
                    'password' => bcrypt($request->password)
                ]);

            if ($res == 1) {

                $mailData = [
                    'name' => $request->full_name,
                    'username' => $request->mobile,
                    'password' => $request->password,
                    'content' => 'Your account password on the Yellowcloud has been updated. '
                ];

                // Mail::to($request->email)->send(new TherapistRegisterNotificationMail($mailData));
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }


    public function getearnings(Request $request)
    {
        if ($request->ajax()) {
            $data = TherapistCommission::orderBy('id', 'DESC')->orderBy('id', 'DESC')->get();
            if ($request->filled('from') && $request->filled('to')) {
                $data = $data->whereBetween('created_at', [date("Y-m-d", strtotime($request->from)), date("Y-m-d", strtotime($request->to))]);
            }
            if ($request->filled('therapist')) {
                $data = $data->where('therapist_id', $request->therapist);
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('date', function ($data) {
                    return   date("d-m-Y H:i:s", strtotime($data->created_at));
                })
                ->addColumn('Session ID', function ($data) {
                    $session = Appointments::where('id', $data->appoinment_id)->pluck('session_id')->first();
                    return '<a href="' . route('admin.view-appoinment', ['id' => $data->appoinment_id]) . '" target="_blank">' . Str::limit($session, 20) . '</a>';
                })
                ->addColumn('therapist', function ($data) {
                    if ($data->therapist->image != NULL) {
                        $name = $data->therapist->prefix . " " . $data->therapist->full_name;
                    } else {
                        $name = "USER NOT fOUND";
                    }
                    return   $name;
                })
                ->addColumn('amount', function ($data) {
                    return   $data->amount;
                })
                ->addColumn('Commission', function ($data) {
                    return   $data->commission . '%';
                })
                ->addColumn('platform_fee', function ($data) {
                    return   $data->platform_fee;
                })
                ->addColumn('therapist_earnings', function ($data) {
                    return   $data->therapist_earnings;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }


    public function saveSettlement(Request $request)
    {

        try {

            $settlement = new Settlement();
            $settlement->therapist_id = $request->therapist_id;
            $settlement->amount = $request->amount;
            $settlement->start_date = $request->payment_from;
            $settlement->end_date = $request->payment_to;
            $settlement->payment_date = $request->payment_date;
            $settlement->settlement_id = $request->settlement_id;
            $settlement->save();

            if ($settlement) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Settlement Added Successfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    public function getSettlements(Request $request)
    {
        if ($request->ajax()) {
            $data = Settlement::orderBy('id', 'DESC')->get();

            if ($request->filled('from') && $request->filled('to')) {
                $data = $data->whereBetween('payment_date', [date("Y-m-d", strtotime($request->from)), date("Y-m-d", strtotime($request->to))]);
            }
            if ($request->filled('therapist')) {
                $data = $data->where('therapist_id', $request->therapist);
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
                     <a href="' . route('admin.edit-settlement', ['id' => $data->id]) . '"   class="text-muted" > <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_settlement"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('settlement_id', function ($data) {
                    return $data->settlement_id;
                })
                ->addColumn('therapist', function ($data) {
                    if ($data->therapist->image != NULL) {
                        $name = $data->therapist->prefix . " " . $data->therapist->full_name;
                    } else {
                        $name = "USER NOT fOUND";
                    }
                    return   $name;
                })
                ->addColumn('amount', function ($data) {
                    return   $data->amount;
                })
                ->addColumn('payment_date', function ($data) {
                    return   $data->payment_date;
                })
                ->addColumn('Payment Of', function ($data) {
                    return  '<p style="text-align:center;">' . $data->start_date . '<br> to <br> ' . $data->end_date . '</p>';
                })

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function editSettlement(Request $request)
    {
        $data = Settlement::where('id', $request->id)->first();
        return view('admin.therapist.edit-settlement', ['data' => $data]);
    }

    public function deleteSettlement(Request $request)
    {
        try {
            $res = Settlement::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function updateSettlement(Request $request)
    {

        try {

            $settlement = Settlement::where('id', $request->id)->update([
                'therapist_id' => $request->therapist_id,
                'amount' => $request->amount,
                'start_date' => $request->payment_from,
                'end_date' => $request->payment_to,
                'payment_date' => $request->payment_date,
                'settlement_id' => $request->settlement_id
            ]);

            if ($settlement) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Settlement updated Successfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }

    // **************************** therapistOrder ******************************
    public function savetherapistOrder(Request $request)
    {

        try {

            $validator = Validator::make($request->all(), [
                'therapist' => 'required',
                'order' => 'required|unique:therapists,order_number'
            ]);

            if ($validator->fails()) {
                return response()->json(['errors' => $validator->errors()], 422);
            }
            $data = Therapist::where('id', $request->therapist)->update(['order_number' => $request->order]);


            if ($data) {
                return response()->json(
                    array(
                        'status' => true, 'message' => 'Data updated successfully'
                    ),
                    200
                );
                //return response()->json(['status' => true, 'message' => 'Data updated successfully']);
            } else {
                return response()->json(
                    array(
                        'status' => false, 'message' => 'Something went wrong'
                    ),
                    200
                );
                // return response()->json(['status' => false, 'message' => 'Something went wrong']);
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function gettherapistOrder(Request $request)
    {
        if ($request->ajax()) {
            $data = Therapist::select('id', 'slug', 'full_name', 'image', 'order_number')->whereNotNull('order_number')->orderBy('order_number', 'ASC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
 <a href="javascript:void(0);" data-id="' . $data->id . '"  class="text-muted" data-bs-toggle="modal" data-bs-target="#update_therapistOrder' . $data->id . '"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
 <div id="update_therapistOrder' . $data->id . '" class="modal fade" role="dialog">
        <div class="modal-dialog modal-dialog-centered ">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Update Order Number</h5>

                </div>
                <div class="modal-body text-center">
                    <form action="post" action="' . route('admin.save-therapistOrder') . '">
                    <input type="hidden" name="_token" value="' . csrf_token() . '"> <div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <label>Therapist<span class="login-danger">*</span></label>
                                    <input class="form-control" value="' . $data->full_name . '"  type="text">
                                   <input class="form-control" value="' . $data->id . '" name="therapist" type="hidden">
                                   
                                </div>
                            </div>
                            </div>
                             <div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <label>Order<span class="login-danger">*</span></label>
                                    <input class="form-control" required name="order" value="' . $data->order_number . '" type="number">
                                </div>
                            </div>
                        </div>
                                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                            <button type="submit" class="btn btn-success ">ADD</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
 ';
                    return $actionBtn;
                })
                ->addColumn('therapist', function ($data) {

                    if ($data->image != NULL) {
                        $img = asset('assets/uploads/therapist/' . $data->image);
                    } else {
                        if ($data->gender == 'MALE') {
                            $img = asset('assets/img/male-avatar.jpg');
                        } else {
                            $img = asset('assets/img/female-avatar.webp');
                        }
                    }
                    $html = '<a href="' . route('admin.view-therapist', ['slug' => $data->slug]) . '">
     <div class="chat-user-group d-flex align-items-center">
         <div class="img-users call-user">
             <img src="' . $img . '" alt="img">
         </div>
         <div class="chat-users">
             <div class="user-titles d-flex">
                 <h5>' . $data->prefix . $data->full_name . ' </h5>
             </div>
             <div class="user-text d-flex">
                 <p>' . $data->professional_credentials . '</p>
             </div>
         </div>
     </div>
 </a>';

                    return $html;
                })
                ->addColumn('rank', function ($data) {
                    return $data->order_number;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function edittherapistOrder(Request $request)
    {
        try {
            $html = '';
            $res = Therapist::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    // *************************** therapistOrder ***********************************
}
