<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\CallMethods;
use App\Models\ProviderCategory;
use Illuminate\Http\Request;
use App\Models\Slot;
use App\Models\Therapist;
use App\Models\Service;
use App\Models\ServiceFeeStructure;
use App\Models\Leave;
use App\Models\WorkingHours;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;
use Carbon\CarbonPeriod;
use Carbon\Carbon;
use App\Models\SlotShedule;

class SlotController extends Controller
{

    public function addSlot(Request $request)
    {
        $slotds_id = Slot::select('therapist_id')->get();
        $therapist = Therapist::select('id', 'full_name')->whereNotIn('id', $slotds_id)->orderBy('full_name', 'ASC')->get();

        return view('admin.slot.add', ['therapist' => $therapist]);
    }

    public function addMoreTimeHTML(Request $request)
    {
        $therapist = Therapist::where('id', $request->therapist_id)->first();
        $res = ServiceFeeStructure::where('provider_category_id', $therapist->provider_category_id)->get();
        $service_id = [];
        foreach ($res as $item) {
            array_push($service_id, $item->service_id);
        }
        $service = Service::whereIn('id', $service_id)->get();


        $html = ' <div class="row" id="remove-row-' . $request->day . '">
         <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms" style="display:none;">
                                            <input type="checkbox" id="enableTax" value="' . $request->day . '" name="day[]">
                                            <span class="checkmark"></span> ' . $request->day . '
                                            </label>
                                        </div>
                                    </div>
                                
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>Start Time <span class="login-danger">*</span></label>
                                               <input type="hidden"  value="' . $request->day . '" name="day[]">
                                            <div class="time-icon">
                                                <input type="text" class="form-control datetimepicker01" name="start_time[]" >
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-4">
                                        <div class="form-group local-forms">
                                            <label>End Time <span class="login-danger">*</span></label>
                                            <div class="time-icon">
                                                <input type="text" class="form-control datetimepicker01" name="end_time[]" >
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                            <div class="form-group local-forms">
                                            <div class="add-group">
                                            <a href=" javascript:void(0);" id="remove_slot" data-value="' . $request->day . '" class=" btn btn-primary ms-2"> <img src="' . asset('assets/img/icons/trash.svg') . '" alt> </a>
                                        </div>
                                       </div>
                                    </div>';

        return  response()->json($html);
    }

    public function saveSlot(Request $request)
    {

        $request->validate([
            'provider' => 'required',
            'break_time' => 'required',
            'duration' => 'required'
        ]);

        try {
            $providercategory = Therapist::where('id', $request->provider)->pluck('provider_category_id')->first();
            $slot = new Slot();
            $slot->therapist_id = $request->provider;
            $slot->break_duration = $request->break_time;
            $slot->call_duration = $request->duration;
            $slot->save();

            if ($slot) {
                $slots = [];
                $workingHours = count($request->day);
                // foreach ($request->day as $j => $d) {

                foreach ($request->day as $i => $x) {

                    $workingHours = new WorkingHours();
                    $workingHours->slot_id = $slot->id;
                    // $workingHours->service_id = $request->service[$i];
                    $workingHours->day = $request->day[$i];
                    $workingHours->start_time = $request->start_time[$i];
                    $workingHours->end_time = $request->end_time[$i];
                    $workingHours->save();

                    $startTime = date("H:i", strtotime($request->start_time[$i]));
                    $endTime = date("H:i", strtotime($request->end_time[$i]));
                    //    $service = ServiceFeeStructure::where('provider_category_id', $providercategory)->groupBy('call_method_id')->get();
                    $service = CallMethods::get();

                    foreach ($service as $item) {
                        // $serviceDuration = date("i", strtotime($request->duration));
                        $serviceDuration = $request->duration;
                        $breakInterval = $request->break_time;
                        //  $breakTime = $breakInterval + $serviceDuration;
                        //  $breakTime = $breakTime . ' minutes';
                        $breakTime = $breakInterval . ' minutes';

                        $slots = slots($startTime, $breakTime, $endTime);

                        $data = [
                            'slot_id' => $workingHours->id,
                            'call_method_id' => $item->id,
                            'slots' =>  json_encode($slots)
                        ];
                        $slotShedule = SlotShedule::insert($data);
                    }
                }
                // }

                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function getSlot(Request $request)
    {
        if ($request->ajax()) {
            $data = Slot::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-slot', ['slug' => $data->id]) . '"  class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                     <a href="' . route('admin.edit-slot', ['slug' => $data->id]) . '"  class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('provider_category', function ($data) {
                    return   $data->therapist->full_name;
                })
                ->addColumn('break_time', function ($data) {
                    return $data->break_duration . ' Minutes';
                })
                ->addColumn('working_hours', function ($data) {
                    $prv_day = '';
                    $html = '<table>';
                    foreach (days() as $day) {
                        foreach ($data->workingHours as $item) {
                            if ($day == $item->day) {
                                $html .= "<tr><td>";
                                if ($prv_day == $item->day) {
                                    $html .= ' ';
                                } else {
                                    $html .= $item->day;
                                }
                                $html .= "</td>
                  <td> </td>
                  <td>" . $item->start_time . "</td>
                  <td>-</td>
                  <td>" . $item->end_time . "</td>
                  </tr>";
                                $prv_day = $item->day;
                            }
                        }
                    }
                    $html .= '</table>';
                    return $html;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }
    public function editSlot(Request $request)
    {
        $data = Slot::where('id', $request->slug)->first();

        return view('admin.slot.edit', ['data' => $data]);
    }

    public function viewSlot(Request $request)
    {
        $data = Slot::where('id', $request->slug)->first();
        return view('admin.slot.view', ['data' => $data]);
    }

    public function deleteSlot(Request $request)
    {
        $res = Slot::where('id', $request->id)->delete();
        $w = WorkingHours::where('slot_id', $request->id)->get();
        foreach ($w as $item) {
            SlotShedule::where('slot_id', $item->id)->delete();
        }

        WorkingHours::where('slot_id', $request->id)->delete();
        return $res;
    }
    public function deleteSlotHour(Request $request)
    {
        $res = WorkingHours::where('id', $request->id)->delete();
        return $res;
    }
    public function loadSlotHtml(Request $request)
    {
        $slot = Slot::where('id', $request->slot_id)->first();

        $html = '<tr class="default" id="remove-row-' . $request->day . '">
                                                                        
                                                                        <td>
                                                                            <div class="time-icon">
                                                                             <input type="hidden" name="slot_id[]" >
                                                                               <input type="hidden" name="day[]" value="' . $request->day . '">
                                                                                <input type="text" class="form-control datetimepicker01 starttime"  name="start_time[]">
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="time-icon">
                                                                                <input type="text" class="form-control  datetimepicker01 endtime"  name="end_time[]">
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <div class="add-group">
                                                                                <a href=" javascript:void(0);"  data-value="' . $request->day . '" class="remove_slot btn btn-primary ms-2"> <img src="' . asset('assets/img/icons/trash.svg') . '" alt> </a>
                                                                            </div>
                                                                        </td>
                                                                    </tr>';

        return response()->json($html);
    }

    public function updateSlot(Request $request)
    {

        $request->validate([
            'provider' => 'required',
            'break_time' => 'required',
            'duration' => 'required'
        ]);

        try {

            $params = [
                'therapist_id' => $request->provider,
                'break_duration' =>  $request->break_time,
                'call_duration' =>  $request->duration
            ];
            $res = Slot::where('id', $request->id)
                ->update($params);
            if ($res) {
                $slots = [];
                $workingHours = count($request->day);

                foreach ($request->day as $i => $x) {
                    if (isset($request->slot_id[$i])) {
                        $params = [
                            // 'service_id' =>  $request->service[$i],
                            'day' => $request->day[$i],
                            'start_time' =>  $request->start_time[$i],
                            'end_time' => $request->end_time[$i]
                        ];
                        $res = WorkingHours::where('id', $request->slot_id[$i])
                            ->update($params);
                        $slot_id = $request->slot_id[$i];
                        $del_slot = SlotShedule::where('slot_id', $slot_id)->get();
                        foreach ($del_slot as $item) {
                            $del = SlotShedule::where('id', $item->id)->delete();
                        }
                    } else {
                        $workingHours = new WorkingHours();
                        $workingHours->slot_id = $request->id;
                        // $workingHours->service_id = $request->service[$i];
                        $workingHours->day = $request->day[$i];
                        $workingHours->start_time = $request->start_time[$i];
                        $workingHours->end_time = $request->end_time[$i];
                        $workingHours->save();

                        $slot_id = $workingHours->id;
                    }
                    $startTime = date("H:i", strtotime($request->start_time[$i]));
                    $endTime = date("H:i", strtotime($request->end_time[$i]));
                    // $service = ServiceFeeStructure::where('provider_category_id', $request->provider_category)->get();
                    $service = CallMethods::get();
                    foreach ($service as $item) {
                        // $serviceDuration = date("i", strtotime($request->duration));
                        $serviceDuration = $request->duration;
                        $breakInterval = $request->break_time;
                        // $breakTime = $breakInterval + $serviceDuration;
                        // $breakTime = $breakTime . ' minutes';
                        $breakTime = $breakInterval . ' minutes';

                        $slots = slots($startTime, $breakTime, $endTime);

                        $data = [
                            'slot_id' => $slot_id,
                            'call_method_id' => $item->id,
                            'slots' =>  json_encode($slots)
                        ];
                        $slotShedule = SlotShedule::insert($data);
                    }
                }


                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function saveLeave(Request $request)
    {
        try {
            $leave = new Leave();
            $leave->therapist_id = $request->therapist_id;
            $leave->leave_from = $request->leave_from;
            $leave->leave_to = $request->leave_to;
            $leave->reason = $request->reason;
            $leave->save();

            if ($leave) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Leave  Added Successfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }


    public function getLeaves(Request $request)
    {
        if ($request->ajax()) {
            $data = Leave::orderBy('id', 'DESC')->get();

            if ($request->filled('from') && $request->filled('to')) {
                $data = $data->whereBetween('start_from', [date("Y-m-d", strtotime($request->from)), date("Y-m-d", strtotime($request->to))]);
            }
            if ($request->filled('therapist')) {
                $data = $data->where('therapist_id', $request->therapist);
            }
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
                     <a href="' . route('admin.edit-leave', ['id' => $data->id]) . '"   class="text-muted" > <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_settlement"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('therapist', function ($data) {
                    $therapist = Therapist::select('prefix', 'full_name')->where('id', $data->therapist_id)->first();
                    if ($therapist != null) {
                        $name = $therapist->prefix . " " . $therapist->full_name;
                    } else {
                        $name = "USER NOT fOUND";
                    }
                    return   $name;
                })
                ->addColumn('from', function ($data) {
                    return   $data->leave_from;
                })
                ->addColumn('to', function ($data) {
                    return   $data->leave_to;
                })
                ->addColumn('reason', function ($data) {
                    return $data->reason;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteLeave(Request $request)
    {
        $res = Leave::where('id', $request->id)->delete();
        return $res;
    }
    public function editLeave(Request $request)
    {
        $res = Leave::where('id', $request->id)->first();
        return view('admin.therapist.edit-leave', ['data' => $res]);
    }

    public function updateLeave(Request $request)
    {
        try {
            $leave = Leave::where('id', $request->id)
                ->update([
                    'therapist_id' => $request->therapist_id,
                    'leave_from' => $request->leave_from,
                    'leave_to' => $request->leave_to,
                    'reason' => $request->reason
                ]);

            if ($leave) {
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "Leave  Updated Successfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went Wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
            // return $e->getMessage();
        }
    }
}
