<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Service;
use App\Models\ServiceFeeStructure;
use App\Models\ProviderCategory;
use App\Models\CallMethods;
use App\Models\Therapist;
use App\Models\Package;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;

class ServiceController extends Controller
{
    public function saveService(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
            // 'sessions' => 'required',
            'image' => 'required'
        ]);

        try {
            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/service'), $image);
            }
            // ******** Image uploade end ********
            $slug = SlugService::createSlug(Service::class, 'slug', $request->title);
            $service = new Service();
            $service->service_name = $request->title;
            $service->slug = $slug;
            $service->description = $request->description;
            $service->image = $image;
            // $service->duration = $request->sessions;
            $service->save();


            $fee_count = count($request->provider_category);
            for ($i = 0; $i < $fee_count; $i++) {
                $serviceFee = new ServiceFeeStructure();
                $serviceFee->service_id = $service->id;
                $serviceFee->provider_category_id = $request->provider_category[$i];
                $serviceFee->call_method_id = $request->call_method[$i];
                $serviceFee->duration = $request->duration[$i];
                $serviceFee->rate = $request->rate[$i];
                $serviceFee->save();
            }
            if (!$service && !$serviceFee) {
                return false;
            } else {
                return true;
            }
            //  return back()->with('success', "Service Added Successfully");
        } catch (QueryException $e) {
            return $e->getMessage();
            // return back()->with('error', $e->getMessage());
        }
    }

    public function feeHtml(Request $request)
    {
        $html = '  <div class="row" id="remove-row">
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Provider Category <span class="login-danger">*</span></label>

                                            <select class="form-control select" name="provider_category[]">';
        foreach (ProviderCategory::get() as $item) {
            $html .= ' <option value="' . $item->id . '">' . $item->name . '</option>';
        }
        $html .= ' </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Call Method<span class="login-danger">*</span></label>
                                            <select class="form-control select" name="call_method[]">';
        foreach (CallMethods::get() as $item) {
            $html .= '<option value="' . $item->id . '">' . $item->name . '</option>';
        }
        $html .= '   </select>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-3">
                                        <div class="form-group local-forms">
                                            <label>Duration<span class="login-danger">*</span></label>
                                            <input class="form-control" name="duration[]" type="number" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-2">
                                        <div class="form-group local-forms">
                                            <label>Rate<span class="login-danger">*</span></label>
                                            <input class="form-control" name="rate[]" type="text" placeholder>
                                        </div>
                                    </div>
                                    <div class="col-12 col-md-6 col-xl-1">
                                        <div class="add-group">
                                           <a href="javascript:void(0);" id="remove" class="btn btn-primary  ms-2"> <img src="' . asset('assets/img/icons/trash.svg') . '" alt> </a>
                                        </div>
                                    </div>
                                </div>';

        return  response()->json($html);
    }

    public function getService(Request $request)
    {
        if ($request->ajax()) {
            $data = Service::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.view-service', ['slug' => $data->slug]) . '"  class="text-muted"> <span class="badge badge-primary"><i class="far fa-eye"></i></span></a>
                     <a href="' . route('admin.edit-service', ['slug' => $data->slug]) . '"  class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_patient"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('title', function ($data) {
                    $html = '<a href="' . route('admin.view-service', ['slug' => $data->slug]) . '"><img width="28" height="28" src="' . asset('assets/uploads/service/' . $data->image) . '" class="rounded-circle m-r-5" alt="">' . $data->service_name . '</a>';
                    return   $html;
                })


                ->addColumn('status', function ($data) {
                    $status = '';
                    $class = '';
                    if ($data->status == 'ACTIVE') {
                        $class = "success";
                        $val = 'BLOCKED';
                    } else {
                        $class = "danger";
                        $val = 'ACTIVE';
                    }
                    return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $data->status . '</span></a>';
                })

                ->escapeColumns([])

                ->make(true);
        }
    }

    public function viewService(Request $request)
    {
        $data = Service::where('slug', $request->slug)->first();
        return view('admin.service.view', ['data' => $data]);
    }

    public function editService(Request $request)
    {
        $data = Service::where('slug', $request->slug)->first();
        return view('admin.service.edit', ['data' => $data]);
    }

    public function updateService(Request $request)
    {

        try {
            $request->validate([
                'title' => 'required',
                'description' => 'required',
                // 'sessions' => 'required',
            ]);


            $image = '';
            $data = Service::where('id', $request->id)->first();

            if ($request->title != $data->service_name) {
                $slug = SlugService::createSlug(Service::class, 'slug', $request->title);
            } else {
                $slug = $data->slug;
            }

            $params = [
                'service_name' => $request->title,
                'slug' => $slug,
                'description' => $request->description,
                'duration' =>  $request->sessions,
            ];
            $res = Service::where('id', $request->id)
                ->update($params);

            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                if ($request->hasFile('image')) {
                    $rand = rand(100, 999);
                    $image = time() . '.' . $request->image->extension();
                    $imageOriginalName = $request->image->getClientOriginalName();
                    $request->image->move(public_path('assets/uploads/service'), $image);
                }
                $res = Service::where('id', $request->id)
                    ->update([
                        'image' => $image
                    ]);
            }
            // ******** Image uploade end ********
            $fee_count = count($request->provider_category);
            for ($i = 0; $i < $fee_count; $i++) {
                if (isset($request->feeid[$i])) {
                    $fee = [
                        'service_id' => $request->id,
                        'provider_category_id' => $request->provider_category[$i],
                        'call_method_id' => $request->call_method[$i],
                        'duration' => $request->duration[$i],
                        'rate' => $request->rate[$i]
                    ];
                    $resFee = ServiceFeeStructure::where('id', $request->feeid[$i])
                        ->update(
                            $fee
                        );
                } else {
                    $serviceFee = new ServiceFeeStructure();
                    $serviceFee->service_id = $request->id;
                    $serviceFee->provider_category_id = $request->provider_category[$i];
                    $serviceFee->call_method_id = $request->call_method[$i];
                    $serviceFee->duration = $request->duration[$i];
                    $serviceFee->rate = $request->rate[$i];
                    $serviceFee->save();
                }
            }
            if ($res == 1) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function deleteService(Request $request)
    {

        $data = Service::whereRaw('id = ?', $request->id)->first();

        if ((file_exists(public_path('assets/uploads/service/' . $data->image))) && ($data->image != NULL)) {
            unlink("assets/uploads/service/" . $data->image);
        }

        $res = Service::where('id', $request->id)->delete();
        return $res;
    }

    public function deleteServiceFee(Request $request)
    {
        $res = ServiceFeeStructure::where('id', $request->id)->delete();
        return $res;
    }

    public function changeServiceStatus(Request $request)
    {
        $res = Service::where('id', $request->id)
            ->update(['status' => $request->status]);
        return $res;
    }
    public function loadService(Request $request)
    {

        //$therapist = Therapist::where('id', $request->id)->first();
        // $res = ServiceFeeStructure::where('provider_category_id', $therapist->provider_category_id)->get();
        $res = ServiceFeeStructure::where('provider_category_id', $request->id)->get();
        $service_id = [];
        foreach ($res as $item) {
            array_push($service_id, $item->service_id);
        }
        $service = Service::whereIn('id', $service_id)->get();
        // print_r($service);
        // die();
        // $html = '';
        // foreach ($service as $item) {
        //     $html = '<option value="{{$item->id}}">{{$item->service_name}}</option>';
        // }
        return response()->json($service);
    }
    public function loadServiceHtml(Request $request)
    {
        $html = '';
        $data = Therapist::where('id', $request->id)->first();
        foreach ($data->services as $item) {

            $service = Service::where('id', $item)->first();

            $html .= '  <option value="' . $service->id . '">' . $service->service_name . '</option>';
        }
        return response()->json($html);
    }
    public function loadSelectedServiceHtml(Request $request)
    {
        $html = '';
        $data = Therapist::where('id', $request->id)->first();
        foreach ($data->services as $item) {
            $service = Service::where('id', $item)->first();
            $html .= '  <option value="' . $service->id . '"   selected="true">' . $service->service_name . '</option>';
        }
        return response()->json($html);
    }

    public function loadServiceFeeHtml(Request $request)
    {

        $html = '';
        if (isset($request->package_id)) {
            $array = Package::select('id', 'service_id', 'service_fee_id')->where('id', $request->package_id)->first();

            if ($array->service_fee_id != '' || $array->service_fee_id != NULL) {

                $service_ids = json_decode($array->service_fee_id);

                $data1 = ServiceFeeStructure::whereIn('id', $service_ids)->orderBy('provider_category_id', 'DESC')->get();
                $data2 = ServiceFeeStructure::whereNotIn('id', $service_ids)->where('service_id', $request->id)->orderBy('provider_category_id', 'DESC')->get();
            } else {
                $data = ServiceFeeStructure::where('service_id', $request->id)->orderBy('provider_category_id', 'DESC')->get();
            }
        } else {

            $data = ServiceFeeStructure::where('service_id', $request->id)->orderBy('provider_category_id', 'DESC')->get();
        }
        $html .= '  <table class="table">
                                        <thead>
                                            <tr>
                                                <th>Select Row</th>
                                                <th>Provider Category</th>
                                                <th>Communication Methods</th>
                                                <th>Duration</th>
                                                <th>Rate</th>
                                            </tr>
                                        </thead>
                                        <tbody>';
        if (isset($request->package_id) && ($array->service_fee_id != '' || $array->service_fee_id != NULL)) {
            foreach ($data1 as  $item) {

                $html .= '    <tr>
                                                <td>
                                                    <input type="checkbox" name="service_fee_id[]" value=' . $item->id . ' checked>
                                                </td>
                                                <td>' . $item->providerCategory->name . '</td>
                                                <td>' . $item->callMethod->name . '</td>
                                                <td>' . $item->duration . ' Minutes</td>
                                                <td>' . $item->rate . '</td>
                                            </tr>';
            }

            foreach ($data2 as  $item) {

                $html .= '    <tr>
                                                <td>
                                                    <input type="checkbox" name="service_fee_id[]" value=' . $item->id . '>
                                                </td>
                                                <td>' . $item->providerCategory->name . '</td>
                                                <td>' . $item->callMethod->name . '</td>
                                                <td>' . $item->duration . ' Minutes</td>
                                                <td>' . $item->rate . '</td>
                                            </tr>';
            }
        } else {
            foreach ($data as  $item) {
                $html .= '    <tr>
                                                <td>
                                                 <input type="checkbox" name="service_fee_id[]" value=' . $item->id . '>
                                                </td>
                                                <td>' . $item->providerCategory->name . '</td>
                                                <td>' . $item->callMethod->name . '</td>
                                                <td>' . $item->duration . ' Minutes </td>
                                                <td>' . $item->rate . '</td>
                                            </tr>';
            }
        }
        $html .= '    </tbody>
                                    </table>';


        return response()->json($html);
    }
}
