<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;
use App\Models\Admin;
use Cviebrock\EloquentSluggable\Services\SlugService;

class RoleController extends Controller
{

    public function index()
    {
        $permission = Permission::get();
        return view('admin.adminUser.roles', compact('permission'));
    }
    public function saveRole(Request $request)
    {

        try {
            $this->validate($request, [
                'name' => 'required|unique:roles,name',
                'permission' => 'required',
            ]);

            $role = Role::create(['name' => $request->input('name')]);

            $permissions = Permission::whereIn('id', $request->input('permission'))->pluck('id', 'id')->all();
            $role->syncPermissions($permissions);

            return response()->json(
                array(
                    'status' => true,
                    'msg' => "Role Added Successfully"
                ),
                200
            );
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'msg' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function deleteRole(Request $request)
    {
        try {
            $res = DB::table("roles")->where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function editRole(Request $request)
    {
        try {
            $role = Role::find($request->id);
            $permission = Permission::get();
            $rolePermissions = DB::table("role_has_permissions")->where("role_has_permissions.role_id", $request->id)
                ->pluck('role_has_permissions.permission_id', 'role_has_permissions.permission_id')
                ->all();
            $html = '<div class="row m-t-20">
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <label>Role<span class="login-danger">*</span></label>
                                      <input class="form-control" required name="id" value="' . $role->id . '" type="hidden">
                                    <input class="form-control" required name="name" value="' . $role->name . '" type="text">
                                </div>
                            </div>

                            <div class=" col-12 col-md-12 col-xl-12 ">
                                <div class="form-group local-forms row mb-5">
                                    <label>Permissions<span class="login-danger">*</span></label>';
            foreach ($permission as $value) {
                $isChecked = in_array($value->id, $rolePermissions);
                $html .=  '  <div class="col-4 col-md-4 col-xl-4 mt-sm-2">
                                        <input type="checkbox" name="permission[]" class="form-check-input" value="' . $value->id . '"  ' . ($isChecked ? 'checked' : '') . '> ' . $value->name . '
                                    </div>';
            }
            $html .= '     </div>
                            </div>
                        </div>
                        <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>
                           <button type="submit" class="btn btn-danger" id="update_item">Update</button>
                        </div>';
            return $html;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function updateRole(Request $request)
    {
        try {

            $this->validate($request, [
                'name' => 'required',
                'permission' => 'required',
            ]);

            $role = Role::find($request->id);
            $role->name = $request->input('name');
            $role->save();

            $permissions = Permission::whereIn('id', $request->input('permission'))->pluck('id', 'id')->all();
            $role->syncPermissions($permissions);

            return response()->json(
                array(
                    'status' => true,
                    'msg' => "Role Updated Successfully"
                ),
                200
            );
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function getRole(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table("roles")->orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
    <a href="javascript:void(0);" data-id="' . $data->id . '" id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_role"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>
     <a href="javascript:void(0);" data-id="' . $data->id . '" class="edit_role"> <span class="badge badge-primary"><i class="far fa-edit"></i></span></a>
     ';
                    return $actionBtn;
                })
                ->addColumn('tag', function ($data) {
                    return $data->name;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }


    // ************************* users ************************

    public function saveUserRole(Request $request)
    {

        try {
            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/panelUser'), $image);
            }
            // ******** Image uploade end ********

            $slug = SlugService::createSlug(
                Admin::class,
                'slug',
                $request->name
            );


            $user = Admin::create([
                'role_id' => $request->input('role'),
                'name' => $request->input('name'),
                'slug' => $slug,
                'email' =>  $request->input('email'),
                'backup_email' =>  $request->input('alternative_email'),
                'password' => bcrypt($request->input('password')),
                'image' => $image,
                'phone_number' => $request->input('phone'),
                'dob' =>  date('Y-m-d', strtotime($request->input('dob'))),
                'gender' =>  $request->input('gender')

            ]);
            $role = Role::find($request->input('role'));
            $user->assignRole([$role->id]);
            return response()->json(
                array(
                    'status' => true,
                    'msg' => "User Added Successfully"
                ),
                200
            );
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'msg' => $e->getMessage()
                ),
                200
            );
        }
    }


    public function getUserRole(Request $request)
    {
        if ($request->ajax()) {
            $data = Admin::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '<a href="' . route('admin.edit-user-role', ['slug' => $data->slug]) . '"   class="text-muted" > <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_user"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';

                    return $actionBtn;
                })
                ->addColumn('name', function ($data) {
                    return $data->name;
                })
                ->addColumn('phone', function ($data) {
                    return $data->phone_number;
                })
                ->addColumn('email', function ($data) {
                    return $data->email;
                })
                ->addColumn('role', function ($data) {
                    return DB::table("roles")->where('id', $data->role_id)->pluck('name')->first();
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function editUserRole(Request $request)
    {

        $data = Admin::where('slug', $request->slug)->first();
        return view('admin.adminUser.edit-user-role', ['data' => $data]);
    }

    public function updateUserRole(Request $request)
    {

        try {
            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/panelUser'), $image);

                $resimage = Admin::where('id', $request->id)
                    ->update([
                        'image' => $image
                    ]);
            }
            // ******** Image uploade end ********
            $data = Admin::where('id', $request->id)->first();
            $name = $request->name;
            if ($request->name != $data->name) {
                $slug = SlugService::createSlug(Admin::class, 'slug', $name);
            } else {
                $slug = $data->slug;
            }



            $user = Admin::where('id', $request->input('id'))->update([
                'role_id' => $request->input('role'),
                'name' => $request->input('name'),
                'slug' => $slug,
                'email' =>  $request->input('email'),
                'backup_email' =>  $request->input('alternative_email'),
                'image' => $image,
                'phone_number' => $request->input('phone'),
                'dob' =>  date('Y-m-d', strtotime($request->input('dob'))),
                'gender' =>  $request->input('gender')

            ]);


            if ($user == 1) {
                if ($request->role != $data->role_id) {

                    $user = Admin::find($request->input('id'));
                    $role = Role::find($request->input('role'));
                    DB::table('model_has_roles')->where('model_id', $data->id)->delete();
                    $user->assignRole([$role->id]);
                }
                return response()->json(
                    array(
                        'status' => true,
                        'data' => "User details updated Successfully"
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => false,
                        'data' => "Something went wrong"
                    ),
                    200
                );
            }
        } catch (QueryException $e) {
            return response()->json(
                array(
                    'status' => false,
                    'data' => $e->getMessage()
                ),
                200
            );
        }
    }

    public function deleteUserRole(Request $request)
    {
        try {
            $data = Admin::where('id', $request->id)->first();

            if ((file_exists(public_path('assets/uploads/panelUser/' . $data->image))) && ($data->image != NULL)) {
                unlink("assets/uploads/user/" . $data->image);
            }

            $res = Admin::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
}
