<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CallMethods;
use App\Models\Appointments;
use App\Models\User;
use App\Models\PaymentDetails;
use App\Models\UserWallet;
use App\Models\UserWalletTransactions;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\DB;

class ReportController extends Controller
{
    public function index(Request $request)
    {
        $from = $request->from_date;
        $to = $request->to_date;
        $visitors = Appointments::select(
            "Appointment_Date",
            DB::raw('COUNT(*) as click')
        )
            //    ->where('Appointment_Status', 'Completed')
            ->groupBy('Appointment_Date')
            ->orderBy('id', 'asc')->get();

        $result[] = ['Appointment_Date', 'Consulations'];
        foreach ($visitors as $key => $value) {
            $result[++$key] = [$value->Appointment_Date, (int)$value->click];
        }

        return view('admin.report.consultation-report', compact('result'));
    }

    public function graphfilter(Request $request)
    {
        $from = $request->from_date;
        $to = $request->to_date;

        $visitors = Appointments::select(
            "Appointment_Date",
            DB::raw('COUNT(*) as click')
        )
            ->where(function ($query) use ($from, $to) {
                if ($from && $to) {
                    $query->whereBetween('Appointment_Date', [$from, $to]);
                }
            })
            ->groupBy('Appointment_Date')
            ->orderBy('id', 'asc')->get();

        $result[] = ['Appointment_Date', 'Consulations'];
        foreach ($visitors as $key => $value) {
            $result[++$key] = [$value->Appointment_Date, (int)$value->click];
        }
        return $result;
    }

    public function graphfilterincome(Request $request)
    {
        $from = $request->from_date;
        $to = $request->to_date;

        $visitors = Appointments::select(
            "Appointment_Date",
            DB::raw('SUM(fee) as income')
        )
            ->where(function ($query) use ($from, $to) {
                if ($from && $to) {
                    $query->whereBetween('Appointment_Date', [$from, $to]);
                }
            })
            //->where('Appointment_Status', 'Completed')
            ->groupBy('Appointment_Date')
            ->orderBy('id', 'asc')->get();

        $result[] = ['Appointment_Date', 'income'];
        foreach ($visitors as $key => $value) {
            $result[++$key] = [$value->Appointment_Date, (int)$value->income];
        }
        return $result;
    }
    public function getConsultationReport(Request $request)
    {
        if ($request->ajax()) {
            $data = Appointments::orderBy('id', 'DESC')->get();
            if ($request->filled('from') && $request->filled('to')) {
                $data = $data->whereBetween('Appointment_Date', [date("Y-m-d", strtotime($request->from)), date("Y-m-d", strtotime($request->to))]);
            }
            if ($request->filled('therapist')) {
                $data = $data->where('therapist_id', $request->therapist);
            }
            if ($request->filled('status')) {
                $data = $data->where('Appointment_Status', $request->status);
            }
            if ($request->filled('package')) {
                $data = $data->where('package_id', $request->package);
            }
            return Datatables::of($data)
                ->addColumn('id', function ($data) {
                    return '<a href="' . route('admin.invoice', ['id' => $data->id]) . '" target="_blank">#INV' . $data->invoice_number . '</a>';
                })
                ->addColumn('invoice_date', function ($data) {
                    return date("d M Y", strtotime($data->created_at));
                })
                ->addColumn('patient', function ($data) {

                    if (empty($data->user)) {
                        $name = "USER not found";
                    } else {
                        $name = $data->user->Patient_Identification_Number;
                    }
                    return   $name;
                })
                ->addColumn('patient_name', function ($data) {

                    if (empty($data->user)) {
                        $name = "USER not found";
                    } else {
                        $name = $data->user->First_Name . ' ' . $data->user->Last_Name . '<br>Phone: ' . $data->user->SMS;
                    }
                    return   $name;
                })
                ->addColumn('therapist', function ($data) {
                    if ($data->therapist->image != NULL) {
                        $name = $data->therapist->prefix . " " . $data->therapist->full_name;
                    } else {
                        $name = "USER NOT fOUND";
                    }
                    return   $name;
                })
                ->addColumn('date', function ($data) {
                    return date("d M Y", strtotime($data->Appointment_Date));
                })
                ->addColumn('status', function ($data) {
                    return $data->Appointment_Status;
                })
                ->addColumn('communication_type', function ($data) {
                    $type = CallMethods::where('id', $data->Appointment_Type)->pluck('name')->first();
                    return $type;
                })
                ->addColumn('fee', function ($data) {
                    return $data->fee;
                })

                ->escapeColumns([])

                ->make(true);
        }
    }
    // ****************** invoice report 
    public function invoiceReport(Request $request)
    {
        $from = $request->from_date;

        $to = $request->to_date;
        $visitors = Appointments::select(
            "Appointment_Date",
            DB::raw('COUNT(*) as click')
        )
            //  ->where('Appointment_Status', 'Completed')
            ->groupBy('Appointment_Date')
            ->orderBy('id', 'asc')->get();

        $result[] = ['Appointment_Date', 'Consulations'];
        foreach ($visitors as $key => $value) {
            $result[++$key] = [$value->Appointment_Date, (int)$value->click];
        }

        return view('admin.report.invoice-report', compact('result'));
    }

    public function getInvoiceReport(Request $request)
    {

        if ($request->ajax()) {
            $data = Appointments::where('Appointment_Status','!=','Failed')->orderBy('id', 'DESC')->get();
            if ($request->filled('from') && $request->filled('to')) {
                $data = $data->whereBetween('Appointment_Booked_Date', [date("Y-m-d", strtotime($request->from)), date("Y-m-d", strtotime($request->to))]);
            }
            if ($request->filled('therapist')) {
                $data = $data->where('therapist_id', $request->therapist);
            }
            if ($request->filled('status')) {
                $data = $data->where('Appointment_Status', $request->status);
            }
            if ($request->filled('package')) {
                $data = $data->where('package_id', $request->package);
            }
            return Datatables::of($data)
                ->addColumn('id', function ($data) {
                    return '<a href="' . route('admin.invoice', ['id' => $data->invoice_number]) . '" target="_blank">#INV' . $data->invoice_number . '</a>';
                })
                ->addColumn('invoice_date', function ($data) {
                    return date("d M Y", strtotime($data->created_at));
                })
                ->addColumn('patient', function ($data) {

                    if (empty($data->user)) {
                        $name = "USER not found";
                    } else {
                        $name = $data->user->Patient_Identification_Number;
                    }
                    return   $name;
                })
                ->addColumn('patient_name', function ($data) {

                    if (empty($data->user)) {
                        $name = "USER not found";
                    } else {
                        $name = $data->user->First_Name . ' ' . $data->user->Last_Name . '<br>Phone: ' . $data->user->SMS;
                    }
                    return   $name;
                })
                ->addColumn('therapist', function ($data) {
                    if ($data->therapist->image != NULL) {
                        $name = $data->therapist->prefix . " " . $data->therapist->full_name;
                    } else {
                        $name = "USER NOT fOUND";
                    }
                    return   $name;
                })
                ->addColumn('date', function ($data) {
                    return date("d M Y", strtotime($data->Appointment_Date));
                })
                ->addColumn('status', function ($data) {
                    return $data->Appointment_Status;
                })
                ->addColumn('fee', function ($data) {
                    $GST_Amount = number_format($data->fee - ($data->fee / (1 + (18 / 100))), 2);
                    $Amount_Excluding_GST = number_format($data->fee - $GST_Amount, 2);
                    return $Amount_Excluding_GST;
                })
                ->addColumn('tax', function ($data) {
                    $GST_Amount = number_format($data->fee - ($data->fee / (1 + (18 / 100))), 2);
                    $Amount_Excluding_GST = number_format($data->fee - $GST_Amount, 2);
                    return  $GST_Amount;
                })
                ->addColumn('total', function ($data) {
                    return $data->fee;
                })
                ->addColumn('paid_currency', function ($data) {
                    if ($data->payment_id != NULL) {
                        $p = PaymentDetails::where('id', $data->payment_id)->pluck('currency')->first();
                        return $p;
                    } else {
                        return '';
                    }
                })
                ->addColumn('paid_amount', function ($data) {
                    if ($data->payment_id != NULL) {
                        $p = PaymentDetails::where('id', $data->payment_id)->pluck('amount_in_currency')->first();
                        return $p;
                    } else {
                        return '';
                    }
                })
                ->addColumn('payment_id', function ($data) {
                    return PaymentDetails::where('id', $data->payment_id)->pluck('payment_id')->first();
                })
                ->addColumn('wallet_amount', function ($data) {
                    return UserWalletTransactions::where('id', $data->wallet_trasaction_id)->pluck('amount')->first();
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    // ****************** patient report 
    public function patient(Request $request)
    {
        $from = $request->from_date;

        $to = $request->to_date;
        $visitors = User::select(
            "Reg_Date",
            DB::raw('COUNT(*) as click')
        )
            //  ->where('Appointment_Status', 'Completed')
            ->groupBy('Reg_Date')
            ->orderBy('id', 'asc')->get();

        $result[] = ['Registration_Date', 'Patients'];
        foreach ($visitors as $key => $value) {
            $result[++$key] = [$value->Appointment_Date, (int)$value->click];
        }

        return view('admin.report.patient-report', compact('result'));
    }

    public function getpatientReport(Request $request)
    {

        if ($request->ajax()) {
            $data = User::orderBy('id', 'DESC')->get();
            if ($request->filled('from') && $request->filled('to')) {
                $data = $data->whereBetween('Reg_Date', [date("Y-m-d", strtotime($request->from)), date("Y-m-d", strtotime($request->to))]);
            }


            return Datatables::of($data)
                ->addColumn('patient', function ($data) {
                    return $data->Patient_Identification_Number;
                })
                ->addColumn('patient_name', function ($data) {
                    return $data->First_Name . ' ' . $data->Last_Name;
                })
                ->addColumn('phone', function ($data) {
                    return   $data->SMS;
                })
                ->addColumn('reg_date', function ($data) {
                    return date("d M Y", strtotime($data->Reg_Date));
                })
                ->addColumn('dob', function ($data) {
                    return $data->dob;
                })
                ->addColumn('appointments', function ($data) {
                    return count(Appointments::where('user_id', $data->id)->where('Appointment_Status', '!=', 'Cancel')->get());
                })
                ->addColumn('amount', function ($data) {
                    return Appointments::where('user_id', $data->id)->sum('fee');
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function getWalletReport(Request $request)
    {
        if ($request->ajax()) {
            $data = UserWallet::orderBy('id', 'DESC')->get();

            return Datatables::of($data)
                ->addColumn('user', function ($data) {
                    if (empty($data->user)) {
                        $name = "USER not found";
                    } else {
                        $name = $data->user->First_Name . ' ' . $data->user->Last_Name . '<br>Phone: ' . $data->user->SMS;
                    }
                    return   $name;
                })
                ->addColumn('wallet_balance', function ($data) {
                    return $data->balance;
                })
                ->addColumn('total_debit_amount', function ($data) {
                    return   UserWalletTransactions::where('user_id', $data->user_id)->where('type', 'Debit')->sum('amount');
                })
                ->addColumn('total_credit_amount', function ($data) {
                    return UserWalletTransactions::where('user_id', $data->user_id)->where('type', 'Credit')->sum('amount');
                })


                ->escapeColumns([])

                ->make(true);
        }
    }
}
