<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Appointments;

class PushNotificationController extends Controller
{
    public function sendNotification(Request $request)
    {
        try {
            $firebaseToken = User::whereNotNull('device_token')->select('device_token')->get();

            $SERVER_API_KEY = env('FCM_SERVER_KEY');

            if (count($firebaseToken->toArray()) == 0) return response()->json(['message' => 'Notification Error, No user token registered', 'status' => false], 200);

            $firebaseToken = collect($firebaseToken->toArray())->map(function ($item) {
                return $item["device_token"];
            });

            $data = [
                "registration_ids" => $firebaseToken,
                "notification" => [
                    'title' => 'Sample Notification Title',
                    'body' => 'This is a sample push notification from Laravel to Flutter app.'
                ],
                "data" => [
                    "route" => "notification"
                ]
            ];
            $dataString = json_encode($data);

            $headers = [
                'Authorization: key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            // Disabling SSL Certificate support temporarly
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
            // Execute post
            $result = curl_exec($ch);
            if ($result === FALSE) {
                die('Curl failed: ' . curl_error($ch));
            }
            // Close connection
            curl_close($ch);
            // FCM response
            dd($result);

            die();

            $ch = curl_init();

            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);

            $response = curl_exec($ch);
            $result = json_decode($response);

            if ($request->ajax()) {
                return response()->json(['message' => 'Notfication Send Success', 'status' => true, 'response' => $response], 200);
            }

            return back()->with('success', "Notfication Send Successfully.");
        } catch (\Exception $exception) {
            if ($request->ajax()) {
                return response()->json(['message' => $exception->getMessage(), 'status' => false], 500);
            }
            return back()->with('error', "Oops! Something Went Wrong.");
        }
    }
}
