<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Podcast;
use App\Models\Therapist;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Str;
use Carbon\Carbon;


class PodcastController extends Controller
{


    // *************************** Podcast *****************************************

    public function savePodcast(Request $request)
    {

        try {

            // echo "hi";
            // die();
            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/podcast'), $image);
            }
            // ******** Image uploade end ********
            if ($request->hasFile('file')) {
                $uniqueid = uniqid();
                $original_name = $request->file('file')->getClientOriginalName();
                $size = $request->file('file')->getSize();
                $extension = $request->file('file')->getClientOriginalExtension();
                $name = Carbon::now()->format('Ymd') . '_' . $uniqueid . '.' . $extension;
                $request->file->move(public_path('assets/uploads/podcast/audio'), $name);
                // $imagepath = url('/storage/uploads/files/' . $name);
                // $path = $request->file('file')->storeAs('public/uploads/files/', $name);
            }
            $slug = SlugService::createSlug(
                Podcast::class,
                'slug',
                $request->title
            );
            if ($request->author == 'T') {
                $therapist = $request->therapist;
            } else {
                $therapist = null;
            }
            $podcast = new Podcast();
            $podcast->title = $request->title;
            $podcast->slug = $slug;
            $podcast->author = $request->author;
            $podcast->therapist_id = $therapist;
            $podcast->audio = $name;
            $podcast->image = $image;
            $podcast->tags = json_encode($request->tags);
            $podcast->color = $request->color;
            $podcast->duration = $request->audio_duration;
            $podcast->sub_title = $request->subtitle;
            $podcast->save();

            if (!$podcast) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function updatePodcast(Request $request)
    {
        try {

            $data = Podcast::where('id', $request->id)->first();

            if ($request->title != $data->title) {
                $slug = SlugService::createSlug(Podcast::class, 'slug', $request->title);
            } else {
                $slug = $data->slug;
            }
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                if ($request->hasFile('image')) {
                    $rand = rand(100, 999);
                    $image = time() . '.' . $request->image->extension();
                    $imageOriginalName = $request->image->getClientOriginalName();
                    $request->image->move(public_path('assets/uploads/podcast'), $image);
                }
                $res = Podcast::where('id', $request->id)
                    ->update([
                        'image' => $image
                    ]);
            }
            // ******** Image uploade end ********

            if ($request->hasFile('file')) {
                $uniqueid = uniqid();
                $original_name = $request->file('file')->getClientOriginalName();
                $size = $request->file('file')->getSize();
                $extension = $request->file('file')->getClientOriginalExtension();
                $name = Carbon::now()->format('Ymd') . '_' . $uniqueid . '.' . $extension;
                $request->file->move(public_path('assets/uploads/podcast/audio'), $name);
                // $imagepath = url('/storage/uploads/files/' . $name);
                // $path = $request->file('file')->storeAs('public/uploads/files/', $name);

                $res = Podcast::where('id', $request->id)
                    ->update([
                        'audio' => $name
                    ]);
            }
            if ($request->author == 'T') {
                $therapist = $request->therapist;
            } else {
                $therapist = null;
            }
            $res = Podcast::where('id', $request->id)
                ->update([
                    'title' => $request->title,
                    'slug' => $slug,
                    'author' => $request->author,
                    'therapist_id' => $therapist,
                    'tags' => $request->tags,
                    'color' => $request->color,
                    'duration' => $request->audio_duration,
                    'sub_title' => $request->subtitle
                ]);

            if ($res == 1) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function getPodcast(Request $request)
    {
        if ($request->ajax()) {
            $data = Podcast::query()
                ->with(['therapist' => function ($query) {
                    $query->select('id', 'image', 'full_name');
                }])
                ->orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
                     <a href="' . route('admin.edit-podcast', ['slug' => $data->slug]) . '"   class="text-muted" > <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_podcast"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('title', function ($data) {
                    // return   $data->title;
                    if ($data->image != NULL) {
                        $img = asset('assets/uploads/podcast/' . $data->image);
                    } else {
                        $img = asset('assets/img/no-image-available.jpg');
                    }
                    $html = '<div class="chat-user-group d-flex align-items-center">
                        <div class="img-users call-user">
                        <a href="#"><img src="' . $img . '" alt="img"></a>
                        </div>
                        <div class="chat-users chat-user-blk">
                        <div class="user-titles ">
                        <h5> ' . $data->title . '</h5>
                        <p>' . Str::limit((strip_tags($data->description)), 50, '...') . '</p>
                        </div>
                        </div>
                        </div>';
                    return $html;
                })
                ->addColumn('author', function ($data) {
                    $html = '';
                    if ($data->author == 'F') {
                        $html = '<img width="28" height="28" class="rounded-circle" src="' . asset('assets/img/fenni.jpg') . '" alt="">
<h2>Feni</h2>';
                    } elseif ($data->author == 'T') {
                        $full_name = Therapist::where('id', $data->therapist_id)->pluck('full_name')->first();
                        $image = Therapist::where('id', $data->therapist_id)->pluck('image')->first();
                        if ($image != NULL) {
                            $img = asset('assets/uploads/therapist/' . $image);
                        } else {
                            if ($data->gender == 'MALE') {
                                $img = asset('assets/img/male-avatar.jpg');
                            } else {
                                $img = asset('assets/img/female-avatar.webp');
                            }
                        }
                        $html = '<img width="28" height="28" class="rounded-circle" src="' . $img . '" alt="">
<h2>' . $full_name . '</h2>';
                    }
                    return   $html;
                })
                ->addColumn('status', function ($data) {
                    $status = '';
                    $class = '';
                    if ($data->status == 'ACTIVE') {
                        $class = "success";
                        $val = 'BLOCKED';
                    } else {
                        $class = "danger";
                        $val = 'ACTIVE';
                    }
                    return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $data->status . '</span></a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function changePodcastStatus(Request $request)
    {
        $res = Podcast::where('id', $request->id)
            ->update(['status' => $request->status]);
        return $res;
    }

    public function deletePodcast(Request $request)
    {
        try {
            $data = Podcast::where('id', $request->id)->first();

            if ((file_exists(public_path('assets/uploads/podcast/' . $data->image))) && ($data->image != NULL)) {
                unlink("assets/uploads/podcast/" . $data->image);
            }

            $res = Podcast::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function editPodcast(Request $request)
    {

        $data = Podcast::where('slug', $request->slug)->first();
        return view('admin.podcast.edit', ['data' => $data]);
    }

    public function viewPodcast(Request $request)
    {
        $data = Podcast::where('slug', $request->slug)->first();
        return view('admin.podcast.view', ['data' => $data]);
    }

    // ************************************* Podcast End ************************
}
