<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Package;
use App\Models\ServiceFeeStructure;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Illuminate\Http\JsonResponse;

class PackageController extends Controller
{
    public function index()
    {

        $data = Package::get();
        return view('admin.packages.list', ['data' => $data]);
    }
    public function viewPackage(Request $request)
    {
        $data = Package::where('slug', $request->slug)->first();
        $service_ids = json_decode($data->service_fee_id);
        $fee = ServiceFeeStructure::whereIn('id', $service_ids)->orderBy('provider_category_id', 'DESC')->get();

        return view('admin.packages.view', ['data' => $data, 'fee' => $fee]);
    }
    public function editPackage(Request $request)
    {
        $data = Package::where('slug', $request->slug)->first();
        return view('admin.packages.edit', ['data' => $data]);
    }
    public function savePackage(Request $request)
    {

        try {
            $request->validate([
                'title' => 'required',
                'no_of_sessions' => 'required',
                'duration' => 'required',
                'discount' => 'required',
                'image' => 'required'
            ]);

            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/package'), $image);
            }

            // ******** Image uploade end ********
            $slug = SlugService::createSlug(Package::class, 'slug', $request->title);

            $package = new Package();
            $package->service_id = $request->service;
            $package->service_fee_id = json_encode($request->service_fee_id);
            $package->title = $request->title;
            $package->slug = $slug;
            $package->no_of_sessions = $request->no_of_sessions;
            $package->duration = $request->duration;
            $package->discount = $request->discount;
            $package->image = $image;
            $package->description = $request->note;
            $package->save();
            if (!$package) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function updatePackage(Request $request)
    {
        try {
            $request->validate([
                'title' => 'required',
                'no_of_sessions' => 'required',
                'duration' => 'required',
                'discount' => 'required',
            ]);
            if ($request->service_fee_id) {
                $sf = $request->service_fee_id;
            } else {
                $sf = NULL;
            }

            $image = '';

            $data = Package::where('id', $request->id)->first();
            if ($request->title != $data->title) {
                $slug = SlugService::createSlug(Package::class, 'slug', $request->title);
            } else {
                $slug = $data->slug;
            }

            $params = [
                'service_id' => $request->service,
                'service_fee_id' => $sf,
                'title' => $request->title,
                'slug' => $slug,
                'no_of_sessions' => $request->no_of_sessions,
                'duration' => $request->duration,
                'discount' => $request->discount,
                'description' => $request->note
            ];

            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/package'), $image);
                $result = Package::where('id', $request->id)
                    ->update(['image' => $image]);
            }

            // ******** Image uploade end ********
            $result = Package::where('id', $request->id)
                ->update(
                    $params
                );

            if ($result == 1) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function deletePackage(Request $request)
    {

        $data = Package::whereRaw('id = ?', $request->id)->first();

        if ((file_exists(public_path('assets/uploads/package/' . $data->image))) && ($data->image != NULL)) {
            unlink("assets/uploads/package/" . $data->image);
        }

        $res = Package::where('id', $request->id)->delete();
        return $res;
    }

    public function autocomplete(Request $request): JsonResponse
    {
        $data = Package::select("title")
            ->where('title', 'LIKE', '%' . $request->get('query') . '%')
            ->get();

        return response()->json($data);
    }
}
