<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ThoughtofTheDay;
use App\Models\Banners;
use App\Models\User;
use App\Models\VideoBanner;
use App\Models\ReportAnIssue;
use App\Models\Tags;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use Yajra\DataTables\Facades\DataTables;
use GuzzleHttp\Client;
use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;

class HomePageController extends Controller
{

    public function saveThoughts(Request $request)
    {
        try {
            $request->validate([
                'day' => 'required',
                'image' => 'required'
            ]);

            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/thoughts'), $image);
            }
            // ******** Image uploade end ********



            $data = new ThoughtofTheDay();
            $data->day = $request->day;
            $data->image = $image;
            $data->save();

            if (!$data) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function getThoughts(Request $request)
    {
        if ($request->ajax()) {
            $data = ThoughtofTheDay::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
                     <a href="javascript:void(0);"  class="text-muted" data-id="' . $data->id . '"  data-day="' . $data->day . '" data-image="' . $data->image . '" id="getEditId" class="text-muted" data-bs-toggle="modal" data-bs-target="#edit_blog_category"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_thoughts"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('day', function ($data) {
                    return   $data->day;
                })
                ->addColumn('image', function ($data) {
                    return  '<img src="' . asset('assets/uploads/thoughts/' . $data->image) . '" alt="yellow cloud" width="200" height="100" >';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteThoughts(Request $request)
    {
        try {
            $data = ThoughtofTheDay::where('id', $request->id)->first();

            if ((file_exists(public_path('assets/uploads/thoughts/' . $data->image))) && ($data->image != NULL)) {
                unlink("assets/uploads/thoughts/" . $data->image);
            }

            $res = ThoughtofTheDay::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function editDeleteThoughts(Request $request)
    {
        $data = ThoughtofTheDay::where('id', $request->id)->first();
        $html = '  <div class=" col-12 col-md-12 col-xl-12">
                                <div class="form-group local-forms">
                                    <label>Select day <span class="login-danger">*</span></label>
                                    <select class="form-control" required name="day">
                                        <option value="Sunday"   "' . $data->day . '" == "Sunday" ? "selected" : ""   >Sunday</option>
                                        <option value="Monday"  "' . $data->day . '" == "Monday" ? "selected" : "" >Monday</option>
                                        <option value="Tuesday"  "' . $data->day . '" == "Tuesday" ? "selected" : "" >Tuesday</option>
                                        <option value="Wednesday"   "' . $data->day . '" == "Wednesday" ? "selected" : "">Wednesday</option>
                                        <option value="Thursday"  "' . $data->day . '" == "Thursday" ? "selected" : "" >Thursday</option>
                                        <option value="Friday"  "' . $data->day . '" == "Friday" ? "selected" : "">Friday</option>
                                        <option value="Saturday"  "' . $data->day . '" == "Saturday" ? "selected" : "">Saturday</option>
                                    </select>
                                </div>
                            </div>
                            <div class=" col-12 col-md-12 col-xl-12">
                                <div class="panel">
                                    <div class="button_outer">
                                        <div class="btn_upload">
                                            <input type="file" id="upload_file" name="image">
                                            Upload Image
                                        </div>
                                        <div class="processing_bar"></div>
                                        <div class="success_box"></div>
                                    </div>
                                </div>
                                <div class="error_msg"></div>
                                <div class="uploaded_file_view" id="uploaded_view">
                                    <span class="file_remove">X</span>
                                    <img src="' . asset('assets/uploads/thoughts/' . $data->image) . '" alt="yellow cloud"  >
                                </div>
                            </div>';

        return  response()->json($html);
    }

    public function updateThoughts(Request $request)
    {
        try {
            $request->validate([
                'day' => 'required'
            ]);

            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                if ($request->hasFile('image')) {
                    $rand = rand(100, 999);
                    $image = time() . '.' . $request->image->extension();
                    $imageOriginalName = $request->image->getClientOriginalName();
                    $request->image->move(public_path('assets/uploads/thoughts'), $image);
                }
                $res = ThoughtofTheDay::where('id', $request->id)
                    ->update([
                        'image' => $image
                    ]);
            }
            // ******** Image uploade end ********

            $res = ThoughtofTheDay::where('id', $request->id)
                ->update([
                    'day' => $request->day
                ]);

            if ($res == 1) {
                return true;
            } else {
                return false;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    public function saveBanners(Request $request)
    {
        try {
            $request->validate([
                'image' => 'required'
            ]);

            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/banners'), $image);
            }
            // ******** Image uploade end ********



            $data = new Banners();
            $data->image = $image;
            $data->save();

            if (!$data) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function getBanners(Request $request)
    {
        if ($request->ajax()) {
            $data = Banners::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
<a href="javascript:void(0);" data-id="' . $data->id . '" id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_banners"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('image', function ($data) {
                    return '<img src="' . asset('assets/uploads/banners/' . $data->image) . '" alt="yellow cloud" width="200" height="100">';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteBanners(Request $request)
    {
        try {
            $data = Banners::where('id', $request->id)->first();

            if ((file_exists(public_path('assets/uploads/banners/' . $data->image))) && ($data->image != NULL)) {
                unlink("assets/uploads/banners/" . $data->image);
            }

            $res = Banners::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }


    // **************************** Tags ******************************
    public function saveTags(Request $request)
    {

        try {
            $request->validate([
                'tag' => 'required'
            ]);

            $data = new Tags();
            $data->tag = $request->tag;
            $data->save();

            if (!$data) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function getTags(Request $request)
    {
        if ($request->ajax()) {
            $data = Tags::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
    <a href="javascript:void(0);" data-id="' . $data->id . '" id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_tags"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('tag', function ($data) {
                    return $data->tag;
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteTags(Request $request)
    {
        try {
            $res = Tags::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    // *************************** Tags ***********************************

    //************************** video Banner  *********************/


    public function saveVideoBanners(Request $request)
    {
        try {
            $request->validate([
                'image' => 'required'
            ]);

            $image = '';
            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $rand = rand(100, 999);
                $image = time() . '.' . $request->image->extension();
                $imageOriginalName = $request->image->getClientOriginalName();
                $request->image->move(public_path('assets/uploads/videobanners'), $image);
            }
            // ******** Image uploade end ********



            $data = new VideoBanner();
            $data->image = $image;
            $data->link = $request->link;
            $data->save();

            if (!$data) {
                return false;
            } else {
                return true;
            }
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    public function getVideoBanners(Request $request)
    {
        if ($request->ajax()) {
            $data = VideoBanner::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
<a href="javascript:void(0);" data-id="' . $data->id . '" id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_banners"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('image', function ($data) {
                    return '<img src="' . asset('assets/uploads/videobanners/' . $data->image) . '" alt="yellow cloud" width="200" height="100">';
                })
                ->addColumn('link', function ($data) {
                    return '<a href="' . $data->link . '"  target="_blank">Watch Video</a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteVideoeBanners(Request $request)
    {

        try {
            $data = VideoBanner::where('id', $request->id)->first();

            if ((file_exists(public_path('assets/uploads/videobanners/' . $data->image))) && ($data->image != NULL)) {
                unlink("assets/uploads/videobanners/" . $data->image);
            }

            $res = VideoBanner::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }

    //************************** video Banner  end *********************/


    public function getReportedissue(Request $request)
    {
        if ($request->ajax()) {
            $data = ReportAnIssue::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '
<a href="javascript:void(0);" data-id="' . $data->id . '" id="getDeleteId" class="text-muted" data-bs-toggle="modal" data-bs-target="#delete_banners"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('user', function ($data) {
                    $res = User::select('First_Name', 'Last_Name')->where('id', $data->user_id)->first();
                    return $data->First_Name . ' ' . $data->Last_Name;
                })
                ->addColumn('issue', function ($data) {
                    return $data->issue;
                })
                ->addColumn('description', function ($data) {
                    return $data->description;
                })
                ->addColumn('image', function ($data) {
                    return '<a download="' . $data->image . '.jpg" href="' . asset('assets/uploads/reportissue/' . $data->image) . '" title="ImageName">
    <img alt="ImageName" src="' . asset('assets/uploads/reportissue/' . $data->image) . '" width="50px" height="50px"><br>Download
</a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteReport(Request $request)
    {
        try {
            $data = ReportAnIssue::where('id', $request->id)->first();

            if ((file_exists(public_path('assets/uploads/reportissue/' . $data->image))) && ($data->image != NULL)) {
                unlink("assets/uploads/reportissue/" . $data->image);
            }

            $res = ReportAnIssue::where('id', $request->id)->delete();
            return $res;
        } catch (QueryException $e) {
            return $e->getMessage();
        }
    }
    
      public function test(Request $request)
    {
      $user=User::where('id',5923)->pluck('device_token')->first();
     $data =[
            'token' => $user,
            'notification' => [
                 'title' => 'Test notification ',
                'body' => ' Hi manisha , From yellowcloud',
            ],
 "data" => [
                        "route" => "notification"
                    ]
        ];
        sendpushnotification($data);
     $path=storage_path('firebase_credentials.json');
        $firebase = (new Factory)
            ->withServiceAccount($path);
        
        $messaging = $firebase->createMessaging();
 $message = CloudMessage::fromArray($data);
 
        $messaging->send($message);
        die();
         $data = [
                    "to" => $user,
                    "notification" => [
                        'title' => 'Yellowcloud Appointment',
                        'body' => 'Hi, test msg',
                    ],
                    "data" => [
                        "route" => "notification"
                    ]
                ];

               $dataString = json_encode($data);
    // $SERVER_API_KEY = env('FCM_SERVER_KEY');
    
    $headers = [
        'Authorization: key=' . $SERVER_API_KEY,
        'Content-Type: application/json',
    ];

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
    curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
    // Disabling SSL Certificate support temporarly
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
    // Execute post
    $result = curl_exec($ch);
print_r($result);
    // Close connection
    // curl_close($ch);
    // return true;
    }
}
