<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;
use Illuminate\Auth\AuthenticationException;
use Illuminate\Validation\ValidationException;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Symfony\Component\HttpKernel\Exception\HttpException;

class Handler extends ExceptionHandler
{
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function render($request,  $exception)
    {
        if ($request->is('api/*')) {
            // Handle validation errors
            if ($exception instanceof ValidationException) {
                return response()->json([
                    'success' => false,
                    'message' => 'Validation errors',
                    'errors' => $exception->errors(),
                    'statuscode' => 422
                ], 422);
            }

            // Handle authentication errors
            if ($exception instanceof AuthenticationException) {
                return response()->json([
                    'success' => false,
                    'message' => 'Unauthenticated',
                    'statuscode' => 401
                ], 401);
            }

            // Handle not found errors
            if ($exception instanceof NotFoundHttpException) {
                return response()->json([
                    'success' => false,
                    'message' => 'Resource not found',
                    'statuscode' => 404
                ], 404);
            }

            // Handle other HTTP exceptions
            if ($exception instanceof HttpException) {
                return response()->json([
                    'success' => false,
                    'message' => $exception->getMessage(),
                    'statuscode' => $exception->getStatusCode()
                ], $exception->getStatusCode());
            }

            // Handle general exceptions
            return response()->json([
                'success' => false,
                'message' => 'Server Error',
                'error' => $exception->getMessage(),
                'statuscode' => 500
            ], 500);
            return parent::render($request, $exception);
        } else {
            $response = parent::render($request, $exception);
            return response()->view('error', ['error' => $response]);
        }
    }
}
