<?php

namespace App\Console\Commands;

use App\Models\Appointments;
use App\Models\PushNotification;
use Illuminate\Console\Command;

class Appointment extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:appointment';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $start_time = now()->format('h:i a');
        $array = Appointments::select('appointments.*', 'users.device_token', 'users.First_Name', 'users.Last_Name')
            ->rightJoin('users', 'users.id', '=', 'appointments.user_id')
            ->where('Appointment_Status', '!=', 'Cancel')
            ->where('Appointment_Date', date('Y-m-d'))
            ->where('Appointment_Time', $start_time)
            ->get();



        foreach ($array as $item) {
            PushNotification::create([
                'title' => 'Appoinment Remainder',
                'message' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". ",
                'therapist_notification' => "This is a friendly reminder for your appointment with " . $item->First_Name . "  " . $item->Last_Name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". ",
                'type' => 'Appointment',
                'user_id' => $item->user_id,
                'therapist_id' => $item->therapist_id,
                'appoinment_id' => $item->id
            ]);

            $data = [
               'token' => $item->device_token,
                "notification" => [
                    'title' => 'Appoinment Remainder',
                    'body' => "Hello " . $item->First_Name . "  " . $item->Last_Name . " this is a friendly reminder for your appointment with " . $item->therapist->prefix . " " . $item->therapist->full_name . " on " . $item->Appointment_Date . " at " . $item->Appointment_Time . ". "
                ],
                "data" => [
                    "route" => "notification"
                ]
            ];
            sendpushnotification($data);
        }
    }
}
