<!DOCTYPE html>
<html lang="en">

<head>
    <title>Send Web Notification</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.16.0/umd/popper.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <meta name="csrf-token" content="{{csrf_token()}}">
</head>

<body>
    <div class="container">
        <div class="row">
            <div class="col-sm-8">
                <button class="btn btn-success btn-lg align-center" id="allow_not_btn">Allow Notification</button>
                <br>
                <form class="form-sample jquery_form" action="{{route('admin.send.notification')}}" method="post" enctype="multipart/form-data">
                    @csrf

                    <div class="form-group">
                        <label class="form-check-label">Title</label>
                        <input type="text" class="form-control" name="title" placeholder="Enter Title">
                    </div>

                    <div class="form-group">
                        <label class="form-control-label">Message body</label>
                        <textarea rows="4" class="form-control" placeholder="Enter Message" name="message"></textarea>
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-primary mr-2">Submit</button>
                        <button class="btn btn-light" onclick="history.back();">Cancel</button>
                    </div>

                </form>

                <br>
                @if(session()->has('response'))
                <pre>Firebase API Response : 
                            {{session()->get('response')}}
                        </pre>
                @endif
            </div>
        </div>
    </div>

    <script src="https://www.gstatic.com/firebasejs/8.3.0/firebase-app.js"></script>
    <script src="https://www.gstatic.com/firebasejs/8.3.0/firebase-messaging.js"></script>

    <script>
        $(function() {
            const firebaseConfig = {
                apiKey: "AIzaSyB6261UdgcjJ5vt1fCMZKwpaxCC9qvETjA",
                authDomain: "avosys-92a23.firebaseapp.com",
                projectId: "avosys-92a23",
                storageBucket: "avosys-92a23.appspot.com",
                messagingSenderId: "169283548478",
                appId: "1:169283548478:web:047638c46776caa037a86f",
                measurementId: "G-LB5Q3CSG49"
            };

            firebase.initializeApp(firebaseConfig);
            const messaging = firebase.messaging();

            $('#allow_not_btn').on('click', function() {
                messaging
                    .requestPermission()
                    .then(function() {
                        return messaging.getToken()
                    })
                    .then(function(response) {
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: '{{ route("admin.save-token") }}',
                            type: 'POST',
                            data: {
                                token: response
                            },
                            dataType: 'JSON',
                            success: function(response) {
                                alert('Token stored.');
                            },
                            error: function(error) {
                                alert(error);
                            },
                        });

                    }).catch(function(error) {
                        alert(error);
                    });
            });

            messaging.onMessage(function(payload) {
                const title = payload.notification.title;
                const options = {
                    body: payload.notification.body,
                    icon: payload.notification.icon,
                };
                new Notification(title, options);
            });
        });
    </script>
</body>

</html>