  @extends('admin.layout.dashboard-template')
  @section('content')
  <div class="db-info-wrap db-service-wrap">
      <div class="dashboard-box table-opp-color-box">

          @if(\Session::get('success'))
          <div class="alert alert-success alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('success') }}
              </div>
              <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
          </div>
          @endif
          {{ \Session::forget('success') }}
          @if(\Session::get('error'))
          <div class="alert alert-danger alert-dismissible fade show" role="alert">
              <div class="alert-body">
                  {{ \Session::get('error') }}
              </div>
              <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
          </div>
          @endif

          <div class="table-responsive">
              <br><br>
              <h4>Car Details</h4>
              <table class="table">
                  <thead>
                      <tr>
                          <th>Sl.No</th>
                          <th>NAME</th>
                          <th>MOBILE NUMBER</th>
                          <th>CAR BRAND</th>
                          <th>CAR MODEL</th>
                          <th>MANUFACTURING YEAR</th>
                          <th>AGENT</th>
                          <th>DATE</th>
                          <th>Action</th>
                      </tr>
                  </thead>
                  <tbody>

                  </tbody>
              </table>
          </div>
      </div>

  </div>
  <script type="text/javascript">
      $(function() {

          var table = $('.table').DataTable({
              processing: true,
              serverSide: true,
              ajax: "{{ route('admin.get-car-details') }}",
              columns: [{
                      data: 'DT_RowIndex',
                      name: 'DT_RowIndex'
                  },
                  {
                      data: 'customer_name',
                      name: 'customer_name'
                  },
                  {
                      data: 'mobile_number',
                      name: 'mobile_number'
                  },
                  {
                      data: 'company_name',
                      name: 'company_name'
                  },
                  {
                      data: 'approximate_salary',
                      name: 'approximate_salary'
                  },
                  {
                      data: 'location',
                      name: 'location'
                  },

                  {
                      data: 'agent',
                      name: 'agent'
                  },
                  {
                      data: 'date',
                      name: 'date'
                  },
                  {
                      data: 'action',
                      name: 'action',
                      orderable: false,
                      searchable: false
                  },
              ],
              "select": {
                  'style': 'multi',
                  'selector': 'td:first-child' //only checkbox can select row
              },
              dom: 'Bfrtip',
              buttons: [{
                      extend: 'csv',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 6, 7]
                      }
                  },
                  {
                      extend: 'copy',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 6, 7]
                      }
                  },
                  {
                      extend: 'excel',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 6, 7]
                      }
                  },
                  {
                      extend: 'pdf',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 6, 7]
                      }
                  },
                  {
                      extend: 'print',
                      exportOptions: {
                          columns: [0, 1, 2, 3, 4, 5, 6, 7]
                      }
                  },

              ]
          });

      });

      $(document).on('click', '#getDeleteId', function(e) {
          var answer = confirm("Are you sure you want to delete from this item?");
          if (answer) {
              id = $(this).data('id');
              e.preventDefault();
              $.ajaxSetup({
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  }
              });
              $.ajax({
                  url: "{{ route('admin.delete-car-details') }}",
                  method: "GET",
                  data: {
                      'id': id
                  },
                  success: function(result) {
                      $('.table').DataTable().ajax.reload();
                      if (result == 1) {
                          $(".alert-success").text("car-details Deleted successfully.");
                      } else {
                          $(".alert-danger").text("Something went wrong.");
                      }

                      $('.data-table').DataTable().ajax.reload();

                  }
              });
          }
      });

   
  </script>
  @endsection