  @extends('admin.layout.dashboard-template')
  @section('content')

  <div class="db-info-wrap db-add-tour-wrap">
      <div class="row">

          <form action="{{route('admin.update-tutorialLink')}}" method="post" enctype="multipart/form-data" class="col-12">
              @csrf
              <!-- Listings -->
              <div class="col-lg-12 col-xl-12">
                  @if(\Session::get('success'))
                  <div class="alert alert-success alert-dismissible fade show" role="alert">
                      <div class="alert-body">
                          {{ \Session::get('success') }}
                      </div>
                      <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
                  </div>
                  @endif
                  {{ \Session::forget('success') }}
                  @if(\Session::get('error'))
                  <div class="alert alert-danger alert-dismissible fade show" role="alert">
                      <div class="alert-body">
                          {{ \Session::get('error') }}
                      </div>
                      <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
                  </div>
                  @endif
                  <div class="dashboard-box">
                      <h4><span style="color:red">* </span>Edit Tutorial Link</h4>
                      <div class="custom-field-wrap">
                          <div class="row">
                              <div class="col-12">
                                  <div class="form-group">
                                      <label>Title</label>
                                      <input type="hidden" value="{{$data->id}}" name="id">
                                      <input type="text" required name="title" value="{{ $data->title }}" class="form-control">
                                      @if ($errors->has('title'))
                                      <span class="help-block font-red-mint">
                                          <strong>{{ $errors->first('title') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>
                              <div class="col-12">
                                  <div class="form-group">
                                      <label>Link</label>
                                      <input type="text" required name="link" value="{{ $data->link }}" class="form-control">

                                      @if ($errors->has('link'))
                                      <span class="help-block font-red-mint">
                                          <strong>{{ $errors->first('link') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>
                          </div>


                      </div>
                  </div>


                  <div class="col-12 text-center">
                      <button type="submit" id="add" class="btn btn-primary">UPDATE</button>
                  </div>
              </div>
          </form>
      </div>
  </div>


  @endsection