  @extends('admin.layout.dashboard-template')
  @section('content')

  <style>
      .filepond--root {
          width: 500px
      }

      #addlink {
          display: none;
      }
#defaultlink{
    display:none;
}
      .filepond--drop-label {
          color: #4c4e53;
      }

      .filepond--label-action {
          text-decoration-color: #babdc0;
          margin-top: 10px;

      }

      .filepond--panel-root {
          border-radius: 2em;
          background-color: #fff;
          height: 1em;
      }

      .service_records,
      .remove {
          margin-bottom: 15px;
      }

      .service_records input,
      .remove input {
          margin-right: 15px;
      }



      .upload__box {
          padding: 40px;

      }

      .upload__inputfile {
          width: 0.1px;
          height: 0.1px;
          opacity: 0;
          overflow: hidden;
          position: absolute;
          z-index: -1;

      }

      .upload__btn {
          display: inline-block;
          font-weight: 600;
          color: #fff;
          text-align: center;
          min-width: 116px;
          padding: 12px;
          transition: all 0.3s ease;
          cursor: pointer;
          border: 2px solid;
          background-color: #F56960;
          border-radius: 10px;
          text-transform: uppercase;
          line-height: 26px;
          font-size: 14px;
      }

      .upload__btn:hover {

          background-color: unset;
          color: #4045ba;
          transition: all 0.3s ease;

      }

      .upload__btn-box {
          margin-bottom: 10px;
      }


      .upload__img-wrap {
          display: flex;
          flex-wrap: wrap;
          margin: 0 -10px;
      }


      .upload__img-box {
          width: 200px;
          padding: 0 10px;
          margin-bottom: 12px;
      }

      .upload__img-close {
          width: 24px;
          height: 24px;
          border-radius: 50%;
          background-color: rgba(0, 0, 0, 0.5);
          position: absolute;

          top: 10px;
          right: 10px;
          text-align: center;
          line-height: 24px;
          z-index: 1;
          cursor: pointer;
      }

      .upload__img-close:after {
          content: "✖";
          font-size: 14px;
          color: white;
      }

      .img-bg {
          background-repeat: no-repeat;
          background-position: center;
          background-size: cover;
          position: relative;
          padding-bottom: 100%;
      }
  </style>
  <div class="db-info-wrap db-add-tour-wrap">
      <div class="row">

          <form action="{{route('admin.update-service')}}" method="post" enctype="multipart/form-data" class="col-12">
              @csrf
              <!-- Listings -->
              <div class="col-lg-12 col-xl-12">
                  @if(\Session::get('success'))
                  <div class="alert alert-success alert-dismissible fade show" role="alert">
                      <div class="alert-body">
                          {{ \Session::get('success') }}
                      </div>
                      <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
                  </div>
                  @endif
                  {{ \Session::forget('success') }}
                  @if(\Session::get('error'))
                  <div class="alert alert-danger alert-dismissible fade show" role="alert">
                      <div class="alert-body">
                          {{ \Session::get('error') }}
                      </div>
                      <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
                  </div>
                  @endif
                  <div class="dashboard-box">
                      <h4>Service Details</h4>
                      <div class="custom-field-wrap">

                          <div class="row">
                              <div class="col-12">
                                  <div class="form-group">
                                      <label>Title</label>
                                      <input type="text" name="title" value="{{ $data->title }}">
                                      <input type="hidden" name="id" value="{{ $data->id }}">
                                      @if ($errors->has('title'))
                                      <span class="help-block font-red-mint">
                                          <strong>{{ $errors->first('title') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>
                              <div class="col-6">
                                  <div class="form-group">
                                      <label>Product Code</label>
                                      <input type="text" name="code" value="{{ $data->code }}">
                                      @if ($errors->has('code'))
                                      <span class="help-block font-red-mint">
                                          <strong>{{ $errors->first('code') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>
                              <div class="col-6">
                                  <div class="form-group">
                                      <label>Commission Amount</label>
                                      <input type="text" name="commission_amount" value="{{ $data->commission }}">
                                      @if ($errors->has('commission_amount'))
                                      <span class="help-block font-red-mint">
                                          <strong>{{ $errors->first('commission_amount') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>

                          </div>



                          <div class="row">

                              <div class="col-12">
                                  <div class="form-group">
                                      <label>Description</label>
                                      <textarea name="description" class="summernote">{{ $data->description }}</textarea>
                                      @if ($errors->has('description'))
                                      <span class=" help-block font-red-mint">
                                          <strong>{{ $errors->first('description') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>
                          </div>
                          
                                <div class="row">

                              <div class="col-12">
                                  <div class="form-group">
                                      <label>Telecalling script</label>
                                      <textarea name="telecalling_script" class="summernote">{{ $data->telecalling_script}}</textarea>
                                      @if ($errors->has('telecalling_script'))
                                      <span class=" help-block font-red-mint">
                                          <strong>{{ $errors->first('telecalling_script') }}</strong>
                                      </span>
                                      @endif
                                  </div>
                              </div>
                          </div>
                          
                      </div>
                  </div>

                  <div class="dashboard-box">
                      <h4>Tutorial Links</h4>
                      @if(count($data->tutorialLinks)>0)
                      <div class="card">
                          <div class="card-body">
                              @foreach($data->tutorialLinks as $key=>$item)
                              <div class="custom-field-wrap" id="tutorialLInkDiv{{$item->id}}">

                                  <div id="dynamic-field-1" class="form-group dynamic-field">
                                      <label for="field" class="font-weight-bold">Link {{$key+1}}</label>
                                      <input type="text" id="field" class="form-control" name="dbtutoriallink[]" value="{{$item->link}}">
                                      <input type="hidden" name="link_id[]" value="{{$item->id}}">
                                  </div>
                                  <div class="clearfix mt-4">
                                      <a id="remove_tutorial_link" data-id="{{$item->id}}" class="btn btn-danger float-left text-uppercase ml-1" disabled="disabled"><i class="fas fa-minus fa-fw"></i> Remove</a>
                                  </div>

                              </div>
                              @endforeach
                          </div>
                      </div>
                      @endif
                      <br><br>
                      <div class="custom-field-wrap">
                          @if(count($data->tutorialLinks)>0)
                          <h4>Add more Links</h4>
                          @endif
                          <div id="dynamic-field-1" class="form-group dynamic-field">
                              <label for="field" class="font-weight-bold">Link 1</label>
                              <input type="text" id="field" class="form-control" name="tutoriallink[]" />
                          </div>
                          <div class="clearfix mt-4">
                              <button type="button" id="add-button" class="btn btn-secondary float-left text-uppercase shadow-sm"><i class="fas fa-plus fa-fw"></i> Add</button>
                              <button type="button" id="remove-button" class="btn btn-secondary float-left text-uppercase ml-1" disabled="disabled"><i class="fas fa-minus fa-fw"></i> Remove</button>

                          </div>

                      </div>
                  </div>

                  <div class="dashboard-box">
                      <h4>Apply Application through</h4>
                      <div class="custom-field-wrap">
                          <div class="row">
                              <div class="col-4">
                                     
                                  <input type="radio" id="default" onclick="clickDefault(this);" {{ $data->apply_service_through == 'Default' ? 'checked' : ''}} name="application_by" value="Default" />
                                  <label for="contactChoice1">Direct Contact</label>
                              </div>
                                <div class="col-4">
                                  <input type="radio" id="form" name="application_by" {{ $data->apply_service_through == 'Form' ? 'checked' : ''}} onclick="clickForm(this);" value="Form" />
                                  <label for="contactChoice1">Form</label>
                              </div>
                              <div class="col-4">
                                  <input type="radio" id="link" onclick="clickLink(this);" {{ $data->apply_service_through == 'Link' ? 'checked' : ''}} name="application_by" value="Link" />
                                  <label for="contactChoice1">Link</label>
                              </div>
                          
                              @if ($errors->has('application_by'))
                              <span class="help-block font-red-mint">
                                  <strong>{{ $errors->first('application_by') }}</strong>
                              </span>
                              @endif
                          </div>
                          <br><br>
                          <div class="row">
                              <div class="col-12">
                                   @php
                                              $links='';
                                              $link='';
                                              @endphp
                                  @if(count($data->links))
                                  @php
                                  foreach($data->links as $item)
                                  {
                                  $link=$item->link;
                                  $linkid=$item->id;
                                  }
                                  @endphp

                                  <input type="hidden" name="onlinelink_id" value="{{$linkid}}">
                                @endif
                                  <div class="custom-field-wrap" id="addlink">
                                      <div class="">
                                          <div class="service_records">
                                            
                                              <input name="link" type="text" value="{{$link}}" class="forn-control" style="width:80%;" Placeholder="Enter Link">
                                              @if ($errors->has('links'))
                                              <span class="help-block font-red-mint">
                                                  <strong>{{ $errors->first('links') }}</strong>
                                              </span>
                                              @endif


                                              <!-- <a class="extra-fields-service" href="javascript:void(0)">Add Links</a> -->
                                          </div>

                                          <div class="service_records_dynamic"></div>

                                      </div>

                                  </div>
                                    
                                    
                     <div class="custom-field-wrap" id="defaultlink">
                                      <div class="">
                                          <div class="service_records">                     
                                              <input name="default_content" value="{{$data->default_content}}" type="text" value="" class="forn-control" style="width:80%;">                                           
                                          </div>
                                      </div>

                                  </div>
                                  
                              </div>
                          </div>
                      </div>
                  </div>

                  <div class="dashboard-box">
                      <h4>Upload Service Photo</h4>
                      <div class="custom-field-wrap">
                          <div class="dragable-field">
                              <div class="dragable-field-inner">
                                  <figure class="feature-image">
                                      <a href="#">
                                          <img src="{{asset('uploads/services/'.$data->image)}}" height="200" width="200">
                                      </a>
                                  </figure>
                                  <div class="upload-input">
                                      <div class="form-group">
                                          <div class="upload__box">
                                              <div class="upload__btn-box">
                                                  <label class="upload__btn">
                                                      Upload image
                                                      <input type="file" name="image" value="{{$data->image}}" class="upload__inputfile">
                                                  </label>
                                              </div>
                                              <div class="upload__img-wrap"></div>
                                          </div>
                                      </div>
                                  </div>
                              </div>

                          </div>

                      </div>
                  </div>

                  <div class="col-12 text-center">
                      <button type="submit" id="add" class="btn btn-success">Update Service</button>
                  </div>
              </div>
          </form>
      </div>
  </div>
  <script>
      $("#linkbutton").click(function() {
          $("#addlink").toggle('slow');
      });
      jQuery(document).ready(function() {
          ImgUpload();
      });

      function ImgUpload() {
          var imgWrap = "";
          var imgArray = [];

          $('.upload__inputfile').each(function() {
              $(this).on('change', function(e) {
                  imgWrap = $(this).closest('.upload__box').find('.upload__img-wrap');
                  var maxLength = $(this).attr('data-max_length');

                  var files = e.target.files;
                  var filesArr = Array.prototype.slice.call(files);
                  var iterator = 0;
                  filesArr.forEach(function(f, index) {

                      if (!f.type.match('image.*')) {
                          return;
                      }

                      if (imgArray.length > maxLength) {
                          return false
                      } else {
                          var len = 0;
                          for (var i = 0; i < imgArray.length; i++) {
                              if (imgArray[i] !== undefined) {
                                  len++;
                              }
                          }
                          if (len > maxLength) {
                              return false;
                          } else {
                              imgArray.push(f);

                              var reader = new FileReader();
                              reader.onload = function(e) {
                                  var html = "<div class='upload__img-box'><div style='background-image: url(" + e.target.result + ")' data-number='" + $(".upload__img-close").length + "' data-file='" + f.name + "' class='img-bg'><div class='upload__img-close'></div></div></div>";
                                  imgWrap.html(html);
                                  iterator++;
                              }
                              reader.readAsDataURL(f);
                          }
                      }
                  });
              });
          });

          $('body').on('click', ".upload__img-close", function(e) {
              var file = $(this).parent().data("file");
              for (var i = 0; i < imgArray.length; i++) {
                  if (imgArray[i].name === file) {
                      imgArray.splice(i, 1);
                      break;
                  }
              }
              $(this).parent().parent().remove();
          });
      }



      $('.extra-fields-service').click(function() {
          $('.service_records').clone().appendTo('.service_records_dynamic');
          $('.service_records_dynamic .service_records').addClass('single remove');
          $('.single .extra-fields-service').remove();
          $('.single').append('<a href="javascript:void(0)" class="remove-field btn-remove-service">Remove Field</a>');
          $('.service_records_dynamic > .single').attr("class", "remove");

          $('.service_records_dynamic input').each(function() {
              var count = 0;
              var fieldname = $(this).attr("name");
              $(this).attr('name', fieldname + count);
              count++;
          });

      });

      $(document).on('click', '.remove-field', function(e) {
          $(this).parent('.remove').remove();
          e.preventDefault();
      });

      $(document).on('click', '#remove_tutorial_link', function(e) {
          id = $(this).data('id');
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url: "{{ route('admin.delete-tutorial-link') }}",
              method: "GET",
              data: {
                  'id': id
              },
              success: function(result) {
                  $('#tutorialLInkDiv' + id).load(location.href + (' #tutorialLInkDiv' + id));
                  if (result == 1) {
                      $(".alert-success").text("Link deleted successfully.");
                  } else {
                      $(".alert-danger").text("Something went wrong.");
                  }

                  $('.data-table').DataTable().ajax.reload();

              }
          });
      });


      $(document).on('click', '#deletelink', function(e) {
          id = $(this).data('id');
          e.preventDefault();
          $.ajaxSetup({
              headers: {
                  'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
              }
          });
          $.ajax({
              url: "{{ route('admin.delete-service-link') }}",
              method: "GET",
              data: {
                  'id': id
              },
              success: function(result) {
                  $('#dblinks' + id).load(location.href + (' #dblinks' + id));
                  if (result == 1) {
                      $(".alert-success").text("Link deleted successfully.");
                  } else {
                      $(".alert-danger").text("Something went wrong.");
                  }

                  $('.data-table').DataTable().ajax.reload();

              }
          });
      });


      $('.extra-fields-service').click(function() {
          $('.service_records').clone().appendTo('.service_records_dynamic');
          $('.service_records_dynamic .service_records').addClass('single remove');
          $('.single .extra-fields-service').remove();
          $('.single').append('<a href="javascript:void(0)" class="remove-field btn-remove-service">Remove Field</a>');
          $('.service_records_dynamic > .single').attr("class", "remove");

          $('.service_records_dynamic input').each(function() {
              var count = 0;
              var fieldname = $(this).attr("name");
              $(this).attr('name', fieldname + count);
              count++;
          });

      });

      $(document).on('click', '.remove-field', function(e) {
          $(this).parent('.remove').remove();
          e.preventDefault();
      });


      function clickLink(myRadio) {
          $("#addlink").show('slow');
           $("#defaultlink").hide('slow');
      }
   function clickDefault(myRadio) {
          $("#defaultlink").show('slow');
           $("#addlink").hide('slow');
      }

      function clickForm(myRadio) {
          $("#addlink").hide('slow');
          $("#defaultlink").hide('slow');
      }

      $(document).ready(function() {
          
          if ($("#link").prop("checked")) {
              $("#addlink").show('slow');
          }
          if ($("#default").prop("checked")) {
              $("#defaultlink").show('slow');
          }
      });

      //   $(document).ready(function() {
      //       var buttonAdd = $("#add-button");
      //       var buttonRemove = $("#remove-button");
      //       var className = ".dynamic-field";
      //       var count = 0;
      //       var field = "";
      //       var maxFields = 5;

      //       function totalFields() {
      //           return $(className).length;
      //       }

      //       function addNewField() {
      //           count = totalFields() + 1;
      //           field = $("#dynamic-field-1").clone();
      //           field.attr("id", "dynamic-field-" + count);
      //           field.children("label").text("Field " + count);
      //           field.find("input").val("");
      //           $(className + ":last").after($(field));
      //       }

      //       function removeLastField() {
      //           if (totalFields() > 1) {
      //               $(className + ":last").remove();
      //           }
      //       }

      //       function enableButtonRemove() {
      //           if (totalFields() === 2) {
      //               buttonRemove.removeAttr("disabled");
      //               buttonRemove.addClass("shadow-sm");
      //           }
      //       }

      //       function disableButtonRemove() {
      //           if (totalFields() === 1) {
      //               buttonRemove.attr("disabled", "disabled");
      //               buttonRemove.removeClass("shadow-sm");
      //           }
      //       }

      //       function disableButtonAdd() {
      //           if (totalFields() === maxFields) {
      //               buttonAdd.attr("disabled", "disabled");
      //               buttonAdd.removeClass("shadow-sm");
      //           }
      //       }

      //       function enableButtonAdd() {
      //           if (totalFields() === (maxFields - 1)) {
      //               buttonAdd.removeAttr("disabled");
      //               buttonAdd.addClass("shadow-sm");
      //           }
      //       }

      //       buttonAdd.click(function() {
      //           addNewField();
      //           enableButtonRemove();
      //           disableButtonAdd();
      //       });

      //       buttonRemove.click(function() {
      //           removeLastField();
      //           disableButtonRemove();
      //           enableButtonAdd();
      //       });
      //   });
  </script>

  @endsection