  @extends('admin.layout.dashboard-template')
  @section('content')
  <style>
      .dropdown-menu {
          top: 64% !important;
          left: 44% !important;
          width: 21%;

      }
  </style>
  <div class="db-info-wrap db-package-wrap ">
      <div class="dashboard-box col-md-8 offset-md-2">
          <h4>Edit Application</h4>
          <form action=" {{route('admin.update-enquiry')}}" method="post" enctype="multipart/form-data" class="col-12">
              @csrf
              <div class="custom-field-wrap">
                  @if(\Session::get('success'))
                  <div class="alert alert-success alert-dismissible fade show" role="alert">
                      <div class="alert-body">
                          {{ \Session::get('success') }}
                      </div>
                      <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
                  </div>
                  @endif
                  {{ \Session::forget('success') }}
                  @if(\Session::get('error'))
                  <div class="alert alert-danger alert-dismissible fade show" role="alert">
                      <div class="alert-body">
                          {{ \Session::get('error') }}
                      </div>
                      <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close"></button>
                  </div>
                  @endif
                  <div class="row">
                      <div class="col-12">
                          <div class="form-group">
                              <label>Customer Name</label>
                              <input type="text" name="customer_name" value="{{ $data->customer_name }}">
                              <input type="hidden" name="id" value="{{ $data->id }}">
                              @if ($errors->has('customer_name'))
                              <span class="help-block font-red-mint">
                                  <strong>{{ $errors->first('customer_name') }}</strong>
                              </span>
                              @endif
                          </div>
                      </div>
                      <div class="col-12">
                          <div class="form-group">
                              <label>Phone Number</label>
                              <input type="text" name="phone_number" value="{{ $data->phone_number }}">
                              @if ($errors->has('phone_number'))
                              <span class="help-block font-red-mint">
                                  <strong>{{ $errors->first('phone_number') }}</strong>
                              </span>
                              @endif
                          </div>
                      </div>
                      <div class="col-12">
                          <div class="form-group">
                              <label> Service</label>
                              <input type="hidden" name="msg" id="msg">
                              <select name="service_id">
                                  @foreach(App\Models\Service::get() as $item)
                                  <option value="{{$item->id}}" data-value="{{$item->title}}" {{ $item->id == $data->service_id ? 'selected' : '' }}>{{$item->title}}</option>
                                  @endforeach
                              </select>
                              @if ($errors->has('service_id'))
                              <span class="help-block font-red-mint">
                                  <strong>{{ $errors->first('service_id') }}</strong>
                              </span>
                              @endif
                          </div>
                      </div>
                      <div class="col-12">
                          <div class="form-group">
                              <label> Agent</label>
                              <select name="agent">
                                  @foreach(App\Models\User::get() as $item)
                                  <option value="{{$item->id}}" data-value="{{$item->name}}" {{ $item->id == $data->agent_id ? 'selected' : '' }}>{{$item->name}}</option>
                                  @endforeach
                              </select>
                              @if ($errors->has('agent'))
                              <span class="help-block font-red-mint">
                                  <strong>{{ $errors->first('agent') }}</strong>
                              </span>
                              @endif
                          </div>
                      </div>

                      <div class="col-12">
                          <div class="form-group">
                              <label>Transaction Number</label>
                              <input type="text" name="number" value="{{ $data->number }}">
                              @if ($errors->has('number'))
                              <span class="help-block font-red-mint">
                                  <strong>{{ $errors->first('number') }}</strong>
                              </span>
                              @endif
                          </div>
                      </div>

                      @if($data->status=='Completed')
                      <div class="col-12">
                          <div class="form-group">
                              <label>Date</label>
                              <input type="date" name="date" value="{{ $data->service_date }}">
                              @if ($errors->has('date'))
                              <span class="help-block font-red-mint">
                                  <strong>{{ $errors->first('date') }}</strong>
                              </span>
                              @endif
                          </div>
                      </div>
                      <div class="col-12">
                          <div class="form-group">
                              <label>Time</label>
                              <input type="time" name="time" value="{{ date('H:i:s', strtotime($data->service_time))  }}">
                              <!-- @if ($errors->has('time'))
                              <span class="help-block font-red-mint">
                                  <strong>{{ $errors->first('time') }}</strong>
                              </span>
                              @endif -->
                          </div>
                      </div>
                      @endif
                      <div class="col-12 text-center">
                          <button type="submit" id="add" class="btn btn-primary">UPDATE </button>
                      </div>
                  </div>
              </div>
          </form>
      </div>

  </div>
  <script>
    //   $('select[name="service_id"]').change(function() {
    //       alert($(this).children('option:selected').data('value'));
    //   });
      //   $(document).on('click', '#add', function(e) {
      //       status = $('select[name="status"]').val();
      //       service = $('select[name="service_id"]').children('option:selected').data('value');
      //       agent = $('select[name="agent"]').val();
      //       customer = $('input[name="customer_name"]').val();
      //       msg = 'Application for ' + service + ' of ' + customer + ' has been ' + status;
      //       $("#msg").text(msg);

      //         if (status != 'Processing') {
      //             $.ajax({
      //                 url: "{{ route('admin.send-notification') }}",
      //                 method: "POST",
      //                 data: {
      //                     "_token": "{{ csrf_token() }}",
      //                     'agent_id': agent,
      //                     'title': 'Application ' + status,
      //                     'body': msg
      //                 },
      //                 success: function(result) {}
      //             });
      //         }
      //   });
  </script>
  @endsection