  @extends('admin.layout.dashboard-template')
  @section('content')
  <style>
      .box {
          -webkit-box-shadow: 4px 6px 4px 2px rgba(128, 125, 128, 1);
          -moz-box-shadow: 4px 6px 4px 2px rgba(128, 125, 128, 1);
          box-shadow: 4px 6px 4px 2px rgba(128, 125, 128, 1);

          padding: 26px 0px;
          margin-bottom: 60px;
      }
  </style>
  <div class="db-info-wrap db-package-wrap">
      <div class="dashboard-box">
          <h4 class="text-center">Agent Details</h4>
          <div class="custom-field-wrap">
              <div class="col-12">
                  <div class="card box">
                      <div class="row">
                          <div class="col-md-5 offset-md-5 ">
                              <div class="avatar-upload">
                                  <div class=" avatar-preview">
                                      @if($data->image!=NULL)
                                      <div id="imagePreview" style="background-image: url('{{asset('uploads/agent/'.$data->image)}}');">
                                          @else
                                          <div id="imagePreview" style="background-image: url('{{asset('assets/images/default-image.jpg')}}');">
                                              @endif
                                          </div>
                                      </div>
                                  </div>
                              </div>


                          </div>
                          <div class="table-responsive col-md-7 offset-md-3">
                              <h3 class="text-center" style="margin-right:106px;"> {{$data->name }}</h3>
                              <table class="table ">
                                  <tbody>
                                      <tr>
                                          <td><i class="fa fa-id-card-alt"></i> Employee ID</td>
                                          <td>:</td>
                                          <td> <b>{{$data->employeeID }}</b></td>
                                      </tr>

                                      <tr>
                                          <td><i class="fa fa-mobile"></i> Mobile Number</td>
                                          <td>:</td>
                                          <td> {{$data->mobile_number }}</td>
                                      </tr>

                                      <tr>
                                          <td><i class="far fa-envelope"></i> Email</td>
                                          <td>:</td>
                                          <td> {{$data->email }}</td>
                                      </tr>
                                      @if($data->designation)
                                      <tr>
                                          <td><i class="far fa-envelope"></i> Designation</td>
                                          <td>:</td>
                                          <td> {{$data->designation }}</td>
                                      </tr>
                                      @endif
                                      <tr id="total">
                                          <td><i class="fa fa-money-bill"></i> Total Commission</td>
                                          <td>:</td>
                                          <td>Rs.{{$data->total_commission }}</td>
                                      </tr>
 <tr>
                                          <td><i class="fa fa-id-card-alt"></i> Gpay Name</td>
                                          <td>:</td>
                                          <td> <b>{{$data->gpay_number }}</b></td>
                                      </tr>

                                      <tr>
                                          <td><i class="fa fa-mobile"></i> Gpay Number</td>
                                          <td>:</td>
                                          <td> {{$data->gpay_name }}</td>
                                      </tr>
                                  </tbody>
                              </table>
                          </div>
                      </div>
                      <div class="text-center">
                          <h4 class="text-center">Applications By agent {{$data->name }}</h4>

                          <div class="table-responsive">
                              <table class="table booking dataTable no-footer" id="booking" role="grid" aria-describedby="DataTables_Table_0_info" style="width: 953px;">
                                  <thead>
                                      <tr role="row">
                                          <th class="sorting_asc" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-sort="ascending" aria-label="Sl.No: activate to sort column descending" style="width: 77px;">Sl.No</th>
                                          <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="USER: activate to sort column ascending" style="width: 71px;">Customer Name</th>
                                          <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="PACKAGE: activate to sort column ascending" style="width: 205px;">Phone Number</th>
                                          <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="NO:DAYS: activate to sort column ascending" style="width: 103px;">Service</th>
                                          <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="NO:DAYS: activate to sort column ascending" style="width: 103px;">Agent</th>
                                          <th class="sorting" tabindex="0" aria-controls="DataTables_Table_0" rowspan="1" colspan="1" aria-label="Status: activate to sort column ascending" style="width: 127px;">Status</th>
                                          <th class="sorting_disabled" rowspan="1" colspan="1" aria-label="Action" style="width: 94px;">Action</th>
                                      </tr>
                                  </thead>
                                  <tbody>

                                  </tbody>
                              </table>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </div>

  </div>
  <script type="text/javascript">
      $(function() {
          var table = $('.dataTable').DataTable({
              processing: true,
              serverSide: true,
              ajax: ({
                  url: "{{ route('admin.get-agent-enquiry') }}",
                  method: "GET",
                  data: {
                      'id': "<?php echo $data->id; ?>"
                  },
              }),
              columns: [{
                      data: 'DT_RowIndex',
                      name: 'DT_RowIndex'
                  },
                  {
                      data: 'customer_name',
                      name: 'customer_name'
                  },
                  {
                      data: 'phone_number',
                      name: 'phone_number'
                  },
                  {
                      data: 'service',
                      name: 'service'
                  },
                  {
                      data: 'agent',
                      name: 'agent'
                  },
                  {
                      data: 'status',
                      name: 'status'
                  },
                  {
                      data: 'action',
                      name: 'action',
                      orderable: false,
                      searchable: false
                  },
              ],
              "select": {
                  'style': 'multi',
                  'selector': 'td:first-child' //only checkbox can select row
              },
          });

      });

      $(document).on('click', '#getBookingDeleteID', function(e) {
          var answer = confirm("Are you sure you want to delete from this item?");
          if (answer) {
              id = $(this).data('id');
              e.preventDefault();
              $.ajaxSetup({
                  headers: {
                      'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                  }
              });
              $.ajax({
                  url: "{{ route('admin.delete-enquiry') }}",
                  method: "GET",
                  data: {
                      'id': id
                  },
                  success: function(result) {
                      $('.dataTable').DataTable().ajax.reload();
                      if (result == 1) {
                          $(".alert-success").text("Service Deleted successfully.");
                      } else {
                          $(".alert-danger").text("Something went wrong.");
                      }

                  }
              });
          }
      });
  </script>
  @endsection