<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Notifications\Notifiable;

class ServiceBooking extends Model
{
    use HasFactory;
    use Notifiable;
    protected $table = 'service_bookings';
    protected $fillable = [
        'customer_name',
        'phone_number',
        'service_id',
        'agent_id',
        'number',
        'service_time',
        'service_date'
    ];
    protected $enumStatuses = [
        'Processing', 'Approved', 'Completed'
    ];
    public function service()
    {
        return $this->belongsTo('App\Models\Service', 'service_id');
    }
    public function agent()
    {
        return $this->belongsTo('App\Models\Agent', 'id');
    }
    public function note()
    {
        return $this->hasMany('App\Models\Note', 'service_id');
    }
}
