<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ReadNotification extends Model
{
    use HasFactory;
    protected $table = 'read_notifications';
    protected $fillable = [
        'notification_id',
        'agent_id'
    ];
    public function agent()
    {
        return $this->belongsTo('App\Models\Agent', 'id');
    }
    public function notification()
    {
        return $this->belongsTo('App\Models\PushNotification', 'id');
    }
}
