<?php

namespace App\Imports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\ToModel;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Validator;

class AgentImport implements ToModel, WithHeadingRow
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        $pswd = rand(100000, 999999);
        $data = [
            'name' => $row['name'],
            'slug' => SlugService::createSlug(User::class, 'slug', $row['name']),
            'email' => $row['email'],
            'password' => Hash::make($pswd),
            'mobile_number' => $row['mobile_number'],
            'employeeID' => 'BW' . rand(100000, 999999),
            'designation' => $row['designation'],
        ];

        $mail_data = [
            'name' => $row['name'],
            'email' => $row['mobile_number'],
            'password' => $pswd,
        ];
        Mail::to($row['email'])->send(new \App\Mail\AgentRegisterMail($mail_data));
        return new User($data);
    }
}
