<?php

namespace App\Http\Controllers\frontendAPI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Leads;
use App\Models\AddTutorialLinks;
use App\Models\FAQ;
use Illuminate\Support\Facades\Cache;

class LeadsController extends Controller
{
    public function tutorialLink(Request $request)
    {
        $data =   AddTutorialLinks::get();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    public function faq(Request $request)
    {
        $data =   FAQ::get();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }

    // public function leads(Request $request)
    // {


    //  // $data =    Leads::where('agent_id', NULL) ->orWhere('agent_id', '=', auth()->user()->id)->where('status', 'Pending')->first();
    //     $id=auth()->user()->id;
    //      $data =    Leads::whereNotIn('status', ['NOT INTERESTED','INTERESTED','CRITERIA NOT MET','SALE CLOSED'])
    //     ->whereNull('agent_id')
    //       //  ->orWhere('agent_id', $id)
    //     //  ->whereIn('status', ['Pending','RING NOT RESPOND','SWITCH OFF','CALL BACK','OUT OF COVERAGE AREA','BUSY'])
    //     //   ->where(function ($query) use ($id) {
    //     //                 $query->where('agent_id', NULL)
    //     //                     ->orWhere('agent_id', '=',$id);
    //     //             })
    //               ->first();
    //                 // ->get();
    //                 // print_r($data);die();

    //                 if($data==null){
    //                       $data =    Leads::whereNotIn('status', ['NOT INTERESTED','INTERESTED','CRITERIA NOT MET','SALE CLOSED'])
    //                               ->where('agent_id', $id)
    //                              ->first();
    //                 }
    //     if (!empty($data)) {
    //         return response()->json(
    //             array(
    //                 'status' => True,
    //                 'data' => $data
    //             ),
    //             200
    //         );
    //     } else {
    //         return response()->json(
    //             array(
    //                 'status' => False,
    //                 'data' => $data
    //             ),
    //             200
    //         );
    //     }
    // }



    public function leads(Request $request)
    {
        $agentId = auth()->user()->id;
        //Cache::forget("agent_lead_{$agentId}");
        $cacheKey = "agent_lead_{$agentId}";
        $cacheTTL = 3600; // 1 hour

        // 1. Try to get existing cached lead for this agent
        $agentLeadData = Cache::get($cacheKey);

        if ($agentLeadData) {
            $leadId = $agentLeadData['lead_id'];

            // Load latest from DB
            $lead = Leads::find($leadId);

            if ($lead) {
                if ($lead->status !== $agentLeadData['lead_status'] || $agentLeadData['status-change-flag'] == 1) {
                    // Status changed → pick new random
                    $lead = Leads::whereNull('agent_id')
                        ->inRandomOrder()
                        ->first();

                    //   if ($lead==null) {
                    //         $lead = Leads::where('agent_id', $agentId)
                    //                      ->inRandomOrder()
                    //                      ->first();
                    //     }

                    if ($lead) {
                        // if ($lead->agent_id === null) {
                        //     $lead->agent_id = $agentId;
                        //     $lead->save();
                        // }

                        // Store in cache
                        Cache::put($cacheKey, [
                            'lead_id'     => $lead->id,
                            'agent_id'    => $agentId,
                            'lead_status' => $lead->status,
                            'status-change-flag' => 0,
                        ], $cacheTTL);
                    }
                }
            } else {
                // Lead in cache not found in DB → pick new
                $lead = Leads::whereNull('agent_id')
                    ->inRandomOrder()
                    ->first();

                //  if ($lead==null) {
                //     $lead = Leads::where('agent_id', $agentId)
                //                  ->inRandomOrder()
                //                  ->first();
                // }

                if ($lead) {
                    // if ($lead->agent_id === null) {
                    //     $lead->agent_id = $agentId;
                    //     $lead->save();
                    // }

                    Cache::put($cacheKey, [
                        'lead_id'     => $lead->id,
                        'agent_id'    => $agentId,
                        'lead_status' => $lead->status,
                        'status-change-flag' => 0,
                    ], $cacheTTL);
                }
            }
        } else {
            // No cache → first time → pick new
            $lead = Leads::whereNull('agent_id')
                ->inRandomOrder()
                ->first();

            // if ($lead==null) {
            //     $lead = Leads::where('agent_id', $agentId)
            //                  ->inRandomOrder()
            //                  ->first();
            // }

            if ($lead) {
                // if ($lead->agent_id === null) {
                //     $lead->agent_id = $agentId;
                //     $lead->save();
                // }

                Cache::put($cacheKey, [
                    'lead_id'     => $lead->id,
                    'agent_id'    => $agentId,
                    'lead_status' => $lead->status,
                    'status-change-flag' => 0,
                ], $cacheTTL);
            }
        }

        if (!empty($lead)) {
            return response()->json([
                'status' => true,
                'data'   => $lead
            ]);
        } else {
            return response()->json([
                'status' => false,
                'data'   => null
            ]);
        }
    }


    public function myLeads(Request $request)
    {
        $data =    Leads::where('agent_id', auth()->user()->id)->get();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function assignLeads(Request $request)
    {
        $data =    Leads::where('id', $request->id)->first();
        if (($data->agent_id == NULL) || ($data->agent_id == auth()->user()->id)) {
            $res = Leads::where('id', $request->id)
                ->update(['agent_id' => auth()->user()->id]);
            // ->update(['agent_id' => $request->agent_id]);
            if ($res) {
                return response()->json(
                    array(
                        'status' => True,
                        'message' => "Assigned successfully."
                    ),
                    200
                );
            } else {
                return response()->json(
                    array(
                        'status' => False,
                        'message' => "Something went wrong."
                    ),
                    200
                );
            }
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'message' => "This Lead already assigned To another one. Continue with next lead."
                ),
                200
            );
        }
    }

    public function changeLeadStatus(Request $request)
    {
        $agentId = auth()->user()->id;

        $cacheKey = "agent_lead_{$agentId}";
        $cacheTTL = 3600; // 1 hour

        // 1. Try to get existing cached lead for this agent
        $agentLeadData = Cache::get($cacheKey);
        Cache::put($cacheKey, [
            'lead_id'     => $agentLeadData['lead_id'],
            'agent_id'    => $agentId,
            'lead_status' => $agentLeadData['lead_status'],
            'status-change-flag' => 1,
        ], $cacheTTL);

        $res = Leads::where('id', $request->id)
            ->update([
                'status' => $request->status,
                'product_selected' => $request->product_selected,
                'cibil_issue' => $request->cibil_issue,
                'salaried_or_selfemployed' => $request->salaried_or_selfemployed,
                'monthly_income' => $request->monthly_income,
                'district' => $request->district,
            ]);
        if ($res) {
            return response()->json(
                array(
                    'status' => True,
                    'message' => 'Update Status'
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'message' => 'Something went wrong'
                ),
                200
            );
        }
    }
}
