<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Banner;
use App\Models\Post;
use App\Models\User;
use App\Models\Offer;
use Intervention\Image\Facades\Image;
use App\Models\Service;
use Illuminate\Database\QueryException;
use \Yajra\Datatables\Datatables;
use Illuminate\Support\Str;
use Spatie\Browsershot\Browsershot;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\ImageManagerStatic as ImageManager;

class BannerController extends Controller
{
    public function saveBanner(Request $request)
    {

        $request->validate([
            'service' => 'required',
            'image' => 'required|mimes:jpg,jpeg,png,gif,svg,webp|max:2048'
        ]);

        try {

            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $image = $request->image;
                $rand = rand(100, 999);
                $input['file'] = time() . $rand . '.' . $image->getClientOriginalExtension();

                $destinationPath = public_path('uploads/banner');

                $imgFile = Image::make($image->getRealPath());
                $img = Image::make($image)
                    // ->resize(870, 400)
                    ->save($destinationPath . '/' . $input['file']);
                $img->save();
            }
            // ******** Image uploade end ********
            $banner = new Banner;
            $banner->service_id = $request->service;
            $banner->image = $input['file'];
            $res =  $banner->save();
            if ($res == 1) {

                return redirect()->route('admin.banner')->with('success', "banner Added Successfully");
            } else {
                return back()->with('error', "Something Wrong");
            }
        } catch (QueryException $e) {

            return back()->with('error', $e->getMessage());
        }
    }

    public function getBanner(Request $request)
    {
        if ($request->ajax()) {
            $data = Banner::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = ' 
                    <a href="' . route('admin.edit-banner', ['id' => $data->id]) . '" class="text-muted" title="send quotation"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                    <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('service', function ($data) {
                    $res = Service::where('id', $data->service_id)->first();
                    return  '<a href="' . route('admin.view-service', ['slug' => $res->slug]) . '"><span class="package-name">' . $res->title . '</span></a>';
                })
                ->addColumn('banner', function ($data) {
                    return  '<img src="' . asset('uploads/banner/' . $data->image) . '" width="100" height="100">';
                })
                ->addColumn('status', function ($data) {
                    if ($data->status == 1) {
                        $status = 'Active';
                        $class = "success";
                        $val = 0;
                    } else {
                        $status = 'Inactive';
                        $class = "danger";
                        $val = 1;
                    }
                    return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $status . '</span></a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }
    public function deleteBanner(Request $request)
    {

        $data = Banner::whereRaw('id = ?', $request->id)->first();

        if ((file_exists(public_path('uploads/banner/' . $data->image))) && ($data->image != NULL)) {
            unlink("uploads/banner/" . $data->image);
        }

        $res = Banner::where('id', $request->id)->delete();
        return $res;
    }
    public function changeBannerStatus(Request $request)
    {

        $res = Banner::where('id', $request->id)
            ->update(['status' => $request->status]);

        return $res;
    }
    public function editBanner(Request $request)
    {
        $data = Banner::where('id', $request->id)->first();
        return view('admin.banner.edit', ['data' => $data]);
    }
    public function updateBanner(Request $request)
    {
        $request->validate([
            'service' => 'required'
        ]);
        $data = [
            'service_id' => $request->service
        ];
        if ($request->hasFile('image')) {
            $delimg = Banner::whereRaw('id = ?', $request->id)->first();

            // if ($delimg) {
            if ((file_exists(public_path('uploads/banner/' . $delimg->image))) && ($delimg->image != NULL)) {
                unlink("uploads/banner/" . $delimg->image);
            }
            $image = $request->image;
            $input['file'] = time() . '.' . $image->getClientOriginalExtension();

            $destinationPath = public_path('uploads/banner');

            $imgFile = Image::make($image->getRealPath());
            $img = Image::make($request->image)
                // ->resize(570, 330)
                ->save($destinationPath . '/' . $input['file']);
            $img->save();
            $data = array_merge($data, ['image' => $input['file']]);
        }

        $res = Banner::where('id', $request->id)
            ->update($data);
        if ($res == 1) {

            return redirect()->route('admin.banner')->with('success', "banner Updated Successfully");
        } else {
            return back()->with('error', "Something Wrong");
        }
    }


    //************************************************ POST SECTION *******************/
    public function savepost(Request $request)
    {
        try {

            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $image = $request->image;
                $rand = rand(100, 999);
                $input['file'] = time() . $rand . '.' . $image->getClientOriginalExtension();

                $destinationPath = public_path('uploads/post');
                $destinationPath2 = public_path('uploads/');
                $imgFile = Image::make($image->getRealPath());
                $img = Image::make($image)
                    // ->resize(870, 400)
                    ->save($destinationPath . '/' . $input['file']);
                $img->save();
            }
            // ******** Image uploade end ********
            $post = new post;
            $post->service_id = $request->service;
            $post->image = $input['file'];
            $res =  $post->save();
            if ($res == 1) {

                return redirect()->route('admin.post')->with('success', "Post Added Successfully");
            } else {
                return back()->with('error', "Something Wrong");
            }
        } catch (QueryException $e) {

            return back()->with('error', $e->getMessage());
        }
    }
    public function updatePost(Request $request)
    {
        $request->validate([
            'service' => 'required'
        ]);
        $data = [
            'service_id' => $request->service
        ];
        if ($request->hasFile('image')) {
            $delimg = Post::whereRaw('id = ?', $request->id)->first();

            // if ($delimg) {
            if ((file_exists(public_path('uploads/post/' . $delimg->image))) && ($delimg->image != NULL)) {
                unlink("uploads/post/" . $delimg->image);
            }
            $image = $request->image;
            $input['file'] = time() . '.' . $image->getClientOriginalExtension();

            $destinationPath = public_path('uploads/post');

            $imgFile = Image::make($image->getRealPath());
            $img = Image::make($request->image)
                // ->resize(570, 330)
                ->save($destinationPath . '/' . $input['file']);
            $img->save();
            $data = array_merge($data, ['image' => $input['file']]);
        }

        $res = Post::where('id', $request->id)
            ->update($data);
        if ($res == 1) {

            return redirect()->route('admin.post')->with('success', "Post Updated Successfully");
        } else {
            return back()->with('error', "Something Wrong");
        }
    }
    public function editPost(Request $request)
    {
        $data = Post::where('id', $request->id)->first();
        return view('admin.post.edit', ['data' => $data]);
    }
    public function getpost(Request $request)
    {
        if ($request->ajax()) {
            $data = Post::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = ' 
                     <a href="' . route('admin.edit-post', ['id' => $data->id]) . '" class="text-muted" title="send quotation"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                    <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })

                ->addColumn('post', function ($data) {
                    return  '<img src="' . asset('uploads/post/' . $data->image) . '" width="100" height="100">';
                })
                ->addColumn('service', function ($data) {
                    if ($data->service_id == null) {
                        return NULL;
                    } else {
                        $res = Service::where('id', $data->service_id)->first();
                        return  '<a href="' . route('admin.view-service', ['slug' => $res->slug]) . '"><span class="package-name">' . $res->title . '</span></a>';
                    }
                })
                ->escapeColumns([])

                ->make(true);
        }
    }
    public function deletepost(Request $request)
    {

        $data = Post::whereRaw('id = ?', $request->id)->first();

        if ((file_exists(public_path('uploads/post/' . $data->image))) && ($data->image != NULL)) {
            unlink("uploads/post/" . $data->image);
        }

        $res = Post::where('id', $request->id)->delete();
        return $res;
    }
    public function sharePost(Request $request)
    {
        $res = User::first();
        $post = Post::where('id', $request->id)->first();
        $data = [
            'name' => $res->name,
            'mobile_number' => $res->mobile_number,
            'image' => asset('uploads/post/') . '/' . $post['image']
        ];
        return view('post-screenshot', compact('data'));
    }
    //************************************************ END POST SECTION *******************/
    
    
    
    // ***** offer section **************
    
     public function saveoffer(Request $request)
 {

 $request->validate([
 'image' => 'required|mimes:jpg,jpeg,png,gif,svg,webp|max:2048',
 'expiry_date'=>'required'
 ]);

 try {

 // ******** Image uploade start ********
 if ($request->hasFile('image')) {
 $image = $request->image;
 $rand = rand(100, 999);
 $input['file'] = time() . $rand . '.' . $image->getClientOriginalExtension();

 $destinationPath = public_path('uploads/offer');

 $imgFile = Image::make($image->getRealPath());
 $img = Image::make($image)
 // ->resize(870, 400)
 ->save($destinationPath . '/' . $input['file']);
 $img->save();
 }
 // ******** Image uploade end ********
 $offer = new offer;
 $offer->image = $input['file'];
 $offer->expiry_date=date("y-m-d",strtotime($request->expiry_date));
 $res = $offer->save();
 if ($res == 1) {

 return redirect()->route('admin.offer')->with('success', "offer Added Successfully");
 } else {
 return back()->with('error', "Something Wrong");
 }
 } catch (QueryException $e) {

 return back()->with('error', $e->getMessage());
 }
 }

 public function getoffer(Request $request)
 {
 if ($request->ajax()) {
 $data = Offer::orderBy('id', 'DESC')->get();
 return Datatables::of($data)
 ->addIndexColumn()
 ->addColumn('action', function ($data) {
 $actionBtn = '
 <a href="javascript:void(0);" data-id="' . $data->id . '" id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
 return $actionBtn;
 })
 ->addColumn('offer', function ($data) {
 return '<img src="' . asset('uploads/offer/' . $data->image) . '" width="100" height="100">';
 })
  ->addColumn('expiry_date', function ($data) {
 return $data->expiry_date;
 })
 ->addColumn('status', function ($data) {
 if ($data->status == 1) {
 $status = 'Active';
 $class = "success";
 $val = 0;
 } else {
 $status = 'Inactive';
 $class = "danger";
 $val = 1;
 }
 return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $status . '</span></a>';
 })
 ->escapeColumns([])

 ->make(true);
 }
 }
 public function deleteoffer(Request $request)
 {

 $data = Offer::whereRaw('id = ?', $request->id)->first();

 if ((file_exists(public_path('uploads/offer/' . $data->image))) && ($data->image != NULL)) {
 unlink("uploads/offer/" . $data->image);
 }

 $res = Offer::where('id', $request->id)->delete();
 return $res;
 }
 public function changeofferStatus(Request $request)
 {

 $res = Offer::where('id', $request->id)
 ->update(['status' => $request->status]);

 return $res;
 }
}
