<?php

namespace App\Http\Controllers\frontendAPI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Service;
use App\Models\Admin;
use App\Models\Post;
use App\Models\Offer;
use App\Models\Banner;
use App\Models\ServiceBooking;
use App\Notifications\ServiceFormNotification;

class ServiceController extends Controller
{
    public function allServices(Request $request)
    {
        $data = Service::select('id', 'title')->get();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function serviceDetails(Request $request)
    {
        $data = Service::where('id', $request->id)->with('links')->with('tutorialLinks')->first();
        $post=Post::select('id','image')->where('service_id',$data->id)->get();
          $data->posts= collect($post->toArray())->map(function ($item) {
            $item['image'] = asset('uploads/post/') . '/' . $item['image'];
            return $item;
        });
        $data->image = asset('uploads/services/') . '/' . $data->image;
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function serviceList(Request $request)
    {
        $array = Service::select('id', 'title', 'code', 'commission', 'image')->where('status', '1')->where('title', 'like', '%' . $request->term . '%')->orderBy('id', 'Desc')->get();
        $data = collect($array->toArray())->map(function ($item) {
            $item['image'] = asset('uploads/services/') . '/' . $item['image'];
            return $item;
        });

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function banner(Request $request)
    {
        $array = Banner::where('status', '1')->orderBy('id', 'Desc')->with('service')->get();
        $data = collect($array->toArray())->map(function ($item) {
            $item['image'] = asset('uploads/banner/') . '/' . $item['image'];
            return $item;
        });

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
     public function offer(Request $request)
    {
        $array = Offer::select('id','image')
        ->where('expiry_date', '>=',date("y-m-d",strtotime(now())) )
        ->where('status', '1')
        ->orderBy('id', 'Desc')->get();
        $data = collect($array->toArray())->map(function ($item) {
            $item['image'] = asset('uploads/offer/') . '/' . $item['image'];
            return $item;
        });

        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function serviceBooking(Request $request)
    {
        $request->validate([
            'customer_name' => 'required',
            'phone_number' => 'required',
            'service_id' => 'required',
            // 'number' => 'required',
            // 'time' => 'required',
            // 'date' => 'required'

        ]);

        $booking = ServiceBooking::create([
            'service_id' => $request->service_id,
            'agent_id' => auth()->user()->id,
            'customer_name' => $request->customer_name,
            'phone_number' => $request->phone_number,
            'number' => $request->number,
            'service_time' => date('h:i A', strtotime($request->time)),
            'service_date' => date("y-m-d", strtotime($request->date)),

        ]);
        $data = [
            'application_id' => $booking->id,
            'agent_id' => auth()->user()->id
        ];
        $notification = Admin::first();

        #store notification info into notifications table
        $notification->notify(new ServiceFormNotification($data));

        if ($booking) {
            return response(["status" => True, "message" => "Application send Successfully"]);
        } else {
            return response(["status" => False, 'message' => 'Invalid']);
        }
    }
}
