<?php

namespace App\Http\Controllers\frontendAPI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\user;
use App\Models\Banner;
use App\Models\Service;
use Validator;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Cviebrock\EloquentSluggable\Services\SlugService;

class LoginController extends Controller
{
    private $apiToken;
    public function __construct()
    {
        $this->apiToken = uniqid(base64_encode(Str::random(40)));
    }
    public function login(Request $request)
    {

        if (Auth::attempt(['mobile_number' => $request->mobile_number, 'password' => $request->password])) {
            $user = Auth::user();
            if ($user->image != NULL) {
                $img = 'uploads/agent/' . $user->image;
            } else {
                $img = 'assets/images/default-image.jpg';
            }
            $data = [
                'name' => $user->name,
                'mobile_number' => $user->mobile_number,
                'email' => $user->email,
                'image' => asset($img),
                'total_commission' => $user->total_commission
            ];
            $accessToken = $user->createToken('auth_token')->plainTextToken;

            return response(["status" => true, "message" => "User Logged In successfully", "data" => $data, 'access_token' => $accessToken]);
        } else {
            return response()->json([
                'status' => 'False',
                'message' => 'Unauthorized Access'
            ]);
        }
    }
    public function logout(Request $request)
    {
        User::where('id', auth()->user()->id)
            ->update([
                'device_token' => NULL
            ]);
        auth()->user()->tokens()->delete();
        return response()->json(
            array(
                'status' => True,
                'message' => "Logout Successfully"
            ),
            200
        );
    }
    public function home(Request $request)
    {
        $user = User::where('id', auth()->user()->id)->first();
        $banner = Banner::where('status', '=', '1')->with('service')->get();
        $service = Service::where('status', '=', '1')->get();
        return response()->json(
            array(
                'status' => True,
                'user_data' => $user,
                'banner' => $banner,
                'service' => $service
            ),
            200
        );
    }
}
