<?php

namespace App\Http\Controllers\frontendAPI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Leads;
use App\Models\AddTutorialLinks;
use App\Models\FAQ;
class LeadsController extends Controller
{
        public function tutorialLink(Request $request)
    {
        $data =   AddTutorialLinks::get();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    
       public function faq(Request $request)
    {
        $data =   FAQ::get();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    
    public function leads(Request $request)
    {
     
     
     // $data =    Leads::where('agent_id', NULL) ->orWhere('agent_id', '=', auth()->user()->id)->where('status', 'Pending')->first();
        $id=auth()->user()->id;
         $data =    Leads::where('status', 'Pending')
          ->where(function ($query) use ($id) {
                        $query->where('agent_id', NULL)
                            ->orWhere('agent_id', '=',$id);
                    })
                    ->first();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
 public function myLeads(Request $request)
    {
        $data =    Leads::where('agent_id', auth()->user()->id)->get();
        if (!empty($data)) {
            return response()->json(
                array(
                    'status' => True,
                    'data' => $data
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'data' => $data
                ),
                200
            );
        }
    }
    public function assignLeads(Request $request)
    {
       $data =    Leads::where('id', $request->id)->first();
       if(($data->agent_id==NULL)||($data->agent_id==auth()->user()->id)){
        $res = Leads::where('id', $request->id)
         ->update(['agent_id' => auth()->user()->id]);
            // ->update(['agent_id' => $request->agent_id]);
        if ($res) {
            return response()->json(
                array(
                    'status' => True,
                     'message'=>"Assigned successfully."
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                     'message'=>"Something went wrong."
                ),
                200
            );
        }
       }else{
              return response()->json(
                array(
                    'status' => False,
                    'message'=>"This Lead already assigned To another one. Continue with next lead."
                ),
                200
            );
           
       }
    }

    public function changeLeadStatus(Request $request)
    {
        
        $res = Leads::where('id', $request->id)
            ->update(['status' => $request->status]);
        if ($res) {
            return response()->json(
                array(
                    'status' => True,
                    'message' => 'Update Status'
                ),
                200
            );
        } else {
            return response()->json(
                array(
                    'status' => False,
                    'message' => 'Something went wrong'
                ),
                200
            );
        }
    }
}
