<?php

namespace App\Http\Controllers\frontendAPI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\User;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class ForgotPasswordController extends Controller
{
    public function sendPasswordToMail(Request $request)
    {
        $request->validate([
            //    'email' => 'required|email|exists:User'
            'email' => 'required',
        ]);
        $user = User::where('email', $request->email)->first();
        if (empty($user)) {
            return response()->json(array("status" => False, "message" => "A mail does not exist like this"));
        } else {
            $token = Str::random(64);
            $rand_pswd = Str::random(4) . rand(1000, 9999);
            $pswd = bcrypt($rand_pswd);
            $res = User::where('id', $user->id)
                ->update([
                    'password' => $pswd
                ]);
            $data = [
                'name' => $user->name,
               'email' => $user->mobile_number,
                'password' => $rand_pswd,
            ];
            if ($res == 1) {
                Mail::to($request->email)->send(new \App\Mail\AgentForgotPasswordMail($data));
                return response()->json(array("status" => True, "message" => "Your new password send to mail"));
            } else {
                return response()->json(array("status" => False, "message" => "Something went wrong"));
            }
        }
    }

    public function resetPassword(Request $request)
    {
        $request->validate([
            'password' => 'required|string|min:6|confirmed',
            'password_confirmation' => 'required'
        ]);

        $res =   User::where('id', auth()->user()->id)
            ->update([
                'password' => bcrypt($request->password)
            ]);
        if ($res == 1) {
            return response()->json(array("status" => True, "message" => "Password reset successfully"));
        } else {
            return response()->json(array("status" => False, "message" => "Something went wrong"));
        }
    }
}
