<?php

namespace App\Http\Controllers\frontendAPI;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\DataGeneration;
use App\Models\CarDetails;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Validator;

class DataGenerationController extends Controller
{
    public function add(Request $request)
    {
        try {
            $request->validate([
                'full_name' => 'required',
                'mobile_number' => 'required',
                'company_name' => 'required',
                'approximate_salary' => 'required',
                'location' => 'required'
            ]);

            $unique_mobile_number = DataGeneration::where('mobile_number', $request->mobile_number)->get();
            if (count($unique_mobile_number) > 0) {
                return response(["status" => False, 'message' => 'Phone Number Already Exist']);
            }
            $res = DataGeneration::insert([
                'full_name' => $request->full_name,
                'slug' => SlugService::createSlug(DataGeneration::class, 'slug', $request->full_name),
                'mobile_number' => $request->mobile_number,
                'company_name' => $request->company_name,
                'approximate_salary' => $request->approximate_salary,
                'Location' => $request->location,
                'agent_id' => auth()->user()->id

            ]);


            if ($res) {
                return response(["status" => True, "message" => "Data submitted Successfully"]);
            } else {
                return response(["status" => False, 'message' => 'Something went wrong']);
            }
        } catch (\Exception $e) {
            return back()->with('error', $e->getMessage());
        }
    }
    
     public function addcardetails(Request $request)
    {
      
        try {
            $request->validate([
                'full_name' => 'required',
                'mobile_number' => 'required',
                'car_brand' => 'required',
                'car_model' => 'required',
                'manufacturing_year' => 'required'
            ]);

            $unique_mobile_number = CarDetails::where('mobile_number', $request->mobile_number)->get();
            if (count($unique_mobile_number) > 0) {
                return response(["status" => False, 'message' => 'Phone Number Already Exist']);
            }
              
            $res = CarDetails::insert([
                'full_name' => $request->full_name,
                'slug' => SlugService::createSlug(DataGeneration::class, 'slug', $request->full_name),
                'mobile_number' => $request->mobile_number,
                'car_brand' => $request->car_brand,
                'car_model' => $request->car_model,
                'manufacturing_year' => $request->manufacturing_year,
                'agent_id' => auth()->user()->id

            ]);


            if ($res) {
                return response(["status" => True, "message" => "Data submitted Successfully"]);
            } else {
                return response(["status" => False, 'message' => 'Something went wrong']);
            }
        } catch (\Exception $e) {
            return back()->with('error', $e->getMessage());
        }
    }
}
