<?php

namespace App\Http\Controllers\backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Service;
use App\Models\User;
use App\Models\Note;
use App\Models\UsefulLinks;
use App\Models\TutorialLinks;
use App\Models\ServiceBooking;
use Intervention\Image\Facades\Image;
use Cviebrock\EloquentSluggable\Services\SlugService;
use Illuminate\Database\QueryException;
use \Yajra\Datatables\Datatables;
use Illuminate\Support\Str;
use App\Http\Controllers\WebNotification;

class ServiceController extends Controller
{
    public function index()
    {
        return view('admin.services.list');
    }
    public function saveService(Request $request)
    {
        $request->validate([
            'title' => 'required',
            'commission_amount' => 'required',
            'description' => 'required',
            'application_by' => 'required',
            'image' => 'required|mimes:jpg,jpeg,png,gif,svg,webp|max:2048'
        ]);

        try {

            // ******** Image uploade start ********
            if ($request->hasFile('image')) {
                $image = $request->image;
                $rand = rand(100, 999);
                $input['file'] = time() . $rand . '.' . $image->getClientOriginalExtension();

                $destinationPath = public_path('uploads/services');

                $imgFile = Image::make($image->getRealPath());
                $img = Image::make($image)
                    ->save($destinationPath . '/' . $input['file']);
                $img->save();
            }
            // ******** Image uploade end ********
            $slug = SlugService::createSlug(Service::class, 'slug', $request->title);
            $services = new Service;
            $services->title = $request->title;
            $services->slug = $slug;
            $services->code = '000' . strtoupper(Str::random(2)) . rand(00, 99);
            $services->Description = $request->description;
            $services->Commission = $request->commission_amount;
            $services->image = $input['file'];
            $services->apply_service_through = $request->application_by;
            $services->telecalling_script= $request->telecalling_script;
            $services->default_content=$request->default_content;
            $res =  $services->save();

            if ($res == 1) {
                if($request->links){
                try {
                    $plan = new UsefulLinks();
                    $plan->service_id = $services->id;
                    $plan->link = $request->links;
                    $plan->save();
                } catch (QueryException $e) {
                    return back()->with(['error' => $e->getMessage(), 'data' => $plan]);
                }
}
                $flag = 0;
                if ($request->tutoriallink[0] == '') {
                    $flag = 1;
                    $res = 1;
                }

                if ($flag == 0) {
                    // if ($request->tutoriallink) {
                    $linkdata = $request->tutoriallink;
                    for ($i = 0; $i < count($request->tutoriallink); $i++) {
                        $plan = new TutorialLinks();
                        $plan->service_id = $services->id;
                        $plan->link = $linkdata[$i];
                        $plan->save();
                    }
                }
                return redirect()->route('admin.view-service', ['slug' => $slug])->with('success', "Service Added Successfully");
            } else {
                return back()->with('error', "Something Wrong");
            }
        } catch (QueryException $e) {

            return back()->with('error', $e->getMessage());
        }
    }


    public function getService(Request $request)
    {
        if ($request->ajax()) {
            $data =    Service::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = ' <a href="' . route('admin.view-service', ['slug' => $data->slug]) . '"   id="getWorkData" class="text-muted"> <span class="badge badge-success"><i class="far fa-eye"></i></span></a>
                                            <a href="' . route('admin.edit-service', ['slug' => $data->slug]) . '"  class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                                            <a  href="javascript:void(0);" data-id="' . $data->id . '"  id="getDeleteId" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('title', function ($data) {
                    return  '<span class="service-name">' . $data->title . '</span>';
                })
                ->addColumn('code', function ($data) {
                    return $data->code;
                })
                ->addColumn('amount', function ($data) {
                    return 'Rs.' . $data->commission;
                })
                ->addColumn('image', function ($data) {
                    return '<img src="' . asset('uploads/services/' . $data->image) . '" width="100" height="100">';
                })
                ->addColumn('status', function ($data) {
                    $status = '';
                    $class = '';
                    if ($data->status == 1) {
                        $status = 'Active';
                        $class = "success";
                        $val = 0;
                    } else {
                        $status = 'Inactive';
                        $class = "danger";
                        $val = 1;
                    }
                    return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="status"><span class="badge badge-' . $class . '">' . $status . '</span></a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function deleteServiceImage(Request $request)
    {
        $data = Service::whereRaw('id = ?', $request->id)->first();
        if ((file_exists(public_path('uploads/Services/' . $data->image))) && ($data->image != NULL)) {
            unlink("uploads/Services/" . $data->image);
        }
        $res = Service::where('id', $request->id)->delete();
        return $res;
    }
    public function deleteServiceLink(Request $request)
    {
        $res = UsefulLinks::where('id', $request->id)->delete();
        return $res;
    }
    public function deleteTutorialLink(Request $request)
    {
        $res = TutorialLinks::where('id', $request->id)->delete();
        return $res;
    }
    public function deleteService(Request $request)
    {

        $data = Service::whereRaw('id = ?', $request->id)->first();

        if ((file_exists(public_path('uploads/Services/' . $data->image))) && ($data->image != NULL)) {
            unlink("uploads/Services/" . $data->image);
        }

        $res = Service::where('id', $request->id)->delete();
        return $res;
    }
    public function changeServiceStatus(Request $request)
    {

        $res = Service::where('id', $request->id)
            ->update(['status' => $request->status]);

        return $res;
    }

    public function viewService(Request $request)
    {
        $data = Service::where('slug', $request->slug)->with('bookings')->first();
        return view('admin.service.view', ['data' => $data]);
    }
    public function editEnquiry(Request $request)
    {
        $data = ServiceBooking::where('id', $request->id)->first();
        return view('admin.enquiry.edit', ['data' => $data]);
    }
    public function updateEnquiry(Request $request)
    {

        $request->validate([
            'customer_name' => 'required',
            'phone_number' => 'required',
            'service_id' => 'required',
            // 'number' => 'required',
            // 'time' => 'required|date|date_format:h:i ',
            // 'date' => 'required'

        ]);
        $data = ServiceBooking::where('id', $request->id)->first();
        if ($data->status == 'Completed') {
            $res = ServiceBooking::where('id', $request->id)
                ->update([
                    'service_id' => $request->service_id,
                    'agent_id' => $request->agent,
                    'customer_name' => $request->customer_name,
                    'phone_number' => $request->phone_number,
                    'number' => $request->number,
                    'service_time' => date('h:i A', strtotime($request->time)),
                    'service_date' => date("y-m-d", strtotime($request->date)),
                    // 'status' => $request->status
                ]);
        } else {
            $res = ServiceBooking::where('id', $request->id)
                ->update([
                    'service_id' => $request->service_id,
                    'agent_id' => $request->agent,
                    'customer_name' => $request->customer_name,
                    'phone_number' => $request->phone_number,
                    'number' => $request->number,
                    // 'status' => $request->status
                ]);
        }

        if ($res == 1) {

            return redirect()->route('admin.edit-enquiry', ['id' => $request->id])->with('success', "Data updated successfully");
        } else {
            return back()->with('error', "Something Wrong");
        }
    }
    public function viewEnquiry(Request $request)
    {
        $data = ServiceBooking::where('id', $request->id)->first();
        return view('admin.enquiry.view', ['data' => $data]);
    }
    public function editService(Request $request)
    {
        $data = Service::where('slug', $request->slug)->first();
        return view('admin.service.edit', ['data' => $data]);
    }
    public function updateService(Request $request)
    {

        $data = Service::where('id', $request->id)->first();

        if ($request->title != $data->title) {
            $slug = SlugService::createSlug(Service::class, 'slug', $request->title);
            $params = [
                'title' => $request->title,
                'slug' =>  $slug,
                'code' => $request->code,
                'description' => $request->description,
                'commission' => $request->commission_amount,
                'apply_service_through' => $request->application_by,
                'telecalling_script'=> $request->telecalling_script,
                 'default_content'=>$request->default_content
            ];
        } else {
            $slug = $data->slug;
            $params = [
                'title' => $request->title,
                'code' => $request->code,
                'description' => $request->description,
                'commission' => $request->commission_amount,
                'apply_service_through' => $request->application_by,
                 'telecalling_script'=> $request->telecalling_script,
                 'default_content'=>$request->default_content
            ];
        }
        $request->validate([
            'title' => 'required',
            'commission_amount' => 'required',
            'description' => 'required',
            'application_by' => 'required',
            'code' => 'required'
        ]);
        try {
            $res = Service::where('id', $request->id)
                ->update($params);
        } catch (QueryException $e) {

            return back()->with(['error' => $e->getMessage(), 'data' => $data]);
        }
        if ($request->hasFile('image')) {
            $data = Service::whereRaw('id = ?', $request->id)->first();

            if ((file_exists(public_path('uploads/Services/' . $data->image))) && ($data->image != NULL)) {
                unlink("uploads/Services/" . $data->image);
            }
            $image = $request->image;
            $rand = rand(100, 999);
            $input['file'] = time() . $rand . '.' . $image->getClientOriginalExtension();

            $destinationPath = public_path('uploads/services');

            $imgFile = Image::make($image->getRealPath());
            $img = Image::make($image)
                // ->resize(870, 400)
                ->save($destinationPath . '/' . $input['file']);
            $img->save();
            try {
                $res = Service::where('id', $request->id)
                    ->update([
                        'image' => $input['file']
                    ]);
            } catch (QueryException $e) {

                return back()->with(['error' => $e->getMessage(), 'data' => $data]);
            }
        }

        try {
            if ($request->application_by == 'Link') {
                if ($request->onlinelink_id) {
                    $res =   UsefulLinks::where('id', $request->onlinelink_id)
                        ->update([
                            'service_id' => $request->id,
                            'link' => $request->link
                        ]);
                } else {
                    $plan = new UsefulLinks();
                    $plan->service_id = $request->id;
                    $plan->link = $request->link;
                    $plan->save();
                }
            }
        } catch (QueryException $e) {
            return back()->with(['error' => $e->getMessage(), 'data' => $data]);
        }

        //tutorial Links
        if ($request->dbtutoriallink) {
            $linkdata = $request->dbtutoriallink;
            for ($i = 0; $i < count($request->dbtutoriallink); $i++) {
                $res = UsefulLinks::where('id', $linkdata[$i])
                    ->update([
                        'service_id' => $request->id,
                        'link' => $linkdata[$i]
                    ]);
            }
        }

        $flag = 0;
        if ($request->tutoriallink[0] == '') {
            $flag = 1;
            $res = 1;
        }


        try {
            if ($flag == 0) {
                $linkdata = $request->tutoriallink;
                for ($i = 0; $i < count($request->tutoriallink); $i++) {
                    $plan = new TutorialLinks();
                    $plan->service_id = $request->id;
                    $plan->link = $linkdata[$i];
                    $plan->save();
                }
            }
        } catch (QueryException $e) {
            return back()->with(['error' => $e->getMessage(), 'data' => $data]);
        }

        if ($res == 1) {
            return redirect()->route('admin.edit-service', ['slug' => $slug])->with('success', 'Service Updated Successfully');
        } else {
            return back()->with('fail', 'something wrong');
        }
    }



    public function changeEnquiryStatus(Request $request)
    {

        try {

            $res = ServiceBooking::where('id', $request->id)
                ->update(['status' => $request->status,
                'declined_reason' => $request->reason]);

            if ($res != 1) return response()->json(['message' => 'No id recieved', 'status' => false], 200);

            if ($request->status == 'Completed') {
                $data = ServiceBooking::where('id', $request->id)->first();
                $service = Service::where('id', $data->service_id)->first();
                $agent = User::where('id', $data->agent_id)->first();
                $commission = $agent->total_commission + $service->commission;
                $agent_comm = User::where('id', $data->agent_id)
                    ->update(['total_commission' => $commission]);
            }

            return response()->json(['message' => 'Update Success', 'status' => true], 200);
        } catch (\Exception $exception) {
            return response()->json(['message' => $exception->getMessage(), 'status' => false], 500);
        }
    }

    public function deleteEnquiry(Request $request)
    {

        $res = ServiceBooking::where('id', $request->id)->delete();
        return $res;
    }

    public function getEnquiry(Request $request)
    {
        if ($request->ajax()) {
            $data = ServiceBooking::orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '  <a href="' . route('admin.view-enquiry', ['id' => $data->id]) . '" class="text-muted"> <span class="badge badge-success"><i class="far fa-eye"></i></span></a>  
                        <a href="' . route('admin.edit-enquiry', ['id' => $data->id]) . '" class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                    <a href="javascript:void(0);" data-id="' . $data->id . '" id="getBookingDeleteID" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('customer_name', function ($data) {
                    return '<p id="customer' . $data->id . '" data-value="' . $data->customer_name . '">' . $data->customer_name . '</p>';
                })
                ->addColumn('phone_number', function ($data) {
                    return  $data->phone_number;
                })
                ->addColumn('service', function ($data) {

                    $res = Service::where('id', $data->service_id)->first();
                    if (!empty($res)) {
                        return '<a href="' . route('admin.view-service', ['slug' => $res->slug]) . '"  id="service' . $data->id . '" data-value="' . $res->title . '"><span class="package-name">' . $res->title . '</span></a>';
                    } else {
                        return 'Service Not Available';
                    }
                })
                ->addColumn('agent', function ($data) {
                    $res = User::where('id', $data->agent_id)->first();
                    if (!empty($res)) {
                        if ($res->image != NULL) {
                            $img = 'uploads/agent/' . $res->image;
                        } else {
                            $img = 'assets/images/default-image.jpg';
                        }
                        $html = '<div class="dropdown-item profile-sec">
                <a href="' . route('admin.view-agent', ['slug' => $res->slug]) . '" id="agent' . $data->id . '" data-value="' . $res->id . '">
                  <img src="' . asset($img) . '" alt="agent" style="height:35px;">
                    <span>' . str::limit($res->name, 10) . '</span></a>
                </div>';
                        return  $html;
                    } else {
                        return 'Agent Not exist';
                    }
                })
                ->addColumn('status', function ($data) {
                    $class = '';
                    if ($data->status == 'Processing') {
                        $class = "warning";
                    } elseif ($data->status == 'Approved') {
                        $class = "success";
                    } elseif ($data->status == 'Completed') {
                        $class = "primary disabled";
                    }elseif ($data->status == 'Declined') {
                        $class = "danger";
                    }
                    return  '
<div class="dropdown show">
  <a class="btn btn-' . $class . ' dropdown-toggle"  style="color:#fff;font-size: 13px;"  title="Change Booking Status" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    ' . $data->status . '
  </a>

  <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
    <a class="dropdown-item badge badge-warning" data-id="' . $data->id . '" data-value="Processing" id="statuslist" href="#" style="color:#fff;font-size: 13px;">Processing</a>
    <a class="dropdown-item badge badge-success" data-id="' . $data->id . '" data-value="Approved" id="statuslist" href="#" style="color:#fff;font-size: 13px;">Approved</a>
    <a class="dropdown-item badge badge-primary" data-id="' . $data->id . '" data-value="Completed" id="statuslist" href="#" style="color:#fff;font-size: 13px;">Completed</a>
     <a class="dropdown-item badge badge-danger"   style="color:#fff;font-size: 13px;" data-toggle="modal" data-target="#exampleModal' . $data->id . '">Declined</a>
  </div>
 
<div class="modal fade" id="exampleModal' . $data->id . '" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add Declined Reason</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
      <textarea id="reason' . $data->id . '" row="3"></textarea>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary" data-dismiss="modal" data-id="' . $data->id . '" data-value="Declined" id="statuslist">Save changes</button>
      </div>
    </div>
  </div>
</div>
</div>';
                    // return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="statuslist"><span class="badge badge-' . $class . '">' . $status . '</span></a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function getServiceEnquiry(Request $request)
    {
        if ($request->ajax()) {
            $data = ServiceBooking::where('service_id', $request->id)->orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '  <a href="' . route('admin.view-enquiry', ['id' => $data->id]) . '" class="text-muted"> <span class="badge badge-success"><i class="far fa-eye"></i></span></a>
                    <a href="' . route('admin.edit-enquiry', ['id' => $data->id]) . '" class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>  
                              <a href="javascript:void(0);" data-id="' . $data->id . '" id="getBookingDeleteID" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('customer_name', function ($data) {
                    return '<p id="customer' . $data->id . '" data-value="' . $data->customer_name . '">' . $data->customer_name . '</p>';
                })
                ->addColumn('phone_number', function ($data) {
                    return  $data->phone_number;
                })
                ->addColumn('service', function ($data) {
                    $res = Service::where('id', $data->service_id)->first();
                    return '<a href="' . route('admin.view-service', ['slug' => $res->slug]) . '"  id="service' . $data->id . '" data-value="' . $res->title . '"><span class="package-name">' . $res->title . '</span></a>';
                })
                ->addColumn('agent', function ($data) {
                    $res = User::where('id', $data->agent_id)->first();
                    if (!empty($res)) {
                        if ($res->image != NULL) {
                            $img = 'uploads/agent/' . $res->image;
                        } else {
                            $img = 'assets/images/default-image.jpg';
                        }
                        $html = '<div class="dropdown-item profile-sec">
                <a href="' . route('admin.view-agent', ['slug' => $res->slug]) . '" id="agent' . $data->id . '" data-value="' . $res->id . '">
                  <img src="' . asset($img) . '" alt="agent" style="height:35px;">
                    <span>' . str::limit($res->name, 10) . '</span></a>
                </div>';
                        return  $html;
                    } else {
                        return 'Agent Not exist';
                    }
                })
                ->addColumn('status', function ($data) {
                    $class = '';
                    if ($data->status == 'Processing') {
                        $class = "warning";
                    } elseif ($data->status == 'Approved') {
                        $class = "success";
                    } elseif ($data->status == 'Completed') {
                        $class = "primary disabled";
                    }
                    return  '
<div class="dropdown show">
  <a class="btn btn-' . $class . ' dropdown-toggle" style="color:#fff;font-size: 13px;"  title="Change Booking Status" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    ' . $data->status . '
  </a>

  <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
    <a class="dropdown-item badge badge-warning" data-id="' . $data->id . '" data-value="Processing" id="statuslist" href="#" style="color:#fff;font-size: 13px;">Processing</a>
    <a class="dropdown-item badge badge-success" data-id="' . $data->id . '" data-value="Approved" id="statuslist" href="#" style="color:#fff;font-size: 13px;">Approved</a>
    <a class="dropdown-item badge badge-primary" data-id="' . $data->id . '" data-value="Completed" id="statuslist" href="#" style="color:#fff;font-size: 13px;">Completed</a>
  </div>
</div>';
                    // return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="statuslist"><span class="badge badge-' . $class . '">' . $status . '</span></a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }

    public function getAgentEnquiry(Request $request)
    {
        if ($request->ajax()) {
            $data = ServiceBooking::where('agent_id', $request->id)->orderBy('id', 'DESC')->get();
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($data) {
                    $actionBtn = '  <a href="' . route('admin.view-enquiry', ['id' => $data->id]) . '" class="text-muted"> <span class="badge badge-success"><i class="far fa-eye"></i></span></a>  
                             <a href="' . route('admin.edit-enquiry', ['id' => $data->id]) . '" class="text-muted"> <span class="badge badge-success"><i class="far fa-edit"></i></span></a>
                    <a href="javascript:void(0);" data-id="' . $data->id . '" id="getBookingDeleteID" class="text-muted"> <span class="badge badge-danger"><i class="far fa-trash-alt"></i></span></a>';
                    return $actionBtn;
                })
                ->addColumn('customer_name', function ($data) {
                    return '<p id="customer' . $data->id . '" data-value="' . $data->customer_name . '">' . $data->customer_name . '</p>';
                })
                ->addColumn('phone_number', function ($data) {
                    return  $data->phone_number;
                })
                ->addColumn('service', function ($data) {
                    $res = Service::where('id', $data->service_id)->first();
                    if (!empty($res)) {
                        return '<a href="' . route('admin.view-service', ['slug' => $res->slug]) . '"  id="service' . $data->id . '" data-value="' . $res->title . '"><span class="package-name">' . $res->title . '</span></a>';
                    } else {
                        return 'Service Not Available';
                    }
                })
                ->addColumn('agent', function ($data) {
                    $res = User::where('id', $data->agent_id)->first();

                    if ($res->image != NULL) {
                        $img = 'uploads/agent/' . $res->image;
                    } else {
                        $img = 'assets/images/default-image.jpg';
                    }
                    $html = '<div class="dropdown-item profile-sec">
                <a href="' . route('admin.view-agent', ['slug' => $res->slug]) . '" id="agent' . $data->id . '" data-value="' . $res->id . '">
                  <img src="' . asset($img) . '" alt="agent" style="height:35px;">
                    <span>' . str::limit($res->name, 10) . '</span></a>
                </div>';
                    return  $html;
                })
                ->addColumn('status', function ($data) {
                    $class = '';
                    if ($data->status == 'Processing') {
                        $class = "warning";
                    } elseif ($data->status == 'Approved') {
                        $class = "success";
                    } elseif ($data->status == 'Completed') {
                        $class = "primary disabled";
                    }
                    return  '
<div class="dropdown show">
  <a class="btn btn-' . $class . ' dropdown-toggle" style="color:#fff;font-size: 13px;"  title="Change Booking Status" href="#" role="button" id="dropdownMenuLink" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
    ' . $data->status . '
  </a>

  <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
    <a class="dropdown-item badge badge-warning" data-id="' . $data->id . '" data-value="Processing" id="statuslist" href="#" style="color:#fff;font-size: 13px;">Processing</a>
    <a class="dropdown-item badge badge-success" data-id="' . $data->id . '" data-value="Approved" id="statuslist" href="#" style="color:#fff;font-size: 13px;">Approved</a>
    <a class="dropdown-item badge badge-primary" data-id="' . $data->id . '" data-value="Completed" id="statuslist" href="#" style="color:#fff;font-size: 13px;">Completed</a>
  </div>
</div>';
                    // return '<a href="javascript:void(0)" data-id="' . $data->id . '" data-value="' . $val . '" id="statuslist"><span class="badge badge-' . $class . '">' . $status . '</span></a>';
                })
                ->escapeColumns([])

                ->make(true);
        }
    }
    public function addNote(Request $request)
    {

        $request->validate([
            'note' => 'required',
        ]);

        try {

            $note = new Note;
            $note->service_id = $request->service;
            $note->agent_id = $request->agent;
            $note->note = $request->note;
            $res =  $note->save();
            if ($res == 1) {

                return back()->with('success', "Note Added Successfully");
            } else {
                return back()->with('error', "Something Wrong");
            }
        } catch (QueryException $e) {

            return back()->with('error', $e->getMessage());
        }
    }
    public function deleteNote(Request $request)
    {

        $res = Note::where('id', $request->id)->delete();
        return $res;
    }
}
